% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLMR.R
\name{llm_config}
\alias{llm_config}
\title{Create LLM Configuration}
\usage{
llm_config(
  provider,
  model,
  api_key,
  troubleshooting = FALSE,
  base_url = NULL,
  embedding = NULL,
  ...
)
}
\arguments{
\item{provider}{Provider name (openai, anthropic, groq, together, voyage, gemini, deepseek)}

\item{model}{Model name to use}

\item{api_key}{API key for authentication}

\item{troubleshooting}{Prints out all api calls. USE WITH EXTREME CAUTION as it prints your API key.}

\item{base_url}{Optional base URL override}

\item{embedding}{Logical indicating embedding mode: NULL (default, uses prior defaults), TRUE (force embeddings), FALSE (force generative)}

\item{...}{Additional provider-specific parameters}
}
\value{
Configuration object for use with call_llm()
}
\description{
Create LLM Configuration
}
\examples{
\dontrun{
  openai_config <- llm_config(
    provider = "openai",
    model = "gpt-4o-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    temperature = 0.7,
    max_tokens = 500)
}
}
