\name{LEAPFrOG}
\alias{LEAPFrOG}
\title{LEAPFrOG}
\description{Provides estimates of admixture proportions and parental divergence of these admixture proportions }
\usage{
LEAPFrOG(data,p,Nudge=0.001,NonLinCon=TRUE)
}
\arguments{
\item{data}{Vector of  allele counts: each element either 0,1,2 or NA. }
\item{p}{Matrix of allele frequencies. Each row corresponds with a SNP. Number of rows must equal length of data. Each column is a population }
\item{Nudge}{D for population 1 will be initialised at 0.5+Nudge. Nudge must be greater than 0. In theory the value for Nudge shouldn't affect the final optimum, but may influence the time to convergence. Default is 0.001.}
\item{NonLinCon}{If TRUE (default), the auglag optimisation function is invoked with a nonlinear constraint imposed on D*m, preventing impossible admixture totals of >1 in the parents. We strongly advise this option}
}
\value{
A  list including elements
\item{m}{A vector of admixture proportions in the genotyped offspring, one proportion per population. These sum to 1.}
\item{D}{A vector of parental divergence paramaters, one per population.}
\item{mse}{A vector of length number of populations-. Standard errors for all m estimates save the last populaion }
\item{Dse}{ A vector of length number of populations-. Standard errors for all D estimates save the last populaion }
\item{P1}{Admixture proportions for each population, for parent 'A', derived from the m and D estimates.}
\item{P2}{Admixture proportions for each population, for parent 'B', derived from the m and D estimates}
\item{value}{Value of the optimised likelihood function.}
\item{counts}{Number of times the likelihood function and gradient function were called during optimisation.}
}
\details{
Standard errors returned in the order P-1 m parameters followed by P-1 D parameters. m and D for the Pth population are not estimated directly and  have no standard error.
}
\author{Daniel Crouch & Michael Weale, Department of Medical and Molecular Genetics, King's College London}
\examples{
#Example with nonsense data - 10000 random SNP genotypes and uniform, random allele frequencies from two populations.
library(LEAPFrOG)
z1=LEAPFrOG(sample(0:2,10000,replace=TRUE),cbind(runif(10000,0,1),runif(10000,0,1)))
z1}
\seealso{\code{\link[LEAPFrOG:LEAPFrOG_plot]{LEAPFrOG_plot}},\code{\link[LEAPFrOG:LEAPFrOG_EM]{LEAPFrOG_EM}},\code{\link[LEAPFrOG:BEAPFrOG]{BEAPFrOG}}
}
