\name{LDcorSV-package}
\alias{LDcorSV-package}
\alias{LDcorSV}
\docType{package}
\title{LDcorSV}

\description{The package provides a set of functions which aim is to propose four measures of linkage disequilibrium:
- \code{Measure.R2}: the usual \eqn{r^2} measure.

- \code{Measure.R2S}:  \eqn{r^2} corrected by the structure of the sample (\eqn{r^2_S}).

- \code{Measure.R2V}: \eqn{r^2} corrected by the relatedness of genotyped individuals (\eqn{r^2_V}).

- \code{Measure.R2VS}: \eqn{r^2} corrected by both the relatedness of genotyped individuals  and the structure of the sample (\eqn{r^2_VS}).

- \code{LD.Measures}: this function computes the four measures of linkage disequilibrium (\eqn{r^2}, \eqn{r^2_V}, 
\eqn{r^2_S} and \eqn{r^2_{VS}}) for a set of loci and gives extra information about them.
}

\author{David Desrousseaux, Florian Sandron, Aurélie Siberchicot, Christine Cierco-Ayrolles and Brigitte Mangin 

Maintainer: aurelie.siberchicot@univ-lyon1.fr
}

\references{Mangin, B., Siberchicot, A., Nicolas, S., Doligez, A., This, P., Cierco-Ayrolles, C. (2012). Novel measures of linkage disequilibrium that correct the bias due to population structure and relatedness. Heredity, 108 (3), 285-291. DOI: 10.1038/hdy.2011.73}

\keyword{package}