% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDM_fun.R
\name{unifrac.mean}
\alias{unifrac.mean}
\title{Expected value of the unweighted UniFrac distance matrix}
\usage{
unifrac.mean(
  otu.table,
  tree,
  rarefy.depth = min(rowSums(otu.table)),
  first.order.approx.only = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{otu.table}{the \code{n.obs} by \code{n.otu} matrix of read counts.}

\item{tree}{the phylogeneic tree.}

\item{rarefy.depth}{rarefaction depth. The default is the minimum library size observed in the OTU table.}

\item{first.order.approx.only}{a logical value indicating whether to calculate the expected value 
using the first order approixmation by the delta method. The default is FALSE, 
using the second order approixmation.}

\item{verbose}{a logical value indicating whether to generate verbose output. Default is TRUE.}
}
\value{
a list consisting of 
  \item{unifrac.mean.o1}{Expected unweighted UniFrac distance matrix by the first order approixmation.}
  \item{unifrac.mean.o2}{Expected unweighted UniFrac distance matrix by the second order approixmation.} 
  \item{unifrac.mean.sq.o1}{Expected squared unweighted UniFrac distance matrix by the first order approixmation.} 
  \item{unifrac.mean.sq.o2}{Expected squared unweighted UniFrac distance matrix by the second order approixmation.}
}
\description{
This function computes the expected value of the unweighted UniFrac distance matrix over rarefaction replicates.
}
\examples{
data(throat.otu.tab5)
data(throat.tree)
res.unifrac <- unifrac.mean( throat.otu.tab5[1:20,], throat.tree)
}
\author{
Yi-Juan Hu <yijuan.hu@emory.edu>, Glen A. Satten <gsatten@emory.edu>
}
\keyword{microbiome}
