% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsK.R
\name{plotAIP_TGVrnc}
\alias{plotAIP_TGVrnc}
\title{Plots AIP variance versus increasing triglyceride variance}
\usage{
plotAIP_TGVrnc(TGVars, AIPVrncErrProp, AIPVrncErrProp2Ord, AIPbootVrnc)
}
\arguments{
\item{TGVars}{A data frame with increasing variances of triglycerides.}

\item{AIPVrncErrProp}{A vector with the first order error propagation
variances of AIP when the triglyceride variance increases.}

\item{AIPVrncErrProp2Ord}{A vector with the second order error propagation
variances of AIP when the triglyceride variance increases.}

\item{AIPbootVrnc}{A vector with the bootstrap
variances of AIP when the triglyceride variance increases.}
}
\value{
The function creates a plot with the AIP error propagation and
bootstrap variances versus increasing  triglyceride variance.
}
\description{
Plots the variance of AIP (both Error Propagation first and
second order, as well as Bootstrap variance) versus increasing triglyceride variance.
}
\examples{
\donttest{
# AIP - TG Variance
TGVariances = CV_Range(sampleA$TG,15,16,plot=FALSE)
AIPVrncChngTGVrnc = AIP_TGVrnc(TGVariances,sampleA$HDL,bootStrpReps = 2000)
TGErrPropVrnc = AIPVrncChngTGVrnc$ErrPropVrnc
TGErrPropVrnc2Ord = AIPVrncChngTGVrnc$ErrPropVrnc2Ord
TGBootVrnc = AIPVrncChngTGVrnc$BootVrnc
plotAIP_TGVrnc(TGVariances,TGErrPropVrnc,TGErrPropVrnc2Ord,TGBootVrnc)
}
}
