% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.lawbl.R
\name{summary.lawbl}
\alias{summary.lawbl}
\title{Summary method for \code{lawbl} objects}
\usage{
\method{summary}{lawbl}(
  object,
  what = "basic",
  med = FALSE,
  SL = 0.05,
  detail = FALSE,
  digits = 4,
  ...
)
}
\arguments{
\item{object}{A \code{lawbl} object}

\item{what}{A list of options for what to summarize.

\itemize{
    \item \code{basic}: Basic information about the model and posteriors.
    \item \code{lambda}: Loading estimates.
    \item \code{qlambda}: Loading estimates in pattern/Q-matrix format.
    \item \code{eigen}: Factorial eigen value.
    \item \code{dpsx}: Diagonal elements in the residual covariance matrix \code{PSX}.
    \item \code{offpsx}: Off-diagonal elements in \code{PSX}; local dependence terms.
    \item \code{phi}: Factorial correlations.
    \item \code{thd}: Threshold estimates.
    \item \code{int}: Intercept estimates (for  \code{\link{pcirm}} only).
    \item \code{shrink}: (Ave) shrinkage for each factor's loadings and LD (if \code{LD} in \code{pcfa} = T).
    \item \code{factor}: Are the factors true of not (for EFA).
    \item \code{all}: All above information.
 }}

\item{med}{logical; if the posterior median (\code{TRUE}) or mean (\code{FALSE}) is used as the estimate.}

\item{SL}{Significance level for interval estimate. The default is .05.}

\item{detail}{logical; if only significant (\code{FALSE}) or all (\code{TRUE}) estimates are presented.}

\item{digits}{Number of significant digits to print when printing numeric values.}

\item{...}{additional arguments}
}
\value{
A list or matrix containing the summarized information based on the option \code{what}.
}
\description{
Provide summaries of posterior information for a \code{lawbl} object, .
}
\examples{
\donttest{
dat <- sim18cfa0$dat
J <- ncol(dat)
K <- 3
Q<-matrix(-1,J,K);
Q[1:2,1]<-Q[7:8,2]<-Q[13:14,3]<-1

m0 <- pcfa(dat = dat, Q = Q, LD = FALSE,burn = 1000, iter = 1000)
summary(m0) # summarize basic information
summary(m0, what = 'lambda') #summarize significant loadings
summary(m0, what = 'qlambda') #summarize significant loadings in pattern/Q-matrix format
summary(m0, what = 'offpsx') #summarize significant LD terms
}
}
