#' LAWBL: Latent (Variable) Analysis with Bayesian Learning
#'
#' @description The long-term goal of this package is to provide an analytical framework for
#' modeling latent variables with different Bayesian learning methods.
#'
#'
#' @details
#' Currently, this package includes the Partially Confirmatory Factor Analysis (PCFA) model for continuous data
#'  (Chen, Guo, Zhang, & Pan, 2020), the generalized PCFA (GPCFA) model covering continuous, categorical, and mixed-type data,
#'  and the partially confirmatory item response model (PCIRM) for continuous and dichotomous data with intercept terms (Chen, 2020).
#'  The three models represent a partially confirmatory approach covering a wide range of the exploratory-confirmatory continuum
#'  under the context of factor analysis and item response theory. For PCFA, GPCFA, and PCIRM, there are two major model variants
#'  with different constraints for identification. One assumes local  independence (LI) with a more exploratory tendency,
#'  which can be also called the E-step. The other allows local dependence (LD) with a more confirmatory tendency, which can be also
#'  called the C-step. Parameters are obtained by sampling from the posterior distributions with the Markov chain Monte Carlo (MCMC)
#'  techniques. Different Bayesian Lasso methods are used to regularize the loading pattern and local dependence.
#'
#'
#' @name LAWBL-package
#' @aliases LAWBL
#' @docType package
#'
#' @author {Jinsong Chen, \email{jinsong.chen@live.com}}
#'
#' @note This package is under development. You are very welcome to send me any comments or
#'  suggestions for improvements, and to share with me any problems you may encounter with
#'   the use of this package.
#'
#'
#' @import stats
#' @import MASS
#' @import coda
#'
#' @references
#'
#' Chen, J., Guo, Z., Zhang, L., & Pan, J. (2020). A partially confirmatory approach to scale development
#'  with the Bayesian Lasso. \emph{Psychological Methods}. Advance online publication. DOI:10.1037/met0000293
#'
#'
#'Chen, J. (2020). A partially confirmatory approach to the multidimensional item response theory
#'with the Bayesian Lasso. \emph{Psychometrika}. 85(3), 738-774. DOI:10.1007/s11336-020-09724-3.
#'
#' @keywords package
NULL

