% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOM.R
\name{MOM}
\alias{MOM}
\title{Calculate the moment matrix of an order-of-addition design}
\usage{
MOM(X)
}
\arguments{
\item{X}{A matrix object. \code{X} must be an order-of-addition design (OofA) matrix.}
}
\value{
If the input is logical, then the output will be a \code{1+{k \\choose 2}} by \code{1+{k \\choose 2}} matrix, where \code{k} is the factor size of the input OofA.
}
\description{
\code{PWO} returns the moment matrix of an order-of-addition design
}
\examples{
#create a full OofA with 3 factors.
toy=rOofA(k=3);toy

#Calculate the moment matrix of toy 
MOM(X=toy)
}
\references{
Lin, D. K., and Peng, J. (2019) Order-of-addition experiments: A review and some new thoughts. \emph{Quality Engineering}, \strong{31}, 49-59.
}
