% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KRIG.R
\docType{package}
\name{KRIG-package}
\alias{KRIG}
\alias{KRIG-package}
\title{Spatial Statistics with Kriging}
\description{
Implements different methods for spatial statistics, in particular focused with 
Kriging based models. We count with different implemented models, simple, ordinary and 
universal forms of Kriging, co-Kriging and regression Kriging models. Includes, multivariate 
sensitivity analysis under an approximation designed over reproducing kernel Hilbert spaces and 
computation of Sobol indexes under this framework.

The linear algebra operations are supported by RcppArmadillo.
}
\examples{
library( KRIG )
vignette( topic = 'copper_mining_2d', package = 'KRIG' )

}
\references{
\insertRef{MatheronTH1970}{KRIG}

\insertRef{Chiles2011Geos}{KRIG}

\insertRef{Kanova:2013}{KRIG}

\insertRef{Rasmussen2005GPML}{KRIG}

\insertRef{SteinInterSpatial}{KRIG}

\insertRef{Clark1979Geo}{KRIG}

\insertRef{Aronszajn:ThRK}{KRIG}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/pedroguarderas/KRIG}
  \item Report bugs at \url{https://github.com/pedroguarderas/KRIG/issues}
}

}
\author{
\strong{Maintainer}: Pedro Guarderas \email{pedro.felipe.guarderas@gmail.com}

Other contributors:
\itemize{
  \item Daniel Lagos [contributor]
  \item Andrés Lopez [contributor]
}

}
