% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KPC.R
\name{KPCRKHS_VS}
\alias{KPCRKHS_VS}
\title{Variable selection with RKHS estimator}
\usage{
KPCRKHS_VS(
  Y,
  X,
  num_features,
  ky = kernlab::rbfdot(1/(2 * stats::median(stats::dist(Y))^2)),
  kS = NULL,
  eps = 0.001,
  appro = FALSE,
  tol = 1e-05,
  numCores = 1,
  verbose = FALSE
)
}
\arguments{
\item{Y}{a matrix of responses (n by dy)}

\item{X}{a matrix of predictors (n by dx)}

\item{num_features}{the number of variables to be selected, cannot be larger than dx.}

\item{ky}{a function \eqn{k(y, y')} of class \code{kernel}. It can be the kernel implemented in \code{kernlab} e.g. Gaussian kernel: \code{rbfdot(sigma = 1)}, linear kernel: \code{vanilladot()}}

\item{kS}{a function that takes X and a subset of indices S as inputs, and then outputs the kernel for X_S. The first argument of kS is X, and the second argument is a vector of positive integer. If \code{kS == NULL}, Gaussian kernel with empitical bandwidth will be used, i.e., \code{kernlab::rbfdot(1/(2*stats::median(stats::dist(X[,S]))^2))}}

\item{eps}{a positive number; the regularization parameter for the RKHS estimator}

\item{appro}{whether to use incomplete Cholesky decomposition for approximation}

\item{tol}{tolerance used for incomplete Cholesky decomposition (\code{inchol} in package \code{kernlab})}

\item{numCores}{number of cores that are going to be used for parallelizing the process.}

\item{verbose}{whether to print each selected variables during the forward stepwise algorithm}
}
\value{
The algorithm returns a vector of the indices from \code{1,...,dx} of the selected variables
}
\description{
The algorithm performs a forward stepwise variable selection using RKHS estimators.
}
\details{
A stepwise forward selection of variables using KPC. At each step the \eqn{Xj} maximizing \eqn{\tilde{\rho^2}(Y,X_j | selected X_i)} is selected.
It is suggested to normalize the features before applying the algorithm.
}
\examples{
n = 200
p = 10
X = matrix(rnorm(n * p), ncol = p)
Y = X[, 1] * X[, 2] + sin(X[, 1] * X[, 3])
library(kernlab)
kS = function(X,S) return(rbfdot(1/length(S)))
KPCRKHS_VS(Y, X, num_features = 3, rbfdot(1), kS, eps = 1e-3, appro = FALSE, numCores = 1)
kS = function(X,S) return(rbfdot(1/(2*stats::median(stats::dist(X[,S]))^2)))
KPCRKHS_VS(Y, X, num_features = 3, rbfdot(1), kS, eps = 1e-3, appro = FALSE, numCores = 1)
}
\seealso{
\code{\link{KPCgraph}}, \code{\link{KPCRKHS}}
}
