\name{multi_continuous_table}

\alias{multi_continuous_table}

\title{Continuous Information}

\description{Summarization of the continuous information.}

\usage{
multi_continuous_table (data, 
                        label, 
                        digits = 0, 
                        scientific = FALSE,
                        range=c("IQR","95\%CI"),
                        logchange=FALSE)                   
}

\arguments{
  \item{data}{the matrix containing the continuous values. Each row corresponds to a different sample. Each column corresponds to a different variable.}
  \item{label}{the classification of the cohort.}
  \item{digits}{how many significant digits are to be used.}
  \item{scientific}{either a logical specifying whether result should be encoded in scientific format.}
  \item{range}{the range to be visualized.}
  \item{logchange}{either a logical specifying whether log2 of fold change  should be visualized.}
}

\value{
    The function returns a table with the summarized information. If the number of group is equal to two, the p-value is computed using the Wilcoxon rank-sum test, Kruskal-Wallis test otherwise.
  }
\references{
Cacciatore S, Luchinat C, Tenori L	\cr
Knowledge discovery by accuracy maximization.\cr
\emph{Proc Natl Acad Sci U S A} 2014;111(14):5117-22. doi: 10.1073/pnas.1220873111. \href{https://www.pnas.org/content/111/14/5117}{Link}
\cr	\cr
Cacciatore S, Tenori L, Luchinat C, Bennett PR, MacIntyre DA	\cr
KODAMA: an updated R package for knowledge discovery and data mining.	\cr
\emph{Bioinformatics} 2017;33(4):621-623. doi: 10.1093/bioinformatics/btw705. \href{https://academic.oup.com/bioinformatics/article/doi/10.1093/bioinformatics/btw705/2667156/KODAMA-an-R-package-for-knowledge-discovery-and}{Link}
}
\author{Stefano Cacciatore}

  \seealso{\code{\link{continuous_table}}, \code{\link{categorical_table}}, \code{\link{txtsummary}}}

\examples{
data(clinical)


multi_continuous_table(data=clinical[,c("BMI","Age")],digits = 1,label=clinical[,"Hospital"])

}
\keyword{multi_continuous_table}