% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MFKMO.R
\name{MFKMO}
\alias{MFKMO}
\title{Optimal KM for Quantitative Traits in Multivariate Family GWAS Data (calculate p-value)}
\usage{
MFKMO(obj, genotypes, weights = NULL, acc = 1e-04, acc2 = 1e-04,
  r.all = c(0, 0.25, 0.5, 0.75, 1), append.write = NULL,
  eq.gen.effect = F)
}
\arguments{
\item{obj}{results saved from MFKMO_Null_Model.}

\item{genotypes}{1st column: gene name; 2nd column: snp name; 3rd-end columns: A matrix of genotypes for each subject (class: data.frame). The order of 3rd-end columns should match unique(yid). Coded as 0, 1, 2 and no missing. This genotype file can be a big file containing all genes or it can be files containing one single gene.}

\item{weights}{1st column: gene name; 2nd column: snp name; 3rd column: A vector with the length equal to the number of variants in the test (class: data.frame). Default is Null indicating equal weight for all markers}

\item{acc}{Accuracy of numerical integration used in Davies' method for individual r.all p-values. Default 1e-4.}

\item{acc2}{Accuracy of numerical integration used in Davies' method for the final p-value. Default 1e-4.}

\item{r.all}{A list of predefined proportion of linear kernel and burden test. When r.all=0, regular kernel machine test (MFKM); when r.all=1, burden test.}

\item{append.write}{The name of pvalue output file. Write out p-values in real time. Don't need to wait until all genes are processed to get the final output.}

\item{eq.gen.effect}{Whether assume equal genetic effects on different traits (default = False).}
}
\value{
output: optimal multivariate family KM (MF-KMO) p-value
}
\description{
This function (MFKMO) is used to perform optimal KM analysis for quantitative traits in GWAS multivariate family data.
}
\examples{
############################################################################
### Examples for Multivariate (two) Continuous Traits in Familial GWAS Data
############################################################################
######################
# using optimal KM ###
######################
### Subject IDs are numeric ###
data("MFKM_numID")
obj1 <- MFKMO_Null_Model(phenotype=mfkm_n_y$y, trait=mfkm_n_y$trait, yid=mfkm_n_y$id,
gid=mfkm_n_geneid$gid, fa=mfkm_n_geneid$fa, mo=mfkm_n_geneid$mo, covariates=NULL,
Ninitial=3)
pvalue1 <- MFKMO(obj=obj1, genotypes=mfkm_n_gene, weights=NULL, append.write=
"./pvalues.out")
# Read in a list of genes files instead of a big file containing all genes
obj <- MFKMO_Null_Model(phenotype=mfkm_n_y$y, trait=mfkm_n_y$trait, yid=mfkm_n_y$id,
gid=mfkm_n_geneid$gid, fa=mfkm_n_geneid$fa, mo=mfkm_n_geneid$mo, covariates=NULL,
Ninitial=1)
gene <- split(mfkm_n_gene, mfkm_n_gene[,1])
for (k in 1:2) {
  gene[[k]]$gene <- as.character(gene[[k]]$gene)
  pvalue1 <- MFKMO(obj=obj, genotypes=gene[[k]], weights=NULL, append.write=
  "./pvalues.out")
}
### Subject IDs are character ###
data("MFKM_charID")
obj1 <- MFKMO_Null_Model(phenotype=mfkm_c_y$y, trait=mfkm_c_y$trait,
yid=as.character(mfkm_c_y$id),
gid=as.character(mfkm_c_geneid$gid), fa=as.character(mfkm_c_geneid$fa),
mo=as.character(mfkm_c_geneid$mo), covariates=NULL, Ninitial=1)
pvalue1 <- MFKMO(obj=obj1, genotypes=mfkm_c_gene, weights=NULL)
}

