% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trioPI.R
\name{trioPI}
\alias{trioPI}
\title{LR in standard trio cases}
\usage{
trioPI(
  AR,
  C,
  TP,
  af,
  rare = NULL,
  allelename = FALSE,
  muAtoC = 0.002,
  muTtoC = 0.002/3.5,
  kappa1 = 1
)
}
\arguments{
\item{AR}{Genotype of the alleged relative, which should be data.frame with 2 columns and ss rows, where ss stand for sample size;}

\item{C}{Genotype of the child, see in \code{AR} for the data form}

\item{TP}{Genotype of the confirmed parent of the child, see in \code{AR} for the data form}

\item{af}{name of allele frequency matrix, a data.frame of 1 column containing frequencies with allele names being row names}

\item{rare}{frequency of rare allele on the locus}

\item{allelename}{if TRUE, the input genotype data would be regarded as allelenames, otherwise, the position in the af matrix}

\item{muAtoC}{mutation rate from \code{AR} to \code{C} if AR is alleged to be the child's parent, with a default of 0.002, please note that mistakes would be introduced if the mutation rate is larger than 0.2}

\item{muTtoC}{mutation rate from \code{TP} to \code{C}, with a default of 0.002/3.5, please note that mistakes would be introduced if the mutation rate is larger than 0.2}

\item{kappa1}{kappa_1 of the alleged relationship between AR and C, with a default of 1, meaning the AR is alleged to be the other parent of C}
}
\value{
a data.frame containing \code{ss} rows and 1 column, containing the log10 of LR for each group
}
\description{
Calculating LR in cases where 3 participants being available, a child, his/her biological mother (or father) whose parentage is confirmed, and a male (or female) who is unrelated to the confirmed parent and alleged to be specific relative of the child, usually the father. Null hypothesis, i.e., that the alleged participant is unrelated to the child, is taken as Hd.
}
\details{
If any one of TP or AR cannot provide any of the C's alleles through integer steps, \code{muAtoC} would be output when calculating PI, and under other situations, the case with minimum mutation steps, (AR to C)+(TP to C) under Hp and (TP to C) under Hd, would be considered. Much more is required for further discussion in PI calculation involving mutations.
}
\examples{
# PI calculation in standard trio paternity testing when the Hp is true
pedi <- data.frame(Person=c("F","M","C"),Father=c("RI","RI","F"),Mother=c("RI","RI","M"))
Genotype<-pedisimu(af = FortytwoSTR$afmatrix[[1]],ss = 10000,pedi = pedi)
PI_1<-trioPI(AR=Genotype[,1:2],TP=Genotype[,3:4],C=Genotype[,5:6],af=FortytwoSTR$afmatrix[[1]],
rare=FortytwoSTR$rare[1])

# PI calculation in standard trio paternity testing when the Hd is true
pedi <- data.frame(Person=c("F","M","C"),Father=c("RI","RI","RI"),Mother=c("RI","RI","M"))
Genotype<-pedisimu(af = FortytwoSTR$afmatrix[[1]],ss = 10000,pedi = pedi)
PI_2<-trioPI(AR=Genotype[,1:2],TP=Genotype[,3:4],C=Genotype[,5:6],af=FortytwoSTR$afmatrix[[1]],
rare=FortytwoSTR$rare[1])

# AI with the participant of the child's mother
pedi <- data.frame(Person=c("GF","GM","AR","F","M","C"),
Father=c("RI","RI","GF","GF","RI","F"),
Mother=c("RI","RI","GM","GM","RI","M"))
Genotype<-pedisimu(af = FortytwoSTR$afmatrix[[1]],ss = 10000,pedi = pedi)
PI_2<-trioPI(AR=Genotype[,5:6],TP=Genotype[,9:10],C=Genotype[,11:12],af=FortytwoSTR$afmatrix[[1]],
rare=FortytwoSTR$rare[1],kappa1=0.5)

}
