% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comm_open.R
\name{comm_open}
\alias{comm_open}
\title{Inspect Handler}
\usage{
comm_open(request_msg)
}
\arguments{
\item{request_msg}{A list passed in from \code{doRequest} representing the
deserialized \code{inspect_request} message JSON.}
}
\value{
A list having names \code{msg_type} and \code{content}. The
  \code{msg_type} is \code{inspect_reply}, which corresponds
  to the \code{inspect_request} message. The \code{content} field
  complies with the Jupyter wire message protocol specification
  for \code{inspect_reply} messages.
}
\description{
Handler for the inspect_request Message Type
}
\examples{
\dontrun{
  request_msg <- list("comm_id"="uniq_comm_id", "target_name"="my_comm", "data"=list())
  comm_open(request_msg)
}

}
\references{
\url{http://jupyter-client.readthedocs.io/en/latest/messaging.html#introspection}
}
\author{
Spencer Aiello
}
