% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_list.R
\name{default_hyperpars}
\alias{default_hyperpars}
\title{Get the default values for hyper-parameters}
\usage{
default_hyperpars()
}
\description{
This function returns a list of default values for the hyper-parameters.
}
\details{
\strong{norm:} hyper-parameters for normal and log-normal models
\tabular{ll}{
\code{mu_reg_norm} \tab mean in the priors for regression coefficients\cr
\code{tau_reg_norm} \tab precision in the priors for regression
coefficients\cr
\code{shape_tau_norm} \tab shape parameter in Gamma prior for the precision
of the (log-)normal distribution\cr
\code{rate_tau_norm} \tab rate parameter in Gamma prior for the precision
of the (log-)normal distribution\cr
}

\strong{gamma:} hyper-parameters for Gamma models
\tabular{ll}{
\code{mu_reg_gamma} \tab mean in the priors for regression coefficients\cr
\code{tau_reg_gamma} \tab precision in the priors for regression
coefficients\cr
\code{shape_tau_gamma} \tab shape parameter in Gamma prior for the precision
of the Gamma distribution\cr
\code{rate_tau_gamma} \tab rate parameter in Gamma prior for the precision
of the Gamma distribution
}

\strong{beta:} hyper-parameters for beta models
\tabular{ll}{
\code{mu_reg_beta} \tab mean in the priors for regression coefficients\cr
\code{tau_reg_beta} \tab precision in the priors for regression
coefficients\cr
\code{shape_tau_beta} \tab shape parameter in Gamma prior for the precision
of the beta distribution\cr
\code{rate_tau_beta} \tab rate parameter in Gamma prior for precision of the
of the beta distribution
}

\strong{binom:} hyper-parameters for binomial models
\tabular{ll}{
\code{mu_reg_binom} \tab mean in the priors for regression coefficients\cr
\code{tau_reg_binom} \tab precision in the priors for regression coefficients
}

\strong{poisson:} hyper-parameters for poisson models
\tabular{ll}{
\code{mu_reg_poisson} \tab mean in the priors for regression coefficients\cr
\code{tau_reg_poisson} \tab precision in the priors for regression
coefficients
}

\strong{multinomial:} hyper-parameters for multinomial models
\tabular{ll}{
\code{mu_reg_multinomial} \tab mean in the priors for regression
coefficients\cr
\code{tau_reg_multinomial} \tab precision in the priors for regression
coefficients
}

\strong{ordinal:} hyper-parameters for ordinal models
\tabular{ll}{
\code{mu_reg_ordinal} \tab mean in the priors for regression coefficients\cr
\code{tau_reg_ordinal} \tab precision in the priors for regression
coefficients\cr
\code{mu_delta_ordinal} \tab mean in the prior for the intercepts\cr
\code{tau_delta_ordinal} \tab precision in the priors for the intercepts
}

\strong{ranef:} hyper-parameters for the random effects variance-covariance
matrices (when there is only one random effect a Gamma distribution is used
instead of the Wishart distribution)
\tabular{ll}{
\code{shape_diag_RinvD} \tab shape parameter in Gamma prior for the diagonal
elements of \code{RinvD}\cr
\code{rate_diag_RinvD} \tab rate parameter in Gamma prior for the diagonal
elements of \code{RinvD}\cr
\code{KinvD_expr} \tab a character string that can be evaluated to calculate
the number of degrees of freedom in the Wishart
distribution used for the inverse of the
variance-covariance matrix for random effects,
depending on the number of random effects
\code{nranef}
}

\strong{surv:} parameters for survival models (\code{survreg}, \code{coxph}
and \code{JM})
\tabular{ll}{
\code{mu_reg_surv} \tab mean in the priors for regression coefficients\cr
\code{tau_reg_surv} \tab precision in the priors for regression coefficients
}
}
\note{
\strong{From the
\href{https://sourceforge.net/projects/mcmc-jags/files/Manuals/}{JAGS user
manual}
on the specification of the Wishart distribution:}\cr
For \code{KinvD} larger than the dimension of the variance-covariance matrix
the prior on the correlation between the random effects is concentrated
around 0, so that larger values of \code{KinvD} indicate stronger prior
belief that the elements of the multivariate normal distribution are
independent.
For \code{KinvD} equal to the number of random effects the Wishart prior
puts most weight on the extreme values (correlation 1 or -1).
}
\examples{
default_hyperpars()

# To change the hyper-parameters:
hyp <- default_hyperpars()
hyp$norm['rate_tau_norm'] <- 1e-3
mod <- lm_imp(y ~ C1 + C2 + B1, data = wideDF, hyperpars = hyp, mess = FALSE)


}
