/*
 * Decompiled with CFR 0.152.
 */
package antlr.preprocessor;

import antlr.Tool;
import antlr.collections.impl.IndexedVector;
import antlr.preprocessor.GrammarFile;
import antlr.preprocessor.Hierarchy;
import antlr.preprocessor.Option;
import antlr.preprocessor.Rule;
import java.io.IOException;
import java.util.Enumeration;

class Grammar {
    protected String name;
    protected String fileName;
    protected String superGrammar;
    protected String type;
    protected IndexedVector rules;
    protected IndexedVector options;
    protected String preambleAction;
    protected String memberAction;
    protected Hierarchy hier;
    protected boolean predefined = false;
    protected boolean alreadyExpanded = false;
    protected boolean specifiedVocabulary = false;

    public Grammar(String string, String string2, IndexedVector indexedVector) {
        this.name = string;
        this.superGrammar = string2;
        this.rules = indexedVector;
    }

    public void addOption(Option option) {
        if (this.options == null) {
            this.options = new IndexedVector();
        }
        this.options.appendElement(option.getName(), option);
    }

    public void addRule(Rule rule) {
        this.rules.appendElement(rule.getName(), rule);
    }

    public void expandInPlace() {
        Object object;
        if (this.alreadyExpanded) {
            return;
        }
        Grammar grammar = this.getSuperGrammar();
        if (grammar == null) {
            return;
        }
        if (grammar.isPredefined()) {
            return;
        }
        grammar.expandInPlace();
        this.alreadyExpanded = true;
        GrammarFile grammarFile = this.hier.getFile(this.getFileName());
        grammarFile.setExpanded(true);
        IndexedVector indexedVector = grammar.getRules();
        Enumeration enumeration = indexedVector.elements();
        while (enumeration.hasMoreElements()) {
            object = (Rule)enumeration.nextElement();
            this.inherit((Rule)object, grammar);
        }
        object = grammar.getOptions();
        if (object == null) {
            return;
        }
        Enumeration enumeration2 = ((IndexedVector)object).elements();
        while (enumeration2.hasMoreElements()) {
            Option option = (Option)enumeration2.nextElement();
            this.inherit(option, grammar);
        }
        this.inherit(grammar.memberAction, grammar);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.name;
    }

    public IndexedVector getOptions() {
        return this.options;
    }

    public IndexedVector getRules() {
        return this.rules;
    }

    public Grammar getSuperGrammar() {
        if (this.superGrammar == null) {
            return null;
        }
        Grammar grammar = this.hier.getGrammar(this.superGrammar);
        return grammar;
    }

    public String getSuperGrammarName() {
        return this.superGrammar;
    }

    public String getType() {
        return this.type;
    }

    public void inherit(Option option, Grammar grammar) {
        Option option2 = null;
        if (this.options != null) {
            option2 = (Option)this.options.getElement(option.getName());
        }
        if (option2 == null) {
            if (option.getName().equals("tokdef")) {
                String string = Tool.stripFrontBack(option.getRHS(), "\"", "\"");
                String string2 = option.getEnclosingGrammar().getFileName();
                String string3 = Tool.pathToFile(string2);
                String string4 = String.valueOf(string3) + string;
                String string5 = Tool.fileMinusPath(string);
                try {
                    Tool.copyFile(string4, string5);
                }
                catch (IOException iOException) {
                    Tool.toolError("cannot find tokdef file " + string4);
                    return;
                }
                option.setRHS("\"" + string5 + "\";");
            }
            this.addOption(option);
        }
    }

    public void inherit(Rule rule, Grammar grammar) {
        Rule rule2 = (Rule)this.rules.getElement(rule.getName());
        if (rule2 != null) {
            if (!rule2.sameSignature(rule)) {
                Tool.warning("rule " + this.getName() + "." + rule2.getName() + " has different signature than " + grammar.getName() + "." + rule2.getName());
                return;
            }
        } else {
            this.addRule(rule);
        }
    }

    public void inherit(String string, Grammar grammar) {
        if (this.memberAction != null) {
            return;
        }
        if (string != null) {
            this.memberAction = string;
        }
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setHierarchy(Hierarchy hierarchy) {
        this.hier = hierarchy;
    }

    public void setMemberAction(String string) {
        this.memberAction = string;
    }

    public void setOptions(IndexedVector indexedVector) {
        this.options = indexedVector;
    }

    public void setPreambleAction(String string) {
        this.preambleAction = string;
    }

    public void setPredefined(boolean bl) {
        this.predefined = bl;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String toString() {
        String string = "";
        if (this.preambleAction != null) {
            string = String.valueOf(string) + this.preambleAction;
        }
        if (this.superGrammar == null) {
            return "class " + this.name + ";";
        }
        String string2 = "";
        string = String.valueOf(string) + "class " + this.name + " extends " + this.type + string2 + ";" + System.getProperty("line.separator") + System.getProperty("line.separator");
        if (this.options != null) {
            string = String.valueOf(string) + Hierarchy.optionsToString(this.options);
        }
        if (this.memberAction != null) {
            string = String.valueOf(string) + this.memberAction + System.getProperty("line.separator");
        }
        int n = 0;
        while (n < this.rules.size()) {
            Rule rule = (Rule)this.rules.elementAt(n);
            if (!this.getName().equals(rule.enclosingGrammar.getName())) {
                string = String.valueOf(string) + "// inherited from grammar " + rule.enclosingGrammar.getName() + System.getProperty("line.separator");
            }
            string = String.valueOf(string) + rule + System.getProperty("line.separator") + System.getProperty("line.separator");
            ++n;
        }
        return string;
    }
}

