/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ActionElement;
import antlr.ActionTransInfo;
import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.AlternativeElement;
import antlr.BlockEndElement;
import antlr.CharLiteralElement;
import antlr.CharRangeElement;
import antlr.CodeGenerator;
import antlr.CppBlockFinishingInfo;
import antlr.CppCharFormatter;
import antlr.ExceptionHandler;
import antlr.ExceptionSpec;
import antlr.Grammar;
import antlr.GrammarAtom;
import antlr.GrammarSymbol;
import antlr.LexerGrammar;
import antlr.Lookahead;
import antlr.MakeGrammar;
import antlr.OneOrMoreBlock;
import antlr.ParserGrammar;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.RuleSymbol;
import antlr.StringLiteralElement;
import antlr.StringLiteralSymbol;
import antlr.SynPredBlock;
import antlr.Token;
import antlr.TokenManager;
import antlr.TokenRangeElement;
import antlr.TokenRefElement;
import antlr.TokenSymbol;
import antlr.Tool;
import antlr.TreeElement;
import antlr.TreeWalkerGrammar;
import antlr.WildcardElement;
import antlr.ZeroOrMoreBlock;
import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class CppCodeGenerator
extends CodeGenerator {
    protected int syntacticPredLevel;
    protected boolean genAST = false;
    protected boolean saveText = false;
    String labeledElementType;
    String labeledElementASTType;
    String labeledElementInit;
    String commonExtraArgs;
    String commonExtraParams;
    String commonLocalVars;
    String lt1Value;
    String exceptionThrown;
    String throwNoViable;
    RuleBlock currentRule;
    String currentASTResult;
    Hashtable treeVariableMap = new Hashtable();
    int astVarNumber = 1;
    protected static final String NONUNIQUE = new String();

    public CppCodeGenerator() {
        this.charFormatter = new CppCharFormatter();
    }

    public void exitIfError() {
        if (this.tool.hasError) {
            System.out.println("Exiting due to errors.");
            System.exit(1);
        }
    }

    public void gen() {
        try {
            Object object;
            Enumeration enumeration = this.behavior.grammars.elements();
            while (enumeration.hasMoreElements()) {
                object = (Grammar)enumeration.nextElement();
                ((Grammar)object).setGrammarAnalyzer(this.analyzer);
                ((Grammar)object).setCodeGenerator(this);
                this.analyzer.setGrammar((Grammar)object);
                this.setupGrammarParameters((Grammar)object);
                ((Grammar)object).generate();
                this.exitIfError();
            }
            object = this.behavior.tokenManagers.elements();
            while (object.hasMoreElements()) {
                TokenManager tokenManager = (TokenManager)object.nextElement();
                if (!tokenManager.isReadOnly()) {
                    this.genTokenTypes(tokenManager);
                    this.genTokenInterchange(tokenManager);
                }
                this.exitIfError();
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return;
        }
    }

    public void gen(ActionElement actionElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genAction(" + actionElement + ")");
        }
        if (actionElement.isSemPred) {
            this.genSemPred(actionElement.actionText);
            return;
        }
        if (this.grammar.hasSyntacticPredicate) {
            this.println("if ( guessing==0 ) {");
            ++this.tabs;
        }
        ActionTransInfo actionTransInfo = new ActionTransInfo();
        String string = this.processActionForTreeSpecifiers(actionElement.actionText, actionElement.getLine(), this.currentRule, actionTransInfo);
        if (actionTransInfo.refRuleRoot != null) {
            this.println(String.valueOf(actionTransInfo.refRuleRoot) + " = currentAST.root;");
        }
        this.printAction(string);
        if (actionTransInfo.assignToRoot) {
            this.println("currentAST.root = " + actionTransInfo.refRuleRoot + ";");
            this.println("currentAST.child = " + actionTransInfo.refRuleRoot + "!=nullAST &&" + actionTransInfo.refRuleRoot + "->getFirstChild()!=0 ?");
            ++this.tabs;
            this.println(String.valueOf(actionTransInfo.refRuleRoot) + "->getFirstChild() : " + actionTransInfo.refRuleRoot + ";");
            --this.tabs;
            this.println("currentAST.advanceChildToEnd();");
        }
        if (this.grammar.hasSyntacticPredicate) {
            --this.tabs;
            this.println("}");
        }
    }

    public void gen(AlternativeBlock alternativeBlock) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen(" + alternativeBlock + ")");
        }
        this.println("{");
        this.genBlockPreamble(alternativeBlock);
        String string = this.currentASTResult;
        if (alternativeBlock.getLabel() != null) {
            this.currentASTResult = alternativeBlock.getLabel();
        }
        this.grammar.theLLkAnalyzer.deterministic(alternativeBlock);
        CppBlockFinishingInfo cppBlockFinishingInfo = this.genCommonBlock(alternativeBlock, true);
        this.genBlockFinish(cppBlockFinishingInfo, this.throwNoViable);
        this.println("}");
        this.currentASTResult = string;
    }

    public void gen(BlockEndElement blockEndElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRuleEnd(" + blockEndElement + ")");
        }
    }

    public void gen(CharLiteralElement charLiteralElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genChar(" + charLiteralElement + ")");
        }
        if (charLiteralElement.getLabel() != null) {
            this.println(String.valueOf(charLiteralElement.getLabel()) + " = " + this.lt1Value + ";");
        }
        boolean bl = this.saveText;
        this.saveText = this.saveText && charLiteralElement.getAutoGenType() == 1;
        this.genMatch(charLiteralElement);
        this.saveText = bl;
    }

    public void gen(CharRangeElement charRangeElement) {
        if (charRangeElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(charRangeElement.getLabel()) + " = " + this.lt1Value + ";");
        }
        this.println("matchRange(" + charRangeElement.beginText + "," + charRangeElement.endText + ");");
    }

    public void gen(LexerGrammar lexerGrammar) throws IOException {
        this.setGrammar(lexerGrammar);
        if (!(this.grammar instanceof LexerGrammar)) {
            Tool.panic("Internal error generating lexer");
        }
        this.genBody(lexerGrammar);
        this.genInclude(lexerGrammar);
    }

    public void gen(OneOrMoreBlock oneOrMoreBlock) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen+(" + oneOrMoreBlock + ")");
        }
        this.println("{");
        this.genBlockPreamble(oneOrMoreBlock);
        String string = oneOrMoreBlock.getLabel() != null ? "_cnt_" + oneOrMoreBlock.getLabel() : "_cnt" + oneOrMoreBlock.ID;
        this.println("int " + string + "=0;");
        String string2 = oneOrMoreBlock.getLabel() != null ? oneOrMoreBlock.getLabel() : "_loop" + oneOrMoreBlock.ID;
        this.println("do {");
        ++this.tabs;
        String string3 = this.currentASTResult;
        if (oneOrMoreBlock.getLabel() != null) {
            this.currentASTResult = oneOrMoreBlock.getLabel();
        }
        this.grammar.theLLkAnalyzer.deterministic(oneOrMoreBlock);
        CppBlockFinishingInfo cppBlockFinishingInfo = this.genCommonBlock(oneOrMoreBlock, false);
        this.genBlockFinish(cppBlockFinishingInfo, "if ( " + string + ">=1 ) { goto " + string2 + "; } else {" + this.throwNoViable + "}");
        this.println(String.valueOf(string) + "++;");
        --this.tabs;
        this.println("} while (true);");
        this.println(String.valueOf(string2) + ":;");
        this.println("}");
        this.currentASTResult = string3;
    }

    public void gen(ParserGrammar parserGrammar) throws IOException {
        this.setGrammar(parserGrammar);
        if (!(this.grammar instanceof ParserGrammar)) {
            Tool.panic("Internal error generating parser");
        }
        this.genBody(parserGrammar);
        this.genInclude(parserGrammar);
    }

    public void gen(RuleRefElement ruleRefElement) {
        RuleSymbol ruleSymbol;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRR(" + ruleRefElement + ")");
        }
        if ((ruleSymbol = (RuleSymbol)this.grammar.getSymbol(ruleRefElement.targetRule)) == null || !ruleSymbol.isDefined()) {
            this.tool.error("Rule '" + ruleRefElement.targetRule + "' is not defined", ruleRefElement.getLine());
            return;
        }
        if (!(ruleSymbol instanceof RuleSymbol)) {
            this.tool.error("'" + ruleRefElement.targetRule + "' does not name a grammar rule", ruleRefElement.getLine());
            return;
        }
        this.genErrorTryForElement(ruleRefElement);
        if (this.grammar instanceof TreeWalkerGrammar && ruleRefElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(ruleRefElement.getLabel()) + " = _t==ASTNULL ? nullAST : " + this.lt1Value + ";");
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || ruleRefElement.getAutoGenType() == 3)) {
            this.println("_saveIndex=text.length();");
        }
        this.printTabs();
        if (ruleRefElement.idAssign != null) {
            if (ruleSymbol.block.returnAction == null) {
                Tool.warning("Rule '" + ruleRefElement.targetRule + "' has no return type", ruleRefElement.getLine());
            }
            this._print(String.valueOf(ruleRefElement.idAssign) + "=");
        } else if (!(this.grammar instanceof LexerGrammar) && this.syntacticPredLevel == 0 && ruleSymbol.block.returnAction != null) {
            Tool.warning("Rule '" + ruleRefElement.targetRule + "' returns a value", ruleRefElement.getLine());
        }
        this.GenRuleInvocation(ruleRefElement);
        if (this.grammar instanceof LexerGrammar && (!this.saveText || ruleRefElement.getAutoGenType() == 3)) {
            this.println("text.erase(_saveIndex);");
        }
        if (this.syntacticPredLevel == 0) {
            boolean bl;
            boolean bl2 = bl = this.grammar.hasSyntacticPredicate && (this.grammar.buildAST && ruleRefElement.getLabel() != null || this.genAST && ruleRefElement.getAutoGenType() == 1);
            if (bl) {
                this.println("if (guessing==0) {");
                ++this.tabs;
            }
            if (this.grammar.buildAST && ruleRefElement.getLabel() != null) {
                this.println(String.valueOf(ruleRefElement.getLabel()) + "_AST = returnAST;");
            }
            if (this.genAST) {
                switch (ruleRefElement.getAutoGenType()) {
                    case 1: {
                        this.println("astFactory.addASTChild(currentAST, returnAST);");
                        break;
                    }
                    case 2: {
                        this.tool.error("Internal: encountered ^ after rule reference");
                        break;
                    }
                }
            }
            if (this.grammar instanceof LexerGrammar && ruleRefElement.getLabel() != null) {
                this.println(String.valueOf(ruleRefElement.getLabel()) + "=_returnToken;");
            }
            if (bl) {
                --this.tabs;
                this.println("}");
            }
        }
        this.genErrorCatchForElement(ruleRefElement);
    }

    public void gen(StringLiteralElement stringLiteralElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genString(" + stringLiteralElement + ")");
        }
        if (stringLiteralElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(stringLiteralElement.getLabel()) + " = " + this.lt1Value + ";");
        }
        this.genElementAST(stringLiteralElement);
        boolean bl = this.saveText;
        this.saveText = this.saveText && stringLiteralElement.getAutoGenType() == 1;
        this.genMatch(stringLiteralElement);
        this.saveText = bl;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t->getNextSibling();");
        }
    }

    public void gen(TokenRangeElement tokenRangeElement) {
        this.genErrorTryForElement(tokenRangeElement);
        if (tokenRangeElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(tokenRangeElement.getLabel()) + " = " + this.lt1Value + ";");
        }
        this.genElementAST(tokenRangeElement);
        this.println("matchRange(" + tokenRangeElement.beginText + "," + tokenRangeElement.endText + ");");
        this.genErrorCatchForElement(tokenRangeElement);
    }

    public void gen(TokenRefElement tokenRefElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genTokenRef(" + tokenRefElement + ")");
        }
        if (this.grammar instanceof LexerGrammar) {
            Tool.panic("Token reference found in lexer");
        }
        this.genErrorTryForElement(tokenRefElement);
        if (tokenRefElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(tokenRefElement.getLabel()) + " = " + this.lt1Value + ";");
        }
        this.genElementAST(tokenRefElement);
        this.genMatch(tokenRefElement);
        this.genErrorCatchForElement(tokenRefElement);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t->getNextSibling();");
        }
    }

    public void gen(TreeElement treeElement) {
        this.println("RefAST __t" + treeElement.ID + " = _t;");
        if (treeElement.root.getLabel() != null) {
            this.println(String.valueOf(treeElement.root.getLabel()) + " = _t==ASTNULL ? nullAST :_t;");
        }
        this.genElementAST(treeElement.root);
        if (this.grammar.buildAST) {
            this.println("ASTPair __currentAST" + treeElement.ID + " = currentAST;");
            this.println("currentAST.root = currentAST.child;");
            this.println("currentAST.child = nullAST;");
        }
        this.genMatch(treeElement.root);
        this.println("_t = _t->getFirstChild();");
        int n = 0;
        while (n < treeElement.getAlternatives().size()) {
            Alternative alternative = treeElement.getAlternativeAt(n);
            AlternativeElement alternativeElement = alternative.head;
            while (alternativeElement != null) {
                alternativeElement.generate();
                alternativeElement = alternativeElement.next;
            }
            ++n;
        }
        if (this.grammar.buildAST) {
            this.println("currentAST = __currentAST" + treeElement.ID + ";");
        }
        this.println("_t = __t" + treeElement.ID + ";");
        this.println("_t = _t->getNextSibling();");
    }

    public void gen(TreeWalkerGrammar treeWalkerGrammar) throws IOException {
        this.setGrammar(treeWalkerGrammar);
        if (!(this.grammar instanceof TreeWalkerGrammar)) {
            Tool.panic("Internal error generating tree-walker");
        }
        this.genBody(treeWalkerGrammar);
        this.genInclude(treeWalkerGrammar);
    }

    public void gen(WildcardElement wildcardElement) {
        if (wildcardElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(wildcardElement.getLabel()) + " = " + this.lt1Value + ";");
        }
        this.genElementAST(wildcardElement);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("if ( _t==nullAST ) throw MismatchedTokenException();");
        } else if (this.grammar instanceof LexerGrammar) {
            this.println("matchNot(EOF_CHAR);");
        } else {
            this.println("matchNot(" + this.getValueString(1) + ");");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t->getNextSibling();");
        }
    }

    public void gen(ZeroOrMoreBlock zeroOrMoreBlock) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen*(" + zeroOrMoreBlock + ")");
        }
        this.println("{");
        this.genBlockPreamble(zeroOrMoreBlock);
        String string = zeroOrMoreBlock.getLabel() != null ? zeroOrMoreBlock.getLabel() : "_loop" + zeroOrMoreBlock.ID;
        this.println("do {");
        ++this.tabs;
        String string2 = this.currentASTResult;
        if (zeroOrMoreBlock.getLabel() != null) {
            this.currentASTResult = zeroOrMoreBlock.getLabel();
        }
        this.grammar.theLLkAnalyzer.deterministic(zeroOrMoreBlock);
        CppBlockFinishingInfo cppBlockFinishingInfo = this.genCommonBlock(zeroOrMoreBlock, false);
        this.genBlockFinish(cppBlockFinishingInfo, "goto " + string + ";");
        --this.tabs;
        this.println("} while (true);");
        this.println(String.valueOf(string) + ":;");
        this.println("}");
        this.currentASTResult = string2;
    }

    protected void genAlt(Alternative alternative, AlternativeBlock alternativeBlock) {
        boolean bl = this.genAST;
        this.genAST = this.genAST && alternative.getAutoGen();
        boolean bl2 = this.saveText;
        this.saveText = this.saveText && alternative.getAutoGen();
        Hashtable hashtable = this.treeVariableMap;
        this.treeVariableMap = new Hashtable();
        if (alternative.exceptionSpec != null) {
            this.println("try {      // for error handling");
            ++this.tabs;
        }
        AlternativeElement alternativeElement = alternative.head;
        while (!(alternativeElement instanceof BlockEndElement)) {
            alternativeElement.generate();
            alternativeElement = alternativeElement.next;
        }
        if (this.genAST) {
            if (alternativeBlock instanceof RuleBlock) {
                RuleBlock ruleBlock = (RuleBlock)alternativeBlock;
                this.println(String.valueOf(ruleBlock.getRuleName()) + "_AST = currentAST.root;");
            } else {
                alternativeBlock.getLabel();
            }
        }
        if (alternative.exceptionSpec != null) {
            --this.tabs;
            this.println("}");
            this.genErrorHandler(alternative.exceptionSpec);
        }
        this.genAST = bl;
        this.saveText = bl2;
        this.treeVariableMap = hashtable;
    }

    protected void genBitsets(Vector vector, int n, String string) {
        this.println("");
        int n2 = 0;
        while (n2 < vector.size()) {
            BitSet bitSet = (BitSet)vector.elementAt(n2);
            bitSet.growToInclude(n);
            this.println("const u_int32_t " + string + this.getBitsetName(n2) + "_data_" + "[] = { " + bitSet.toStringOfHalfWords() + " };");
            this.println("const BitSet " + string + this.getBitsetName(n2) + "(" + this.getBitsetName(n2) + "_data_," + bitSet.size() / 32 + ");");
            ++n2;
        }
    }

    protected void genBitsetsHeader(Vector vector, int n) {
        this.println("");
        int n2 = 0;
        while (n2 < vector.size()) {
            BitSet bitSet = (BitSet)vector.elementAt(n2);
            bitSet.growToInclude(n);
            this.println("static const u_int32_t " + this.getBitsetName(n2) + "_data_" + "[];");
            this.println("static const BitSet " + this.getBitsetName(n2) + ";");
            ++n2;
        }
    }

    private void genBlockFinish(CppBlockFinishingInfo cppBlockFinishingInfo, String string) {
        if (cppBlockFinishingInfo.needAnErrorClause && (cppBlockFinishingInfo.generatedAnIf || cppBlockFinishingInfo.generatedSwitch)) {
            if (cppBlockFinishingInfo.generatedAnIf) {
                this.println("else {");
            } else {
                this.println("{");
            }
            ++this.tabs;
            this.println(string);
            --this.tabs;
            this.println("}");
        }
        if (cppBlockFinishingInfo.postscript != null) {
            this.println(cppBlockFinishingInfo.postscript);
        }
    }

    protected void genBlockPreamble(AlternativeBlock alternativeBlock) {
        if (alternativeBlock instanceof RuleBlock) {
            RuleBlock ruleBlock = (RuleBlock)alternativeBlock;
            if (ruleBlock.labeledElements != null) {
                int n = 0;
                while (n < ruleBlock.labeledElements.size()) {
                    AlternativeElement alternativeElement = (AlternativeElement)ruleBlock.labeledElements.elementAt(n);
                    if (alternativeElement instanceof RuleRefElement || alternativeElement instanceof AlternativeBlock && !(alternativeElement instanceof RuleBlock) && !(alternativeElement instanceof SynPredBlock)) {
                        if (!(alternativeElement instanceof RuleRefElement) && ((AlternativeBlock)alternativeElement).not && this.analyzer.subruleCanBeInverted((AlternativeBlock)alternativeElement, this.grammar instanceof LexerGrammar)) {
                            this.println(String.valueOf(this.labeledElementType) + " " + alternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
                            if (this.grammar.buildAST) {
                                this.println(String.valueOf(this.labeledElementASTType) + " " + alternativeElement.getLabel() + "_AST = nullAST;");
                            }
                        } else {
                            if (this.grammar.buildAST) {
                                this.println(String.valueOf(this.labeledElementASTType) + " " + alternativeElement.getLabel() + "_AST = nullAST;");
                            }
                            if (this.grammar instanceof LexerGrammar) {
                                this.println("RefToken " + alternativeElement.getLabel() + "(0);");
                            }
                            if (this.grammar instanceof TreeWalkerGrammar) {
                                this.println(String.valueOf(this.labeledElementType) + " " + alternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
                            }
                        }
                    } else {
                        this.println(String.valueOf(this.labeledElementType) + " " + alternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
                        if (this.grammar.buildAST) {
                            this.println(String.valueOf(this.labeledElementASTType) + " " + alternativeElement.getLabel() + "_AST = nullAST;");
                        }
                    }
                    ++n;
                }
            }
        }
        if (alternativeBlock.initAction != null) {
            this.printAction(this.processActionForTreeSpecifiers(alternativeBlock.initAction, 0, this.currentRule, null));
        }
    }

    public void genBody(LexerGrammar lexerGrammar) throws IOException {
        Object object;
        this.currentOutput = Tool.openOutputFile(String.valueOf(this.grammar.getClassName()) + ".cpp");
        this.genAST = false;
        this.saveText = true;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.headerAction);
        String string = "CharBuffer";
        this.println(this.grammar.preambleAction);
        this.println("#include \"" + this.grammar.getClassName() + ".hpp\"");
        this.println("#include \"" + this.grammar.tokenManager.getName() + "TokenTypes.hpp\"");
        this.println("#include <antlr/ScannerException.hpp>" + System.getProperty("line.separator"));
        String string2 = null;
        string2 = this.grammar.superClass != null ? this.grammar.superClass : this.grammar.getSuperClass();
        this.println(String.valueOf(this.grammar.getClassName()) + "::" + this.grammar.getClassName() + "(istream& in)");
        ++this.tabs;
        this.println(": " + string2 + "(new " + string + "(in))");
        --this.tabs;
        this.println("{");
        ++this.tabs;
        this.println("setCaseSensitive(" + lexerGrammar.caseSensitive + ");");
        this.println("initLiterals();");
        --this.tabs;
        this.println("}" + System.getProperty("line.separator"));
        this.println(String.valueOf(this.grammar.getClassName()) + "::" + this.grammar.getClassName() + "(" + string + "& cb)");
        ++this.tabs;
        this.println(": " + string2 + "(cb)");
        --this.tabs;
        this.println("{");
        ++this.tabs;
        this.println("setCaseSensitive(" + lexerGrammar.caseSensitive + ");");
        this.println("initLiterals();");
        --this.tabs;
        this.println("}\n");
        this.println("void " + this.grammar.getClassName() + "::initLiterals()");
        this.println("{");
        ++this.tabs;
        Enumeration enumeration = this.grammar.tokenManager.getTokenSymbolElements();
        while (enumeration.hasMoreElements()) {
            TokenSymbol tokenSymbol = (TokenSymbol)enumeration.nextElement();
            if (!(tokenSymbol instanceof StringLiteralSymbol)) continue;
            object = (StringLiteralSymbol)tokenSymbol;
            this.println("literals[" + ((GrammarSymbol)object).getId() + "] = " + ((TokenSymbol)object).getTokenType() + ";");
        }
        --this.tabs;
        this.println("}");
        this.println("bool " + this.grammar.getClassName() + "::getCaseSensitiveLiterals() const");
        this.println("{");
        ++this.tabs;
        this.println("return " + lexerGrammar.caseSensitiveLiterals + ";");
        --this.tabs;
        this.println("}");
        this.genNextToken();
        enumeration = this.grammar.rules.elements();
        int n = 0;
        object = "const char* " + this.grammar.getClassName() + "::_ruleNames[] = {" + System.getProperty("line.separator");
        while (enumeration.hasMoreElements()) {
            RuleSymbol ruleSymbol = (RuleSymbol)enumeration.nextElement();
            if (!ruleSymbol.getId().equals("mnextToken")) {
                if (this.grammar.debuggingOutput) {
                    object = String.valueOf(object) + "\t\t\"" + ruleSymbol.getId().substring(1) + "\"," + System.getProperty("line.separator");
                }
                this.genRule(ruleSymbol, false, n++, String.valueOf(this.grammar.getClassName()) + "::");
            }
            this.exitIfError();
        }
        if (this.grammar.debuggingOutput) {
            this.println(String.valueOf(object) + "\t0};");
        }
        this.genBitsets(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size(), String.valueOf(this.grammar.getClassName()) + "::");
        this.println("");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void genBody(ParserGrammar parserGrammar) throws IOException {
        this.currentOutput = Tool.openOutputFile(String.valueOf(this.grammar.getClassName()) + ".cpp");
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.headerAction);
        this.println(this.grammar.preambleAction);
        this.println("#include \"" + this.grammar.getClassName() + ".hpp\"");
        this.println("#include <antlr/NoViableAltException.hpp>");
        this.println("#include <antlr/SemanticException.hpp>");
        String string = null;
        string = this.grammar.superClass != null ? this.grammar.superClass : this.grammar.getSuperClass();
        this.print(String.valueOf(this.grammar.getClassName()) + "::" + this.grammar.getClassName());
        this.println("(TokenBuffer& tokenBuf, int k)");
        this.println(": " + string + "(tokenBuf,k)");
        this.println("{");
        ++this.tabs;
        this.println("setTokenNames(_tokenNames);");
        --this.tabs;
        this.println("}" + System.getProperty("line.separator"));
        this.print(String.valueOf(this.grammar.getClassName()) + "::" + this.grammar.getClassName());
        this.println("(TokenBuffer& tokenBuf)");
        this.println(": " + string + "(tokenBuf," + this.grammar.maxk + ")");
        this.println("{");
        ++this.tabs;
        this.println("setTokenNames(_tokenNames);");
        --this.tabs;
        this.println("}" + System.getProperty("line.separator"));
        this.print(String.valueOf(this.grammar.getClassName()) + "::" + this.grammar.getClassName());
        this.println("(Tokenizer& lexer, int k)");
        this.println(": " + string + "(lexer,k)");
        this.println("{");
        ++this.tabs;
        this.println("setTokenNames(_tokenNames);");
        --this.tabs;
        this.println("}" + System.getProperty("line.separator"));
        this.print(String.valueOf(this.grammar.getClassName()) + "::" + this.grammar.getClassName());
        this.println("(Tokenizer& lexer)");
        this.println(": " + string + "(lexer," + this.grammar.maxk + ")");
        this.println("{");
        ++this.tabs;
        this.println("setTokenNames(_tokenNames);");
        --this.tabs;
        this.println("}" + System.getProperty("line.separator"));
        Enumeration enumeration = this.grammar.rules.elements();
        int n = 0;
        String string2 = "const char* " + this.grammar.getClassName() + "::_ruleNames[] = {" + System.getProperty("line.separator");
        while (enumeration.hasMoreElements()) {
            GrammarSymbol grammarSymbol = (GrammarSymbol)enumeration.nextElement();
            if (grammarSymbol instanceof RuleSymbol) {
                RuleSymbol ruleSymbol = (RuleSymbol)grammarSymbol;
                if (this.grammar.debuggingOutput) {
                    string2 = String.valueOf(string2) + "\t\t\"" + ruleSymbol.getId() + "\"," + System.getProperty("line.separator");
                }
                this.genRule(ruleSymbol, ruleSymbol.references.size() == 0, n++, String.valueOf(this.grammar.getClassName()) + "::");
            }
            this.exitIfError();
        }
        if (this.grammar.debuggingOutput) {
            this.println(String.valueOf(string2) + "\t0};");
        }
        this.genTokenStrings(String.valueOf(this.grammar.getClassName()) + "::");
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType(), String.valueOf(this.grammar.getClassName()) + "::");
        this.println("");
        this.println("");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void genBody(TreeWalkerGrammar treeWalkerGrammar) throws IOException {
        this.currentOutput = Tool.openOutputFile(String.valueOf(this.grammar.getClassName()) + ".cpp");
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.headerAction);
        this.println(this.grammar.preambleAction);
        this.println("#include \"" + this.grammar.getClassName() + ".hpp\"");
        this.println("#include <antlr/Token.hpp>");
        this.println("#include <antlr/AST.hpp>");
        this.println("#include <antlr/ParserException.hpp>");
        this.println("#include <antlr/NoViableAltException.hpp>");
        this.println("#include <antlr/MismatchedTokenException.hpp>");
        this.println("#include <antlr/SemanticException.hpp>");
        this.println("#include <antlr/BitSet.hpp>");
        String string = null;
        string = this.grammar.superClass != null ? this.grammar.superClass : this.grammar.getSuperClass();
        this.println(String.valueOf(this.grammar.getClassName()) + "::" + this.grammar.getClassName() + "() {");
        ++this.tabs;
        this.println("setTokenNames(_tokenNames);");
        if (this.grammar.debuggingOutput) {
            this.println("ruleNames  = _ruleNames;");
        }
        --this.tabs;
        this.println("}" + System.getProperty("line.separator"));
        Enumeration enumeration = this.grammar.rules.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            GrammarSymbol grammarSymbol = (GrammarSymbol)enumeration.nextElement();
            if (grammarSymbol instanceof RuleSymbol) {
                RuleSymbol ruleSymbol = (RuleSymbol)grammarSymbol;
                this.genRule(ruleSymbol, ruleSymbol.references.size() == 0, n++, String.valueOf(this.grammar.getClassName()) + "::");
            }
            this.exitIfError();
        }
        this.genTokenStrings(String.valueOf(this.grammar.getClassName()) + "::");
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType(), String.valueOf(this.grammar.getClassName()) + "::");
        this.println("");
        this.println("");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    protected void genCases(BitSet bitSet) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genCases(" + bitSet + ")");
        }
        int[] nArray = bitSet.toArray();
        int n = this.grammar instanceof LexerGrammar ? 4 : 1;
        int n2 = 1;
        boolean bl = true;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n2 == 1) {
                this.print("");
            } else {
                this._print("  ");
            }
            this._print("case " + this.getValueString(nArray[n3]) + ":");
            if (n2 == n) {
                this._println("");
                bl = true;
                n2 = 1;
            } else {
                ++n2;
                bl = false;
            }
            ++n3;
        }
        if (!bl) {
            this._println("");
        }
    }

    public CppBlockFinishingInfo genCommonBlock(AlternativeBlock alternativeBlock, boolean bl) {
        int n;
        Object object;
        Object object2;
        int n2;
        Object object3;
        int n3 = 0;
        boolean bl2 = false;
        int n4 = 0;
        CppBlockFinishingInfo cppBlockFinishingInfo = new CppBlockFinishingInfo();
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genAltBlk(" + alternativeBlock + ")");
        }
        boolean bl3 = this.genAST;
        this.genAST = this.genAST && alternativeBlock.getAutoGen();
        boolean bl4 = this.saveText;
        boolean bl5 = this.saveText = this.saveText && alternativeBlock.getAutoGen();
        if (alternativeBlock.not && this.analyzer.subruleCanBeInverted(alternativeBlock, this.grammar instanceof LexerGrammar)) {
            Lookahead lookahead = this.analyzer.look(1, alternativeBlock);
            if (alternativeBlock.getLabel() != null && this.syntacticPredLevel == 0) {
                this.println(String.valueOf(alternativeBlock.getLabel()) + " = " + this.lt1Value + ";");
            }
            this.genElementAST(alternativeBlock);
            String string = "";
            if (this.grammar instanceof TreeWalkerGrammar) {
                string = "_t,";
            }
            this.println("match(" + string + this.getBitsetName(this.markBitsetForGen(lookahead.fset)) + ");");
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("_t = _t->getNextSibling();");
            }
            return cppBlockFinishingInfo;
        }
        if (alternativeBlock.getAlternatives().size() == 1) {
            Alternative alternative = alternativeBlock.getAlternativeAt(0);
            if (alternative.synPred != null) {
                Tool.warning("Syntactic predicate superfluous for single alternative", alternativeBlock.getAlternativeAt((int)0).synPred.getLine());
            }
            if (bl) {
                if (alternative.semPred != null) {
                    this.genSemPred(alternative.semPred);
                }
                this.genAlt(alternative, alternativeBlock);
                return cppBlockFinishingInfo;
            }
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < alternativeBlock.getAlternatives().size()) {
            object3 = alternativeBlock.getAlternativeAt(n6);
            if (((Alternative)object3).lookaheadDepth == 1 && ((Alternative)object3).semPred == null && !((Alternative)object3).cache[1].containsEpsilon()) {
                ++n5;
            }
            ++n6;
        }
        if (n5 >= this.makeSwitchThreshold) {
            object3 = this.lookaheadString(1);
            bl2 = true;
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("if (_t==nullAST) _t=ASTNULL;");
            }
            this.println("switch ( " + (String)object3 + ") {");
            n2 = 0;
            while (n2 < alternativeBlock.alternatives.size()) {
                object2 = alternativeBlock.getAlternativeAt(n2);
                if (((Alternative)object2).lookaheadDepth == 1 && ((Alternative)object2).semPred == null && !((Alternative)object2).cache[1].containsEpsilon()) {
                    object = ((Alternative)object2).cache[1];
                    if (((Lookahead)object).fset.degree() == 0 && !((Lookahead)object).containsEpsilon()) {
                        Tool.warning("Alternate omitted due to empty prediction set", ((Alternative)object2).head.getLine());
                    } else {
                        this.genCases(((Lookahead)object).fset);
                        this.println("{");
                        ++this.tabs;
                        this.genAlt((Alternative)object2, alternativeBlock);
                        this.println("break;");
                        --this.tabs;
                        this.println("}");
                    }
                }
                ++n2;
            }
            this.println("default:");
            ++this.tabs;
        }
        n2 = n = this.grammar instanceof LexerGrammar ? this.grammar.maxk : 0;
        while (n2 >= 0) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("checking depth " + n2);
            }
            int n7 = 0;
            while (n7 < alternativeBlock.alternatives.size()) {
                block41: {
                    String string;
                    boolean bl6;
                    block44: {
                        block42: {
                            int n8;
                            block43: {
                                block40: {
                                    object = alternativeBlock.getAlternativeAt(n7);
                                    if (this.DEBUG_CODE_GENERATOR) {
                                        System.out.println("genAlt: " + n7);
                                    }
                                    if (!bl2 || ((Alternative)object).lookaheadDepth != 1 || ((Alternative)object).semPred != null || ((Alternative)object).cache[1].containsEpsilon()) break block40;
                                    if (this.DEBUG_CODE_GENERATOR) {
                                        System.out.println("ignoring alt because it was in the switch");
                                    }
                                    break block41;
                                }
                                bl6 = false;
                                if (!(this.grammar instanceof LexerGrammar)) break block42;
                                n8 = ((Alternative)object).lookaheadDepth;
                                if (n8 == Integer.MAX_VALUE) {
                                    n8 = this.grammar.maxk;
                                }
                                while (n8 >= 1 && ((Alternative)object).cache[n8].containsEpsilon()) {
                                    --n8;
                                }
                                if (n8 == n2) break block43;
                                if (this.DEBUG_CODE_GENERATOR) {
                                    System.out.println("ignoring alt because effectiveDepth!=altDepth;" + n8 + "!=" + n2);
                                }
                                break block41;
                            }
                            bl6 = this.lookaheadIsEmpty((Alternative)object, n8);
                            string = this.getLookaheadTestExpression((Alternative)object, n8);
                            break block44;
                        }
                        bl6 = this.lookaheadIsEmpty((Alternative)object, this.grammar.maxk);
                        string = this.getLookaheadTestExpression((Alternative)object, this.grammar.maxk);
                    }
                    if (bl6 && ((Alternative)object).semPred == null && ((Alternative)object).synPred == null) {
                        if (n3 == 0) {
                            this.println("{");
                        } else {
                            this.println("else {");
                        }
                        cppBlockFinishingInfo.needAnErrorClause = false;
                    } else {
                        if (((Alternative)object).semPred != null) {
                            string = "(" + string + "&&(" + ((Alternative)object).semPred + "))";
                        }
                        if (n3 > 0) {
                            if (((Alternative)object).synPred != null) {
                                this.println("else {");
                                ++this.tabs;
                                this.genSynPred(((Alternative)object).synPred, string);
                                ++n4;
                            } else {
                                this.println("else if " + string + " {");
                            }
                        } else if (((Alternative)object).synPred != null) {
                            this.genSynPred(((Alternative)object).synPred, string);
                        } else {
                            if (this.grammar instanceof TreeWalkerGrammar) {
                                this.println("if (_t==nullAST) _t=ASTNULL;");
                            }
                            this.println("if " + string + " {");
                        }
                    }
                    ++n3;
                    ++this.tabs;
                    this.genAlt((Alternative)object, alternativeBlock);
                    --this.tabs;
                    this.println("}");
                }
                ++n7;
            }
            --n2;
        }
        object2 = "";
        int n9 = 1;
        while (n9 <= n4) {
            --this.tabs;
            object2 = String.valueOf(object2) + "}";
            ++n9;
        }
        this.genAST = bl3;
        this.saveText = bl4;
        if (bl2) {
            --this.tabs;
            cppBlockFinishingInfo.postscript = String.valueOf(object2) + "}";
            cppBlockFinishingInfo.generatedSwitch = true;
            cppBlockFinishingInfo.generatedAnIf = n3 > 0;
        } else {
            cppBlockFinishingInfo.postscript = object2;
            cppBlockFinishingInfo.generatedSwitch = false;
            cppBlockFinishingInfo.generatedAnIf = n3 > 0;
        }
        return cppBlockFinishingInfo;
    }

    private void genElementAST(AlternativeElement alternativeElement) {
        if (this.grammar.buildAST && this.syntacticPredLevel == 0) {
            String string;
            String string2;
            boolean bl;
            boolean bl2 = bl = this.grammar.hasSyntacticPredicate && (alternativeElement.getLabel() != null || alternativeElement.getAutoGenType() != 3);
            if (alternativeElement.getLabel() != null) {
                string2 = alternativeElement.getLabel();
                string = String.valueOf(alternativeElement.getLabel()) + "_AST";
            } else {
                string2 = this.lt1Value;
                string = "tmp" + this.astVarNumber + "_AST";
                ++this.astVarNumber;
                this.println(String.valueOf(this.labeledElementASTType) + " " + string + " = nullAST;");
                this.mapTreeVariable(alternativeElement, string);
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println(String.valueOf(this.labeledElementASTType) + " " + string + "_in = nullAST;");
                }
            }
            if (bl) {
                this.println("if (guessing==0) {");
                ++this.tabs;
            }
            if (alternativeElement.getLabel() != null) {
                this.println(String.valueOf(string) + " = " + this.getASTCreateString(string2) + ";");
            } else {
                string2 = this.lt1Value;
                this.println(String.valueOf(string) + " = " + this.getASTCreateString(string2) + ";");
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println(String.valueOf(string) + "_in = " + string2 + ";");
                }
            }
            if (this.genAST) {
                switch (alternativeElement.getAutoGenType()) {
                    case 1: {
                        this.println("astFactory.addASTChild(currentAST, " + string + ");");
                        break;
                    }
                    case 2: {
                        this.println("astFactory.makeASTRoot(currentAST, " + string + ");");
                        break;
                    }
                }
            }
            if (bl) {
                --this.tabs;
                this.println("}");
            }
        }
    }

    private void genErrorCatchForElement(AlternativeElement alternativeElement) {
        ExceptionSpec exceptionSpec;
        RuleSymbol ruleSymbol;
        if (alternativeElement.getLabel() == null) {
            return;
        }
        String string = alternativeElement.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            string = CodeGenerator.lexerRuleName(alternativeElement.enclosingRuleName);
        }
        if ((ruleSymbol = (RuleSymbol)this.grammar.getSymbol(string)) == null) {
            Tool.panic("Enclosing rule not found!");
        }
        if ((exceptionSpec = ruleSymbol.block.findExceptionSpec(alternativeElement.getLabel())) != null) {
            --this.tabs;
            this.println("}");
            this.genErrorHandler(exceptionSpec);
        }
    }

    private void genErrorHandler(ExceptionSpec exceptionSpec) {
        int n = 0;
        while (n < exceptionSpec.handlers.size()) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)exceptionSpec.handlers.elementAt(n);
            this.println("catch (" + exceptionHandler.exceptionTypeAndName.getText() + ") {");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if (guessing==0) {");
                ++this.tabs;
            }
            this.printAction(this.processActionForTreeSpecifiers(exceptionHandler.action, 0, this.currentRule, null));
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("} else {");
                ++this.tabs;
                this.println("throw " + this.extractIdOfAction(exceptionHandler.exceptionTypeAndName) + ";");
                --this.tabs;
                this.println("}");
            }
            --this.tabs;
            this.println("}");
            ++n;
        }
    }

    private void genErrorTryForElement(AlternativeElement alternativeElement) {
        ExceptionSpec exceptionSpec;
        RuleSymbol ruleSymbol;
        if (alternativeElement.getLabel() == null) {
            return;
        }
        String string = alternativeElement.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            string = CodeGenerator.lexerRuleName(alternativeElement.enclosingRuleName);
        }
        if ((ruleSymbol = (RuleSymbol)this.grammar.getSymbol(string)) == null) {
            Tool.panic("Enclosing rule not found!");
        }
        if ((exceptionSpec = ruleSymbol.block.findExceptionSpec(alternativeElement.getLabel())) != null) {
            this.println("try { // for error handling");
            ++this.tabs;
        }
    }

    protected void genHeader() {
        this.println("/*");
        this.println(" * ANTLR-generated file resulting from grammar " + this.tool.grammarFile);
        this.println(" * ");
        this.println(" * Terence Parr, MageLang Institute");
        this.println(" * with John Lilley, Empathy Software");
        this.println(" * ANTLR Version 2.4.0; 1996,1997,1998");
        this.println(" */");
        this.println("");
    }

    public void genInclude(LexerGrammar lexerGrammar) throws IOException {
        this.currentOutput = Tool.openOutputFile(String.valueOf(this.grammar.getClassName()) + ".hpp");
        this.genAST = false;
        this.saveText = true;
        this.tabs = 0;
        this.println("#ifndef INC_" + this.grammar.getClassName() + "_hpp_");
        this.println("#define INC_" + this.grammar.getClassName() + "_hpp_");
        this.println("");
        this.println("#include <antlr/config.hpp>");
        this.genHeader();
        this.println(this.behavior.headerAction);
        String string = "CharBuffer";
        this.println("#include <antlr/CommonToken.hpp>");
        this.println("#include <antlr/" + string + ".hpp>");
        this.println("#include <antlr/BitSet.hpp>");
        this.println("#include <sys/types.h>");
        String string2 = null;
        if (this.grammar.superClass != null) {
            string2 = this.grammar.superClass;
            this.println("#include \"" + string2 + ".hpp\"");
        } else {
            string2 = this.grammar.getSuperClass();
            this.println("#include <antlr/" + this.grammar.getSuperClass() + ".hpp>");
        }
        this.println(this.grammar.preambleAction);
        this.println("class " + this.grammar.getClassName() + " : public " + string2);
        this.println(" {");
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction, 0, this.currentRule, null));
        this.tabs = 0;
        this.println("private:");
        this.tabs = 1;
        this.println("void initLiterals();");
        this.tabs = 0;
        this.println("public:");
        this.tabs = 1;
        this.println("bool getCaseSensitiveLiterals() const;");
        this.tabs = 0;
        this.println("public:");
        this.tabs = 1;
        this.println(String.valueOf(this.grammar.getClassName()) + "(istream& in);");
        this.println(String.valueOf(this.grammar.getClassName()) + "(" + string + "& cb);");
        this.println("RefToken nextToken();");
        Enumeration enumeration = this.grammar.rules.elements();
        while (enumeration.hasMoreElements()) {
            RuleSymbol ruleSymbol = (RuleSymbol)enumeration.nextElement();
            if (!ruleSymbol.getId().equals("mnextToken")) {
                this.genRuleHeader(ruleSymbol, false);
            }
            this.exitIfError();
        }
        if (this.grammar.debuggingOutput) {
            this.tabs = 0;
            this.println("public:");
            this.tabs = 1;
            this.println("static const char* _ruleNames[];");
        }
        this.tabs = 0;
        this.println("private:");
        this.tabs = 1;
        this.genBitsetsHeader(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size());
        this.tabs = 0;
        this.println("};");
        this.println("");
        this.println("#endif /*INC_" + this.grammar.getClassName() + "_hpp_*/");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void genInclude(ParserGrammar parserGrammar) throws IOException {
        this.currentOutput = Tool.openOutputFile(String.valueOf(this.grammar.getClassName()) + ".hpp");
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.println("#ifndef INC_" + this.grammar.getClassName() + "_hpp_");
        this.println("#define INC_" + this.grammar.getClassName() + "_hpp_");
        this.println("");
        this.println("#include <antlr/config.hpp>");
        this.genHeader();
        this.println(this.behavior.headerAction);
        this.println("#include <sys/types.h>");
        this.println("#include <antlr/Tokenizer.hpp>");
        this.println("#include <antlr/TokenBuffer.hpp>");
        this.println("#include <antlr/" + this.grammar.getSuperClass() + ".hpp>");
        this.println("#include \"" + this.grammar.tokenManager.getName() + "TokenTypes.hpp\"");
        this.println("");
        String string = null;
        string = this.grammar.superClass != null ? this.grammar.superClass : this.grammar.getSuperClass();
        this.println("class " + this.grammar.getClassName() + " : public " + string);
        this.println(" {");
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction, 0, this.currentRule, null));
        this.println("public:");
        this.tabs = 1;
        this.tabs = 0;
        this.println("protected:");
        this.tabs = 1;
        this.println(String.valueOf(this.grammar.getClassName()) + "(TokenBuffer& tokenBuf, int k);");
        this.tabs = 0;
        this.println("public:");
        this.tabs = 1;
        this.println(String.valueOf(this.grammar.getClassName()) + "(TokenBuffer& tokenBuf);");
        this.tabs = 0;
        this.println("protected:");
        this.tabs = 1;
        this.println(String.valueOf(this.grammar.getClassName()) + "(Tokenizer& lexer, int k);");
        this.tabs = 0;
        this.println("public:");
        this.tabs = 1;
        this.println(String.valueOf(this.grammar.getClassName()) + "(Tokenizer& lexer);");
        Enumeration enumeration = this.grammar.rules.elements();
        while (enumeration.hasMoreElements()) {
            GrammarSymbol grammarSymbol = (GrammarSymbol)enumeration.nextElement();
            if (grammarSymbol instanceof RuleSymbol) {
                RuleSymbol ruleSymbol = (RuleSymbol)grammarSymbol;
                this.genRuleHeader(ruleSymbol, ruleSymbol.references.size() == 0);
            }
            this.exitIfError();
        }
        if (this.grammar.debuggingOutput) {
            this.println("public: static const char* _ruleNames[];");
        }
        this.tabs = 0;
        this.println("private:");
        this.tabs = 1;
        this.println("static const char* _tokenNames[];");
        this.genBitsetsHeader(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        this.tabs = 0;
        this.println("};");
        this.println("");
        this.println("#endif /*INC_" + this.grammar.getClassName() + "_hpp_*/");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void genInclude(TreeWalkerGrammar treeWalkerGrammar) throws IOException {
        this.currentOutput = Tool.openOutputFile(String.valueOf(this.grammar.getClassName()) + ".hpp");
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.println("#ifndef INC_" + this.grammar.getClassName() + "_hpp_");
        this.println("#define INC_" + this.grammar.getClassName() + "_hpp_");
        this.println("");
        this.println("#include <antlr/config.hpp>");
        this.genHeader();
        this.println(this.behavior.headerAction);
        String string = null;
        if (this.grammar.superClass != null) {
            string = this.grammar.superClass;
            this.println("#include \"" + string + ".hpp\"");
        } else {
            string = this.grammar.getSuperClass();
            this.println("#include <antlr/" + this.grammar.getSuperClass() + ".hpp>");
        }
        this.println("#include \"" + this.grammar.tokenManager.getName() + "TokenTypes.hpp\"");
        this.println(this.grammar.preambleAction);
        this.print(String.valueOf(System.getProperty("line.separator")) + "class " + this.grammar.getClassName() + " : public " + string);
        this.println(" {");
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction, 0, this.currentRule, null));
        this.tabs = 0;
        this.println("public:");
        this.tabs = 1;
        this.println(String.valueOf(this.grammar.getClassName()) + "();");
        Enumeration enumeration = this.grammar.rules.elements();
        while (enumeration.hasMoreElements()) {
            GrammarSymbol grammarSymbol = (GrammarSymbol)enumeration.nextElement();
            if (grammarSymbol instanceof RuleSymbol) {
                RuleSymbol ruleSymbol = (RuleSymbol)grammarSymbol;
                this.genRuleHeader(ruleSymbol, ruleSymbol.references.size() == 0);
            }
            this.exitIfError();
        }
        this.tabs = 0;
        this.println("private:");
        this.tabs = 1;
        this.println("static const char* _tokenNames[];");
        this.genBitsetsHeader(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        this.tabs = 0;
        this.println("};");
        this.println("");
        this.println("#endif /*INC_" + this.grammar.getClassName() + "_hpp_*/");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    private void genLiteralsTest() {
        this.println("_ttype = testLiteralsTable(_ttype);");
    }

    protected void genMatch(BitSet bitSet) {
    }

    protected void genMatch(GrammarAtom grammarAtom) {
        if (grammarAtom instanceof StringLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(grammarAtom);
                return;
            }
            this.genMatchUsingAtomTokenType(grammarAtom);
            return;
        }
        if (grammarAtom instanceof CharLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(grammarAtom);
                return;
            }
            this.tool.error("cannot ref character literals in grammar: " + grammarAtom);
            return;
        }
        if (grammarAtom instanceof TokenRefElement) {
            this.genMatchUsingAtomText(grammarAtom);
        }
    }

    protected void genMatchUsingAtomText(GrammarAtom grammarAtom) {
        String string = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            string = "_t,";
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || grammarAtom.getAutoGenType() == 3)) {
            this.println("_saveIndex=text.length();");
        }
        this.print(grammarAtom.not ? "matchNot(" : "match(");
        this._print(string);
        if (grammarAtom.atomText.equals("EOF")) {
            this._print("Token::EOF_TYPE");
        } else {
            this._print(grammarAtom.atomText);
        }
        this._println(");");
        if (this.grammar instanceof LexerGrammar && (!this.saveText || grammarAtom.getAutoGenType() == 3)) {
            this.println("text.erase(_saveIndex);");
        }
    }

    protected void genMatchUsingAtomTokenType(GrammarAtom grammarAtom) {
        String string = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            string = "_t,";
        }
        String string2 = String.valueOf(string) + this.getValueString(grammarAtom.tokenType);
        this.println(String.valueOf(grammarAtom.not ? "matchNot(" : "match(") + string2 + ");");
    }

    public void genNextToken() {
        Object object;
        Object object2;
        boolean bl = false;
        int n = 0;
        while (n < this.grammar.rules.size()) {
            object2 = (RuleSymbol)this.grammar.rules.elementAt(n);
            if (((RuleSymbol)object2).isDefined() && ((RuleSymbol)object2).access.equals("public")) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.println("");
            this.println("RefToken " + this.grammar.getClassName() + "::nextToken() { return RefToken(new CommonToken(Token::EOF_TYPE, \"\")); }");
            this.println("");
            return;
        }
        object2 = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol ruleSymbol = new RuleSymbol("mnextToken");
        ruleSymbol.setDefined();
        ruleSymbol.setBlock((RuleBlock)object2);
        ruleSymbol.access = "private";
        this.grammar.define(ruleSymbol);
        this.grammar.theLLkAnalyzer.deterministic((AlternativeBlock)object2);
        this.println(String.valueOf(System.getProperty("line.separator")) + "RefToken " + this.grammar.getClassName() + "::nextToken()");
        this.println("{");
        ++this.tabs;
        this.println("RefToken _rettoken;");
        this.println("for (;;) {");
        ++this.tabs;
        this.println("RefToken _rettoken;");
        this.println("int _ttype = Token::INVALID_TYPE;");
        this.println("resetText();");
        this.println("try {   // for error handling");
        ++this.tabs;
        int n2 = 0;
        while (n2 < ((AlternativeBlock)object2).getAlternatives().size()) {
            object = ((AlternativeBlock)object2).getAlternativeAt(n2);
            if (((Alternative)object).cache[1].containsEpsilon()) {
                Tool.warning("found optional path in nextToken()");
            }
            ++n2;
        }
        object = this.genCommonBlock((AlternativeBlock)object2, false);
        this.genBlockFinish((CppBlockFinishingInfo)object, "if (LA(1)!=EOF_CHAR) " + this.throwNoViable + "_returnToken = makeToken(Token::EOF_TYPE);");
        this.println("_ttype = _returnToken->getType();");
        if (((LexerGrammar)this.grammar).getTestLiterals()) {
            this.genLiteralsTest();
        }
        this.println("if ( _ttype!=Token::SKIP ) {");
        ++this.tabs;
        this.println("_returnToken->setType(_ttype);");
        this.println("return _returnToken;");
        --this.tabs;
        this.println("}");
        --this.tabs;
        this.println("}");
        this.println("catch (ScannerException& e) {");
        ++this.tabs;
        this.println("consume();");
        this.println("reportError(e);");
        --this.tabs;
        this.println("}");
        --this.tabs;
        this.println("}");
        --this.tabs;
        this.println("}" + System.getProperty("line.separator"));
    }

    public void genRule(RuleSymbol ruleSymbol, boolean bl, int n, String string) {
        String string2;
        Object object;
        RuleBlock ruleBlock;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRule(" + ruleSymbol.getId() + ")");
        }
        if (!ruleSymbol.isDefined()) {
            this.tool.error("undefined rule: " + ruleSymbol.getId());
            return;
        }
        this.currentRule = ruleBlock = ruleSymbol.getBlock();
        this.currentASTResult = ruleSymbol.getId();
        boolean bl2 = this.genAST;
        this.genAST = this.genAST && ruleBlock.getAutoGen();
        this.saveText = ruleBlock.getAutoGen();
        if (ruleBlock.returnAction != null) {
            this._print(String.valueOf(this.extractTypeOfAction(ruleBlock.returnAction, ruleBlock.getLine())) + " ");
        } else {
            this._print("void ");
        }
        this._print(String.valueOf(string) + ruleSymbol.getId() + "(");
        this._print(this.commonExtraParams);
        if (this.commonExtraParams.length() != 0 && ruleBlock.argAction != null) {
            this._print(",");
        }
        if (ruleBlock.argAction != null) {
            this._println("");
            ++this.tabs;
            this.println(ruleBlock.argAction);
            --this.tabs;
            this.print(")");
        } else {
            this._print(")");
        }
        this._println(" {");
        ++this.tabs;
        if (ruleBlock.returnAction != null) {
            this.println(String.valueOf(ruleBlock.returnAction) + ";");
        }
        this.println(this.commonLocalVars);
        if (this.grammar.traceRules) {
            this.println("Tracer traceInOut(this,\"" + ruleSymbol.getId() + "\");");
        }
        if (this.grammar instanceof LexerGrammar) {
            if (ruleSymbol.getId().equals("mEOF")) {
                this.println("_ttype = Token::EOF_TYPE;");
            } else {
                this.println("_ttype = " + ruleSymbol.getId().substring(1) + ";");
            }
            this.println("int _saveIndex;");
        }
        if (this.grammar.buildAST) {
            this.println("returnAST = nullAST;");
            this.println("ASTPair currentAST;");
            this.println(String.valueOf(this.labeledElementASTType) + " " + ruleSymbol.getId() + "_AST = nullAST;");
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println(String.valueOf(this.labeledElementASTType) + " " + ruleSymbol.getId() + "_AST_in = _t;");
            }
        }
        this.genBlockPreamble(ruleBlock);
        this.println("");
        ExceptionSpec exceptionSpec = ruleBlock.findExceptionSpec("");
        if (exceptionSpec != null || ruleBlock.getDefaultErrorHandler()) {
            this.println("try {      // for error handling");
            ++this.tabs;
        }
        if (ruleBlock.alternatives.size() == 1) {
            object = ruleBlock.getAlternativeAt(0);
            string2 = ((Alternative)object).semPred;
            if (string2 != null) {
                this.genSemPred(string2);
            }
            if (((Alternative)object).synPred != null) {
                Tool.warning("Syntactic predicate ignored for single alternative", ((Alternative)object).synPred.getLine());
            }
            this.genAlt((Alternative)object, ruleBlock);
        } else {
            this.grammar.theLLkAnalyzer.deterministic(ruleBlock);
            object = this.genCommonBlock(ruleBlock, false);
            this.genBlockFinish((CppBlockFinishingInfo)object, this.throwNoViable);
        }
        if (exceptionSpec != null || ruleBlock.getDefaultErrorHandler()) {
            --this.tabs;
            this.println("}");
        }
        if (exceptionSpec != null) {
            this.genErrorHandler(exceptionSpec);
        } else if (ruleBlock.getDefaultErrorHandler()) {
            this.println("catch (" + this.exceptionThrown + "& ex) {");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if (guessing==0) {");
                ++this.tabs;
            }
            this.println("reportError(ex.toString());");
            if (!(this.grammar instanceof TreeWalkerGrammar)) {
                object = this.grammar.theLLkAnalyzer.FOLLOW(1, ruleBlock.endNode);
                string2 = this.getBitsetName(this.markBitsetForGen(((Lookahead)object).fset));
                this.println("consume();");
                this.println("consumeUntil(" + string2 + ");");
            } else {
                this.println("if (_t!=nullAST) {_t = _t->getNextSibling();}");
            }
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("} else {");
                ++this.tabs;
                this.println("throw ex;");
                --this.tabs;
                this.println("}");
            }
            --this.tabs;
            this.println("}");
        }
        if (this.grammar.buildAST) {
            this.println("returnAST = " + ruleSymbol.getId() + "_AST;");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_retTree = _t;");
        }
        if (ruleBlock.getTestLiterals()) {
            this.genLiteralsTest();
        }
        if (this.grammar instanceof LexerGrammar) {
            this.println("if ( _createToken && _token==0 ) {");
            this.println("   _token = makeToken(_ttype);");
            this.println("   _token->setText(text.substr(_begin, text.length()-_begin));");
            this.println("}");
            this.println("_returnToken = _token;");
        }
        if (ruleBlock.returnAction != null) {
            this.println("return " + this.extractIdOfAction(ruleBlock.returnAction, ruleBlock.getLine()) + ";");
        }
        --this.tabs;
        this.println("}" + System.getProperty("line.separator"));
        this.genAST = bl2;
    }

    public void genRuleHeader(RuleSymbol ruleSymbol, boolean bl) {
        RuleBlock ruleBlock;
        this.tabs = 1;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRuleHeader(" + ruleSymbol.getId() + ")");
        }
        if (!ruleSymbol.isDefined()) {
            this.tool.error("undefined rule: " + ruleSymbol.getId());
            return;
        }
        this.currentRule = ruleBlock = ruleSymbol.getBlock();
        this.currentASTResult = ruleSymbol.getId();
        boolean bl2 = this.genAST;
        this.genAST = this.genAST && ruleBlock.getAutoGen();
        this.saveText = ruleBlock.getAutoGen();
        this.print(String.valueOf(ruleSymbol.access) + ": ");
        if (ruleBlock.returnAction != null) {
            this._print(String.valueOf(this.extractTypeOfAction(ruleBlock.returnAction, ruleBlock.getLine())) + " ");
        } else {
            this._print("void ");
        }
        this._print(String.valueOf(ruleSymbol.getId()) + "(");
        this._print(this.commonExtraParams);
        if (this.commonExtraParams.length() != 0 && ruleBlock.argAction != null) {
            this._print(",");
        }
        if (ruleBlock.argAction != null) {
            this._println("");
            ++this.tabs;
            this.println(ruleBlock.argAction);
            --this.tabs;
            this.print(")");
        } else {
            this._print(")");
        }
        this._println(";");
        --this.tabs;
        this.genAST = bl2;
    }

    private void GenRuleInvocation(RuleRefElement ruleRefElement) {
        this._print(String.valueOf(ruleRefElement.targetRule) + "(");
        if (this.grammar instanceof LexerGrammar) {
            if (ruleRefElement.getLabel() != null) {
                this._print("true");
            } else {
                this._print("false");
            }
            if (this.commonExtraArgs.length() != 0 || ruleRefElement.args != null) {
                this._print(",");
            }
        }
        this._print(this.commonExtraArgs);
        if (this.commonExtraArgs.length() != 0 && ruleRefElement.args != null) {
            this._print(",");
        }
        RuleSymbol ruleSymbol = (RuleSymbol)this.grammar.getSymbol(ruleRefElement.targetRule);
        if (ruleRefElement.args != null) {
            ActionTransInfo actionTransInfo = new ActionTransInfo();
            String string = this.processActionForTreeSpecifiers(ruleRefElement.args, 0, this.currentRule, actionTransInfo);
            if (actionTransInfo.assignToRoot || actionTransInfo.refRuleRoot != null) {
                this.tool.error("Arguments of rule reference '" + ruleRefElement.targetRule + "' cannot set or ref #" + this.currentRule.getRuleName() + " on line " + ruleRefElement.getLine());
            }
            this._print(string);
            if (ruleSymbol.block.argAction == null) {
                Tool.warning("Rule '" + ruleRefElement.targetRule + "' accepts no arguments", ruleRefElement.getLine());
            }
        }
        this._println(");");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _retTree;");
        }
    }

    protected void genSemPred(String string) {
        this.println("if (!(" + string + ")) {");
        ++this.tabs;
        this.println("throw SemanticException(\"" + this.charFormatter.escapeString(string) + "\");");
        --this.tabs;
        this.println("}");
    }

    protected void genSynPred(SynPredBlock synPredBlock, String string) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen=>(" + synPredBlock + ")");
        }
        this.println("bool synPredMatched" + synPredBlock.ID + " = false;");
        this.println("if (" + string + ") {");
        ++this.tabs;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("RefAST __t" + synPredBlock.ID + " = _t;");
        } else {
            this.println("int _m" + synPredBlock.ID + " = mark();");
        }
        this.println("synPredMatched" + synPredBlock.ID + " = true;");
        this.println("guessing++;");
        ++this.syntacticPredLevel;
        this.println("try {");
        ++this.tabs;
        this.gen(synPredBlock);
        --this.tabs;
        this.println("}");
        this.println("catch (" + this.exceptionThrown + "& pe) {");
        ++this.tabs;
        this.println("synPredMatched" + synPredBlock.ID + " = false;");
        --this.tabs;
        this.println("}");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = __t" + synPredBlock.ID + ";");
        } else {
            this.println("rewind(_m" + synPredBlock.ID + ");");
        }
        this.println("guessing--;");
        --this.syntacticPredLevel;
        --this.tabs;
        this.println("}");
        this.println("if ( synPredMatched" + synPredBlock.ID + " ) {");
    }

    public void genTokenStrings(String string) {
        this.println("const char* " + string + "_tokenNames[] = {");
        ++this.tabs;
        Vector vector = this.grammar.tokenManager.getVocabulary();
        int n = 0;
        while (n < vector.size()) {
            TokenSymbol tokenSymbol;
            String string2 = (String)vector.elementAt(n);
            if (string2 == null) {
                string2 = "<" + String.valueOf(n) + ">";
            }
            if (!string2.startsWith("\"") && !string2.startsWith("<") && (tokenSymbol = this.grammar.tokenManager.getTokenSymbol(string2)) != null && tokenSymbol.getParaphrase() != null) {
                string2 = Tool.stripFrontBack(tokenSymbol.getParaphrase(), "\"", "\"");
            }
            this.print(this.charFormatter.literalString(string2));
            this._println(",");
            ++n;
        }
        this._println("0");
        --this.tabs;
        this.println("};");
    }

    protected void genTokenTypes(TokenManager tokenManager) throws IOException {
        this.currentOutput = Tool.openOutputFile(String.valueOf(tokenManager.getName()) + "TokenTypes.hpp");
        this.tabs = 0;
        this.println("#ifndef INC_" + tokenManager.getName() + "TokenTypes_hpp_");
        this.println("#define INC_" + tokenManager.getName() + "TokenTypes_hpp_");
        this.println("");
        this.println("#include <antlr/config.hpp>");
        this.genHeader();
        this.println(this.behavior.headerAction);
        this.println("enum " + tokenManager.getName() + "TokenTypes {");
        ++this.tabs;
        Vector vector = tokenManager.getVocabulary();
        this.println("EOF_ = " + 1 + ",");
        this.println("NULL_TREE_LOOKAHEAD = " + 3 + ",");
        int n = 4;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (string != null) {
                if (string.startsWith("\"")) {
                    StringLiteralSymbol stringLiteralSymbol = (StringLiteralSymbol)this.grammar.tokenManager.getTokenSymbol(string);
                    if (stringLiteralSymbol == null) {
                        Tool.panic("String literal " + string + " not in symbol table");
                    } else if (stringLiteralSymbol.label != null) {
                        this.println(String.valueOf(stringLiteralSymbol.label) + " = " + n + ",");
                    } else {
                        String string2 = this.mangleLiteral(string);
                        if (string2 != null) {
                            this.println(String.valueOf(string2) + " = " + n + ",");
                            stringLiteralSymbol.label = string2;
                        } else {
                            this.println("// " + string + " = " + n);
                        }
                    }
                } else if (!string.startsWith("<")) {
                    this.println(String.valueOf(string) + " = " + n + ",");
                }
            }
            ++n;
        }
        --this.tabs;
        this.println("};");
        this.println("#endif /*INC_" + tokenManager.getName() + "TokenTypes_hpp_*/");
        this.currentOutput.close();
        this.currentOutput = null;
        this.exitIfError();
    }

    public String getASTCreateString(Vector vector) {
        if (vector.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("astFactory.make( (new ASTArray(" + vector.size() + "))");
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append("->add(" + vector.elementAt(n) + ")");
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getASTCreateString(String string) {
        return "astFactory.create(" + string + ")";
    }

    protected String getLookaheadTestExpression(Alternative alternative, int n) {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n2 = alternative.lookaheadDepth;
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.grammar.maxk;
        }
        if (n == 0) {
            return "true";
        }
        boolean bl = true;
        int n3 = 1;
        while (n3 <= n2 && n3 <= n) {
            BitSet bitSet = alternative.cache[n3].fset;
            if (!bl) {
                stringBuffer.append(") && (");
            }
            bl = false;
            if (alternative.cache[n3].containsEpsilon()) {
                stringBuffer.append("true");
            } else {
                stringBuffer.append(this.getLookaheadTestTerm(n3, bitSet));
            }
            ++n3;
        }
        stringBuffer.append(")");
        return "(" + stringBuffer.toString() + ")";
    }

    protected String getLookaheadTestTerm(int n, BitSet bitSet) {
        String string = this.lookaheadString(n);
        int[] nArray = bitSet.toArray();
        if (CodeGenerator.elementsAreRange(nArray)) {
            return this.getRangeExpression(n, nArray);
        }
        if (bitSet.degree() >= this.bitsetTestThreshold) {
            int n2 = this.markBitsetForGen(bitSet);
            return String.valueOf(this.getBitsetName(n2)) + ".member(" + string + ")";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < nArray.length) {
            String string2 = this.getValueString(nArray[n3]);
            if (n3 > 0) {
                stringBuffer.append("||");
            }
            stringBuffer.append(string);
            stringBuffer.append("==");
            stringBuffer.append(string2);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public String getRangeExpression(int n, int[] nArray) {
        if (!CodeGenerator.elementsAreRange(nArray)) {
            Tool.panic("getRangeExpression called with non-range");
        }
        int n2 = nArray[0];
        int n3 = nArray[nArray.length - 1];
        return "(" + this.lookaheadString(n) + " >= " + this.getValueString(n2) + " && " + this.lookaheadString(n) + " <= " + this.getValueString(n3) + ")";
    }

    private String getValueString(int n) {
        String string;
        if (this.grammar instanceof LexerGrammar) {
            String string2 = this.charFormatter.literalChar(n);
            return string2;
        }
        String string3 = this.grammar.tokenManager.getTokenStringAt(n);
        if (string3 == null) {
            Tool.panic("vocabulary for token type " + n + " is null");
        }
        if (string3.equals("EOF")) {
            string = "Token::EOF_TYPE";
        } else if (string3.startsWith("\"")) {
            string = this.mangleLiteral(string3);
            if (string == null) {
                string = String.valueOf(n);
            }
        } else {
            string = string3;
        }
        return string;
    }

    protected boolean lookaheadIsEmpty(Alternative alternative, int n) {
        int n2 = alternative.lookaheadDepth;
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.grammar.maxk;
        }
        int n3 = 1;
        while (n3 <= n2 && n3 <= n) {
            BitSet bitSet = alternative.cache[n3].fset;
            if (bitSet.degree() != 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private String lookaheadString(int n) {
        if (this.grammar instanceof TreeWalkerGrammar) {
            return "_t->getType()";
        }
        return "LA(" + n + ")";
    }

    private String mangleLiteral(String string) {
        String string2 = Tool.literalsPrefix;
        int n = 1;
        while (n < string.length() - 1) {
            if (!Character.isLetter(string.charAt(n)) && string.charAt(n) != '_') {
                return null;
            }
            string2 = String.valueOf(string2) + string.charAt(n);
            ++n;
        }
        if (Tool.upperCaseMangledLiterals) {
            string2 = string2.toUpperCase();
        }
        return string2;
    }

    public String mapTreeId(String string, ActionTransInfo actionTransInfo) {
        Object object;
        if (this.currentRule == null) {
            return string;
        }
        boolean bl = false;
        String string2 = string;
        if (this.grammar instanceof TreeWalkerGrammar && string2.length() > 3 && string2.lastIndexOf("_in") == string2.length() - 3) {
            string2 = string2.substring(0, string2.length() - 3);
            bl = true;
        }
        int n = 0;
        while (n < this.currentRule.labeledElements.size()) {
            object = (AlternativeElement)this.currentRule.labeledElements.elementAt(n);
            if (((AlternativeElement)object).getLabel().equals(string2)) {
                if (bl) {
                    return string2;
                }
                return String.valueOf(string2) + "_AST";
            }
            ++n;
        }
        object = (String)this.treeVariableMap.get(string2);
        if (object != null) {
            if (object == NONUNIQUE) {
                return null;
            }
            if (((String)object).equals(this.currentRule.getRuleName())) {
                return null;
            }
            if (bl) {
                return String.valueOf(object) + "_in";
            }
            return object;
        }
        if (string2.equals(this.currentRule.getRuleName())) {
            String string3;
            String string4 = string3 = bl ? String.valueOf(string2) + "_AST_in" : String.valueOf(string2) + "_AST";
            if (actionTransInfo != null && !bl) {
                actionTransInfo.refRuleRoot = string3;
            }
            return string3;
        }
        return string2;
    }

    private void mapTreeVariable(AlternativeElement alternativeElement, String string) {
        if (alternativeElement instanceof TreeElement) {
            this.mapTreeVariable(((TreeElement)alternativeElement).root, string);
            return;
        }
        String string2 = null;
        if (alternativeElement.getLabel() == null) {
            if (alternativeElement instanceof TokenRefElement) {
                string2 = ((TokenRefElement)alternativeElement).atomText;
            } else if (alternativeElement instanceof RuleRefElement) {
                string2 = ((RuleRefElement)alternativeElement).targetRule;
            }
        }
        if (string2 != null) {
            if (this.treeVariableMap.get(string2) != null) {
                this.treeVariableMap.remove(string2);
                this.treeVariableMap.put(string2, NONUNIQUE);
                return;
            }
            this.treeVariableMap.put(string2, string);
        }
    }

    private void setupGrammarParameters(Grammar grammar) {
        if (grammar instanceof ParserGrammar) {
            String string;
            Token token;
            this.labeledElementASTType = "RefAST";
            if (grammar.hasOption("ASTLabelType") && (token = grammar.getOption("ASTLabelType")) != null && (string = Tool.stripFrontBack(token.getText(), "\"", "\"")) != null) {
                this.labeledElementASTType = string;
            }
            this.labeledElementType = "RefToken ";
            this.labeledElementInit = "RefToken(0)";
            this.commonExtraArgs = "";
            this.commonExtraParams = "";
            this.commonLocalVars = "";
            this.lt1Value = "LT(1)";
            this.exceptionThrown = "ParserException";
            this.throwNoViable = "throw NoViableAltException(LT(1));";
            return;
        }
        if (grammar instanceof LexerGrammar) {
            this.labeledElementType = "char ";
            this.labeledElementInit = "'\\0'";
            this.commonExtraArgs = "";
            this.commonExtraParams = "bool _createToken";
            this.commonLocalVars = "int _ttype; RefToken _token; int _begin=text.length();";
            this.lt1Value = "LA(1)";
            this.exceptionThrown = "ScannerException";
            this.throwNoViable = "throw ScannerException(string(\"no viable alt for char: \")+LA(1),getLine());";
            return;
        }
        if (grammar instanceof TreeWalkerGrammar) {
            String string;
            Token token;
            this.labeledElementASTType = "RefAST";
            this.labeledElementType = "RefAST";
            if (grammar.hasOption("ASTLabelType") && (token = grammar.getOption("ASTLabelType")) != null && (string = Tool.stripFrontBack(token.getText(), "\"", "\"")) != null) {
                this.labeledElementASTType = string;
                this.labeledElementType = string;
            }
            if (!grammar.hasOption("ASTLabelType")) {
                grammar.setOption("ASTLabelType", new Token(17, "RefAST"));
            }
            this.labeledElementInit = "nullAST";
            this.commonExtraArgs = "_t";
            this.commonExtraParams = "RefAST _t";
            this.commonLocalVars = "";
            this.lt1Value = "_t";
            this.exceptionThrown = "ParserException";
            this.throwNoViable = "throw NoViableAltException();";
            return;
        }
        Tool.panic("Unknown grammar type");
    }
}

