/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Stack;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CSH {
    private static Hashtable comps;
    private static final boolean debug = false;

    private static void debug(Object object) {
    }

    private static void dispatchEvent(Object object, AWTEvent aWTEvent) {
        if (object instanceof Component) {
            ((Component)object).dispatchEvent(aWTEvent);
        } else if (object instanceof MenuComponent) {
            ((MenuComponent)object).dispatchEvent(aWTEvent);
        }
    }

    private static Component findComponentAt(Container container, int n, int n2) {
        if (!container.contains(n, n2)) {
            return null;
        }
        int n3 = container.getComponentCount();
        Component[] componentArray = container.getComponents();
        int n4 = 0;
        while (n4 < n3) {
            Component component = componentArray[n4];
            if (component != null) {
                Point point = component.getLocation();
                if ((component = component instanceof Container ? CSH.findComponentAt((Container)component, n - point.x, n2 - point.y) : component.locate(n - point.x, n2 - point.y)) != null && component.isVisible()) {
                    return component;
                }
            }
            ++n4;
        }
        return container;
    }

    private static Object getDeepestObjectAt(Object object, int n, int n2) {
        Component component;
        if (object != null && object instanceof Container && (component = CSH.findComponentAt((Container)object, n, n2)) != null && component != object) {
            if (component instanceof JRootPane) {
                JLayeredPane jLayeredPane = ((JRootPane)component).getLayeredPane();
                Rectangle rectangle = jLayeredPane.getBounds();
                component = (Component)CSH.getDeepestObjectAt(jLayeredPane, n - rectangle.x, n2 - rectangle.y);
                if (component != null) {
                    return component;
                }
            } else {
                return component;
            }
        }
        return object;
    }

    public static String getHelpIDString(Component component) {
        Serializable serializable;
        String string = null;
        if (component instanceof JComponent) {
            string = (String)((JComponent)component).getClientProperty("HelpID");
        } else if (comps != null && (serializable = (Hashtable)comps.get(component)) != null) {
            string = (String)((Hashtable)serializable).get("HelpID");
        }
        if (string != null) {
            return string;
        }
        serializable = component.getParent();
        if (serializable != null) {
            return CSH.getHelpIDString((Component)serializable);
        }
        return null;
    }

    public static String getHelpIDString(MenuItem menuItem) {
        Object object;
        String string = null;
        if (comps != null && (object = (Hashtable)comps.get(menuItem)) != null) {
            string = (String)((Hashtable)object).get("HelpID");
        }
        if (string != null) {
            return string;
        }
        object = menuItem.getParent();
        if (object != null && object instanceof MenuItem) {
            return CSH.getHelpIDString((MenuItem)object);
        }
        return null;
    }

    public static HelpSet getHelpSet(Component component) {
        Serializable serializable;
        String string = null;
        HelpSet helpSet = null;
        if (component instanceof JComponent) {
            string = (String)((JComponent)component).getClientProperty("HelpID");
            if (string != null) {
                helpSet = (HelpSet)((JComponent)component).getClientProperty("HelpSet");
            }
        } else if (comps != null && (serializable = (Hashtable)comps.get(component)) != null && (string = (String)((Hashtable)serializable).get("HelpID")) != null) {
            helpSet = (HelpSet)((Hashtable)serializable).get("HelpSet");
        }
        if (string != null) {
            return helpSet;
        }
        serializable = component.getParent();
        if (serializable != null) {
            return CSH.getHelpSet((Component)serializable);
        }
        return null;
    }

    public static HelpSet getHelpSet(MenuItem menuItem) {
        Object object;
        String string = null;
        HelpSet helpSet = null;
        if (comps != null && (object = (Hashtable)comps.get(menuItem)) != null && (string = (String)((Hashtable)object).get("HelpID")) != null) {
            helpSet = (HelpSet)((Hashtable)object).get("HelpSet");
        }
        if (string != null) {
            return helpSet;
        }
        object = menuItem.getParent();
        if (object != null && object instanceof MenuItem) {
            return CSH.getHelpSet((MenuItem)object);
        }
        return null;
    }

    public static void setHelpIDString(Component component, String string) {
        if (component == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("HelpID", string);
        } else {
            Hashtable<String, String> hashtable;
            if (comps == null) {
                comps = new Hashtable(5);
            }
            if ((hashtable = (Hashtable<String, String>)comps.get(component)) != null) {
                if (string != null) {
                    hashtable.put("HelpID", string);
                } else {
                    hashtable.remove(string);
                }
            } else if (string != null) {
                hashtable = new Hashtable<String, String>(2);
                hashtable.put("HelpID", string);
                comps.put(component, hashtable);
            }
        }
    }

    public static void setHelpIDString(MenuItem menuItem, String string) {
        Hashtable<String, String> hashtable;
        if (menuItem == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (comps == null) {
            comps = new Hashtable(5);
        }
        if ((hashtable = (Hashtable<String, String>)comps.get(menuItem)) != null) {
            if (string != null) {
                hashtable.put("HelpID", string);
            } else {
                hashtable.remove(string);
            }
        } else if (string != null) {
            hashtable = new Hashtable<String, String>(2);
            hashtable.put("HelpID", string);
            comps.put(menuItem, hashtable);
        }
    }

    public static void setHelpSet(Component component, HelpSet helpSet) {
        if (component == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("HelpSet", helpSet);
        } else {
            Hashtable<String, HelpSet> hashtable;
            if (comps == null) {
                comps = new Hashtable(5);
            }
            if ((hashtable = (Hashtable<String, HelpSet>)comps.get(component)) != null) {
                if (helpSet != null) {
                    hashtable.put("HelpSet", helpSet);
                } else {
                    hashtable.remove(helpSet);
                }
            } else if (helpSet != null) {
                hashtable = new Hashtable<String, HelpSet>(2);
                hashtable.put("HelpSet", helpSet);
                comps.put(component, hashtable);
            }
        }
    }

    public static void setHelpSet(MenuItem menuItem, HelpSet helpSet) {
        Hashtable<String, HelpSet> hashtable;
        if (menuItem == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (comps == null) {
            comps = new Hashtable(5);
        }
        if ((hashtable = (Hashtable<String, HelpSet>)comps.get(menuItem)) != null) {
            if (helpSet != null) {
                hashtable.put("HelpSet", helpSet);
            } else {
                hashtable.remove(helpSet);
            }
        } else if (helpSet != null) {
            hashtable = new Hashtable<String, HelpSet>(2);
            hashtable.put("HelpSet", helpSet);
            comps.put(menuItem, hashtable);
        }
    }

    public static Object trackCSEvents() {
        block30: {
            boolean bl = true;
            try {
                EventQueue eventQueue;
                if (!Thread.currentThread().getClass().getName().endsWith("EventDispatchThread")) break block30;
                try {
                    eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
                catch (Exception exception) {
                    return null;
                }
                if (eventQueue == null) {
                    return null;
                }
                while (true) {
                    Serializable serializable;
                    AWTEvent aWTEvent = eventQueue.getNextEvent();
                    Object object = aWTEvent.getSource();
                    try {
                        serializable = Class.forName("java.awt.ActiveEvent");
                        if (serializable != null && ((Class)serializable).isInstance(aWTEvent)) {
                            Method method = null;
                            Class[] classArray = new Class[]{};
                            Object[] objectArray = new Object[]{};
                            method = ((Class)serializable).getMethod("dispatch", classArray);
                            if (method != null) {
                                method.invoke((Object)aWTEvent, objectArray);
                                continue;
                            }
                        }
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                    if (object instanceof Component) {
                        if (aWTEvent instanceof InputEvent) {
                            if (aWTEvent instanceof KeyEvent) {
                                serializable = (KeyEvent)aWTEvent;
                                if (((KeyEvent)serializable).getKeyCode() == 3) {
                                    ((InputEvent)serializable).consume();
                                    return null;
                                }
                                CSH.dispatchEvent(object, aWTEvent);
                                continue;
                            }
                            if (aWTEvent instanceof MouseEvent) {
                                serializable = (MouseEvent)aWTEvent;
                                int n = ((AWTEvent)serializable).getID();
                                if (n == 500 || n == 501 || n == 502) {
                                    if (n == 500) {
                                        if (bl) {
                                            bl = false;
                                            CSH.dispatchEvent(object, aWTEvent);
                                            continue;
                                        }
                                        ((InputEvent)serializable).consume();
                                        return CSH.getDeepestObjectAt(object, ((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY());
                                    }
                                    ((InputEvent)serializable).consume();
                                    continue;
                                }
                                ((InputEvent)serializable).consume();
                                continue;
                            }
                            CSH.dispatchEvent(object, aWTEvent);
                            continue;
                        }
                        CSH.dispatchEvent(object, aWTEvent);
                        continue;
                    }
                    if (object instanceof MenuComponent) {
                        if (object instanceof MenuItem) {
                            if (!(aWTEvent instanceof InputEvent)) continue;
                            if (aWTEvent instanceof KeyEvent) {
                                serializable = (KeyEvent)aWTEvent;
                                if (((KeyEvent)serializable).getKeyCode() == 3) {
                                    ((InputEvent)serializable).consume();
                                    return null;
                                }
                                CSH.dispatchEvent(object, aWTEvent);
                                continue;
                            }
                            if (aWTEvent instanceof MouseEvent) {
                                serializable = (MouseEvent)aWTEvent;
                                int n = ((AWTEvent)serializable).getID();
                                if (n == 500 || n == 501 || n == 502) {
                                    if (n == 500) {
                                        if (bl) {
                                            bl = false;
                                            CSH.dispatchEvent(object, aWTEvent);
                                            continue;
                                        }
                                        ((InputEvent)serializable).consume();
                                        return CSH.getDeepestObjectAt(object, ((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY());
                                    }
                                    ((InputEvent)serializable).consume();
                                    continue;
                                }
                                ((InputEvent)serializable).consume();
                                continue;
                            }
                            CSH.dispatchEvent(object, aWTEvent);
                            continue;
                        }
                        CSH.dispatchEvent(object, aWTEvent);
                        continue;
                    }
                    System.err.println("unable to dispatch event: " + aWTEvent);
                }
            }
            catch (InterruptedException interruptedException) {
                CSH.debug("InterrupedExeception");
            }
        }
        CSH.debug("Fall Through code");
        return null;
    }

    public static class DisplayHelpFromFocus
    implements ActionListener {
        private HelpBroker hb;

        public DisplayHelpFromFocus(HelpBroker helpBroker) {
            this.hb = helpBroker;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)actionEvent.getSource();
            Component component2 = SwingUtilities.findFocusOwner(component);
            if (component2 == null) {
                component2 = component;
            }
            String string = CSH.getHelpIDString(component2);
            HelpSet helpSet = CSH.getHelpSet(component2);
            if (helpSet == null) {
                helpSet = this.hb.getHelpSet();
            }
            try {
                Map.ID iD = Map.ID.create(string, helpSet);
                if (iD == null) {
                    iD = helpSet.getHomeID();
                }
                this.hb.setCurrentID(iD);
                this.hb.setDisplayed(true);
            }
            catch (Exception exception) {}
        }
    }

    public static class DisplayHelpAfterTracking
    implements ActionListener {
        private HelpBroker hb;
        private Hashtable cursors;
        private Stack cursorStack;

        public DisplayHelpAfterTracking(HelpBroker helpBroker) {
            this.hb = helpBroker;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            Cursor cursor = (Cursor)UIManager.get("HelpOnItemCursor");
            if (cursor == null) {
                return;
            }
            Component component = this.getTopComponentForComponent(jComponent);
            if (cursor != null) {
                this.setCursor(component, cursor);
            }
            Object object = CSH.trackCSEvents();
            String string = null;
            HelpSet helpSet = null;
            if (object != null && object instanceof Component) {
                string = CSH.getHelpIDString((Component)object);
                helpSet = CSH.getHelpSet((Component)object);
            } else if (object != null && object instanceof MenuItem) {
                string = CSH.getHelpIDString((MenuItem)object);
                helpSet = CSH.getHelpSet((MenuItem)object);
            }
            if (helpSet == null) {
                helpSet = this.hb.getHelpSet();
            }
            try {
                Map.ID iD = Map.ID.create(string, helpSet);
                if (iD == null) {
                    iD = helpSet.getHomeID();
                }
                this.hb.setCurrentID(iD);
                this.hb.setDisplayed(true);
            }
            catch (Exception exception) {}
            if (cursor != null) {
                this.resetAndRestoreCursors(component);
            }
        }

        private Component getTopComponentForComponent(Component component) {
            Component component2 = component;
            Container container = component2.getParent();
            while (container != null) {
                component2 = container;
                container = component2.getParent();
            }
            return component2;
        }

        private void resetAndRestoreCursors(Component component) {
            CSH.debug("resetAndRestoreCursors");
            this.cursorStack = new Stack();
            this.restoreCursors(component);
            this.cursors = null;
            this.cursorStack = null;
        }

        private void restoreCursors(Component component) {
            boolean bl = false;
            Cursor cursor = (Cursor)this.cursors.get(component);
            if (cursor != null) {
                this.cursorStack.push(cursor);
                component.setCursor(cursor);
                CSH.debug("restored cursor " + cursor + " on " + component);
                bl = true;
            } else if (!this.cursorStack.empty()) {
                component.setCursor((Cursor)this.cursorStack.peek());
                CSH.debug("restored cursor " + (Cursor)this.cursorStack.peek() + " on " + component);
            }
            if (component instanceof Container) {
                Container container = (Container)component;
                int n = container.getComponentCount();
                Component[] componentArray = container.getComponents();
                int n2 = 0;
                while (n2 < n) {
                    Component component2 = componentArray[n2];
                    if (component != null) {
                        this.restoreCursors(component2);
                    }
                    ++n2;
                }
            }
            if (bl) {
                this.cursorStack.pop();
            }
        }

        private void setAndStoreCursors(Component component, Cursor cursor) {
            boolean bl = false;
            Cursor cursor2 = component.getCursor();
            if (this.cursorStack.empty()) {
                this.cursorStack.push(cursor2);
                this.cursors.put(component, cursor2);
                bl = true;
                CSH.debug("store cursor " + cursor2 + " on " + component);
            } else if (cursor2 != (Cursor)this.cursorStack.peek()) {
                this.cursorStack.push(cursor2);
                this.cursors.put(component, cursor2);
                bl = true;
                CSH.debug("store cursor " + cursor2 + " on " + component);
            }
            CSH.debug("set cursor on " + component);
            component.setCursor(cursor);
            if (component instanceof Container) {
                Container container = (Container)component;
                int n = container.getComponentCount();
                Component[] componentArray = container.getComponents();
                int n2 = 0;
                while (n2 < n) {
                    Component component2 = componentArray[n2];
                    if (component != null) {
                        this.setAndStoreCursors(component2, cursor);
                    }
                    ++n2;
                }
            }
            if (bl) {
                this.cursorStack.pop();
            }
        }

        private void setCursor(Component component, Cursor cursor) {
            CSH.debug("setCursors");
            this.cursors = new Hashtable();
            this.cursorStack = new Stack();
            this.setAndStoreCursors(component, cursor);
        }
    }

    public static class DisplayHelpFromSource
    implements ActionListener {
        private HelpBroker hb;

        public DisplayHelpFromSource(HelpBroker helpBroker) {
            this.hb = helpBroker;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            String string = CSH.getHelpIDString(jComponent);
            HelpSet helpSet = CSH.getHelpSet(jComponent);
            if (helpSet == null) {
                helpSet = this.hb.getHelpSet();
            }
            try {
                Map.ID iD = Map.ID.create(string, helpSet);
                if (iD == null) {
                    iD = helpSet.getHomeID();
                }
                this.hb.setCurrentID(iD);
                this.hb.setDisplayed(true);
            }
            catch (Exception exception) {
                System.err.println("trouble in HelpActionListener");
                exception.printStackTrace();
            }
        }
    }
}

