/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ANTLRTokdefLexer;
import antlr.ANTLRTokdefParser;
import antlr.Grammar;
import antlr.ParserException;
import antlr.SimpleTokenManager;
import antlr.StringLiteralSymbol;
import antlr.TokenSymbol;
import antlr.Tool;
import java.io.FileReader;
import java.io.IOException;

class TokdefTokenManager
extends SimpleTokenManager {
    private int dummy;
    private String filename;
    private boolean noDefine = false;
    protected Grammar grammar;

    TokdefTokenManager(Grammar grammar, String string, Tool tool) {
        super("", tool);
        this.grammar = grammar;
        this.filename = string;
        try {
            FileReader fileReader = new FileReader(this.filename);
            ANTLRTokdefLexer aNTLRTokdefLexer = new ANTLRTokdefLexer(fileReader);
            ANTLRTokdefParser aNTLRTokdefParser = new ANTLRTokdefParser(aNTLRTokdefLexer);
            aNTLRTokdefParser.file(this);
            return;
        }
        catch (ParserException parserException) {
            Tool.panic("Error parsing tokdef file '" + this.filename + "': " + parserException.toString());
            return;
        }
        catch (IOException iOException) {
            Tool.panic("Error reading tokdef file '" + this.filename + "'");
            return;
        }
    }

    public void define(TokenSymbol tokenSymbol) {
        if (this.noDefine) {
            this.tool.error("New token type defined when using tokdef option");
            return;
        }
        super.define(tokenSymbol);
    }

    public void define(String string, int n) {
        TokenSymbol tokenSymbol = null;
        tokenSymbol = string.startsWith("\"") ? new StringLiteralSymbol(string) : new TokenSymbol(string);
        tokenSymbol.setTokenType(n);
        super.define(tokenSymbol);
        this.maxToken = n + 1 > this.maxToken ? n + 1 : this.maxToken;
    }

    public String getName() {
        return this.grammar.getClassName();
    }

    public boolean isReadOnly() {
        return this.filename.equals(String.valueOf(this.grammar.getClassName()) + "TokenTypes.txt");
    }

    public int nextTokenType() {
        if (this.noDefine) {
            this.tool.error("New token type defined when using tokdef option");
            return 0;
        }
        return super.nextTokenType();
    }
}

