/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Tools.ClassHierarchy;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omegahat.Environment.Interpreter.BasicEvaluator;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Tools.ClassHierarchy.ClassNode;
import org.omegahat.Environment.Tools.ClassHierarchy.ClassNodeAgent;
import org.omegahat.Environment.Tools.ClassHierarchy.InterfaceNode;
import org.omegahat.Environment.Tools.ClassHierarchy.UnavailableClassNode;

public class HierarchyGenerator
implements ClassNodeAgent {
    protected Vector classSequence = new Vector(10);
    protected Hashtable classes = new Hashtable(10);
    protected Evaluator evaluator = null;

    public HierarchyGenerator() {
    }

    public HierarchyGenerator(String[] stringArray) {
        this.addClasses(stringArray);
    }

    public ClassNode addClass(Class clazz) {
        ClassNode classNode = null;
        if (this.classes.containsKey(clazz)) {
            classNode = (ClassNode)this.classes.get(clazz);
        } else {
            classNode = clazz.isInterface() ? new InterfaceNode(clazz, this) : new ClassNode(clazz, this);
            this.addClass(classNode);
        }
        return classNode;
    }

    public ClassNode addClass(Class clazz, ClassNode classNode) {
        ClassNode classNode2 = this.addClass(clazz);
        classNode2.addChild(classNode);
        return classNode2;
    }

    public ClassNode addClass(String string) {
        ClassNode classNode;
        try {
            Class clazz = this.getClass(string);
            classNode = this.addClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNode = this.addClass(new UnavailableClassNode(string));
        }
        return classNode;
    }

    public synchronized ClassNode addClass(ClassNode classNode) {
        if (this.classes.containsKey(classNode.thisClass())) {
            return (ClassNode)this.classes.get(classNode.thisClass());
        }
        this.classes.put(classNode.thisClass(), classNode);
        this.classSequence.addElement(classNode);
        return classNode;
    }

    public int addClasses(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.addClass(stringArray[n]);
            ++n;
        }
        return stringArray.length;
    }

    public Vector compute() {
        Vector vector2 = new Vector(1);
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            ClassNode classNode = (ClassNode)enumeration.nextElement();
            classNode.compute();
        }
        return vector2;
    }

    public Vector compute(boolean bl) {
        if (!bl) {
            return this.compute();
        }
        Vector vector2 = new Vector(1);
        int n = 0;
        while (n < this.classes.size()) {
            ClassNode classNode = (ClassNode)this.classSequence.elementAt(n);
            classNode.compute();
            ++n;
        }
        return vector2;
    }

    public Evaluator evaluator() {
        if (this.evaluator == null) {
            this.evaluator(new BasicEvaluator());
        }
        return this.evaluator;
    }

    public Evaluator evaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
        return this.evaluator();
    }

    public Class findClass(String string) throws ClassNotFoundException {
        return this.evaluator().findClass(string);
    }

    public Class getClass(String string) throws ClassNotFoundException {
        Class clazz = this.findClass(string);
        return clazz;
    }

    public int listChildren(PrintStream printStream) {
        return this.listElements(printStream, false);
    }

    public void listClasses(PrintStream printStream) {
        printStream.println("Children:");
        this.listChildren(printStream);
        printStream.println("Parents:");
        this.listParents(printStream);
    }

    public int listElements(PrintStream printStream, boolean bl) {
        int n = 0;
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            ClassNode classNode = (ClassNode)enumeration.nextElement();
            printStream.print(String.valueOf(classNode.thisClass().getName()) + ": ");
            if (bl) {
                classNode.listParents(printStream);
            } else {
                classNode.listChildren(printStream);
            }
            printStream.println();
        }
        return n;
    }

    public int listParents(PrintStream printStream) {
        return this.listElements(printStream, true);
    }
}

