% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VSISR_support.R
\name{psNormal_Deriv}
\alias{psNormal_Deriv}
\title{Derivative for a P-spline fit of scattered (normal)
data.}
\usage{
psNormal_Deriv(
  x,
  y,
  xl = min(x),
  xr = max(x),
  nseg = 10,
  bdeg = 3,
  pord = 2,
  lambda = 1,
  wts = rep(1, length(y)),
  xgrid = x
)
}
\arguments{
\item{x}{the vector for the continuous regressor of \code{length(y)} and the abcissae of fit.}

\item{y}{the response vector, usually continuous data.}

\item{xl}{the number for the min along \code{x} (default is min(\code{x})) .}

\item{xr}{the number for the max along \code{x} (default is max(\code{x})).}

\item{nseg}{the number of evenly spaced segments between \code{xl} and \code{xr}.}

\item{bdeg}{the number of the degree of the basis, usually 1, 2, or 3 (defalult).}

\item{pord}{the number of the order of the difference penalty, usually 1, 2 (defalult), or 3.}

\item{lambda}{the positive tuning parameter (default 1).}

\item{wts}{the vector of weights, default is 1; 0/1 allowed.}

\item{xgrid}{a scalar or a vector that gives the \code{x} locations for prediction, useful for plotting.
If a scalar (default 100) is used then a uniform grid of this size along (\code{xl}, \code{xr}).}
}
\value{
\item{coef}{a vector of \code{length(nsegs + bdeg)}
of estimated P-spline coefficients.}
\item{B}{The B-spline matrix of dimensions \code{m} by \code{length(coef)}.}
\item{fit}{a vector of \code{length(y)} of smooth estimated means (at the \code{x} locations).}
\item{pred}{a vector of \code{length(xgrid)} of (future) predictions.}
\item{d_coef}{a vector of \code{length(nsegs + bdeg - 1)}
of differenced (derivative) estimated P-spline coefficients.}
\item{B_d}{The first derivative B-spline matrix of dimensions \code{m} by \code{lengh(d_coef)}.}
\item{d_fit}{a vector of \code{length(y)} of partial derivative (along \code{x})
of the smooth estimated means (at the \code{x} locations).}
\item{d_pred}{a vector of length \code{lenght(xgrid)} of partial derivative (future) predictions.}
\item{xl}{the number for the min along \code{x} (default is min(\code{x})).}
\item{xr}{the number for the max along \code{x} (default is max(\code{x})).}
\item{nseg}{the number of evenly spaced segments between \code{xl} and \code{xr}.}
\item{bdeg}{the number of the degree of the basis, usually 1, 2, or 3 (default).}
\item{pord}{the number of the order of the difference penalty, usually 1, 2 (default), or 3.}
\item{lambda}{the positive tuning parameter (default 1).}
}
\description{
\code{psNormal_Deriv} provides the derivative
P-spline fit along \code{x}.
}
\details{
This is also a
support function needed for \code{sim_psr} and \code{sim_vcpsr}.
SISR (Eilers, Li, Marx, 2009).
}
\references{
Marx, B. D. (2015). Varying-coefficient single-index signal
regression. \emph{Chemometrics and Intelligent Laboratory Systems}, 143, 111–121.

Eilers, P.H.C., B. Li, B.D. Marx (2009).
Multivariate calibration with single-index signal regression,
\emph{Chemometrics and Intellegent Laboratory Systems}, 96(2), 196-202.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\seealso{
sim_psr sim_vcpsr
}
\author{
Paul Eilers and Brian Marx
}
