/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.JGRPackageManager;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.ibase.Common;

public class JGRPrefs {
    public static final int prefsVersion = 258;
    public static final int DEBUG = 0;
    public static final int MINFONTSIZE = 18;
    public static boolean isMac = false;
    public static boolean isWindows = false;
    public static String FontName = "Monospaced";
    public static int FontStyle = 0;
    public static int FontSize = 12;
    public static Font DefaultFont;
    public static Color HighLightColor;
    public static Color CMDColor;
    public static Color RESULTColor;
    public static Color ERRORColor;
    public static Color BRACKETHighLight;
    public static MutableAttributeSet DEFAULTFONT;
    public static MutableAttributeSet SIZE;
    public static MutableAttributeSet CMD;
    public static MutableAttributeSet RESULT;
    public static MutableAttributeSet NORMAL;
    public static MutableAttributeSet NUMBER;
    public static Color NUMBERColor;
    public static MutableAttributeSet KEYWORD;
    public static Color KEYWORDColor;
    public static boolean KEYWORD_BOLD;
    public static MutableAttributeSet OBJECT;
    public static Color OBJECTColor;
    public static boolean OBJECT_IT;
    public static boolean AUTOTAB;
    public static MutableAttributeSet COMMENT;
    public static Color COMMENTColor;
    public static boolean COMMENT_IT;
    public static MutableAttributeSet QUOTE;
    public static Color QUOTEColor;
    public static boolean LINE_HIGHLIGHT;
    public static Color HIGHLIGHTColor;
    public static boolean LINE_NUMBERS;
    public static int maxHelpTabs;
    public static boolean useHelpAgent;
    public static boolean useHelpAgentEditor;
    public static boolean useHelpAgentConsole;
    public static boolean useEmacsKeyBindings;
    public static boolean showHiddenFiles;
    public static String previousPackages;
    public static String workingDirectory;
    public static String defaultPackages;
    public static boolean askForSavingWorkspace;
    public static int tabWidth;
    public static int consoleWidth;
    public static int consoleHeight;

    public static void apply() {
        JGRPrefs.refresh();
        FontTracker.current.applyFont();
    }

    public static void initialize() {
        FontSize = isWindows ? 10 : 12;
        JGRPrefs.readPrefs();
        DefaultFont = new Font(FontName, FontStyle, FontSize);
        StyleConstants.setFontSize(SIZE, FontSize);
        StyleConstants.setFontSize(DEFAULTFONT, FontSize);
        StyleConstants.setFontFamily(DEFAULTFONT, FontName);
        StyleConstants.setForeground(CMD, CMDColor);
        StyleConstants.setForeground(RESULT, RESULTColor);
        StyleConstants.setForeground(NORMAL, Color.black);
        StyleConstants.setFontSize(NORMAL, FontSize);
        StyleConstants.setForeground(NUMBER, NUMBERColor);
        StyleConstants.setForeground(COMMENT, COMMENTColor);
        StyleConstants.setItalic(COMMENT, COMMENT_IT);
        StyleConstants.setForeground(KEYWORD, KEYWORDColor);
        StyleConstants.setBold(KEYWORD, KEYWORD_BOLD);
        StyleConstants.setForeground(OBJECT, OBJECTColor);
        StyleConstants.setItalic(OBJECT, OBJECT_IT);
        StyleConstants.setForeground(QUOTE, QUOTEColor);
    }

    public static void refresh() {
        DefaultFont = new Font(FontName, FontStyle, FontSize);
        StyleConstants.setFontSize(SIZE, FontSize);
        StyleConstants.setFontSize(DEFAULTFONT, FontSize);
        StyleConstants.setFontFamily(DEFAULTFONT, FontName);
        StyleConstants.setForeground(CMD, CMDColor);
        StyleConstants.setForeground(RESULT, RESULTColor);
        StyleConstants.setForeground(NORMAL, Color.black);
        StyleConstants.setFontSize(NORMAL, FontSize);
        StyleConstants.setForeground(NUMBER, NUMBERColor);
        StyleConstants.setForeground(COMMENT, COMMENTColor);
        StyleConstants.setItalic(COMMENT, COMMENT_IT);
        StyleConstants.setForeground(KEYWORD, KEYWORDColor);
        StyleConstants.setBold(KEYWORD, KEYWORD_BOLD);
        StyleConstants.setForeground(OBJECT, OBJECTColor);
        StyleConstants.setItalic(OBJECT, OBJECT_IT);
        StyleConstants.setForeground(QUOTE, QUOTEColor);
        if (JGR.getREngine() != null && JGR.STARTED) {
            JGR.threadedEval("options(width=" + JGR.MAINRCONSOLE.getFontWidth() + ")");
        }
    }

    public static void readPrefs() {
        Preferences editPrefs;
        BufferedInputStream is;
        block17: {
            Preferences prefs2;
            block16: {
                is = null;
                try {
                    is = new BufferedInputStream(new FileInputStream(System.getProperty("user.home") + File.separator + ".JGRprefsrc"));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                try {
                    if (is == null) break block16;
                    prefs2 = Preferences.userNodeForPackage(JGR.class);
                    try {
                        prefs2.clear();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    prefs2 = null;
                    Preferences.importPreferences(is);
                }
                catch (InvalidPreferencesFormatException prefs2) {
                }
                catch (IOException prefs2) {
                    // empty catch block
                }
            }
            if (is == null) {
                return;
            }
            prefs2 = Preferences.userNodeForPackage(JGR.class);
            FontName = prefs2.get("FontName", FontName);
            defaultPackages = prefs2.get("DefaultPackages", null);
            FontSize = prefs2.getInt("FontSize", FontSize);
            int screenRes = Toolkit.getDefaultToolkit().getScreenResolution();
            double fs = (double)prefs2.getInt("FontSize", FontSize) * ((double)screenRes / 72.0);
            FontSize = (int)Math.round(fs);
            maxHelpTabs = prefs2.getInt("MaxHelpTabs", maxHelpTabs);
            useHelpAgent = prefs2.getBoolean("UseHelpAgent", true);
            useHelpAgentConsole = prefs2.getBoolean("UseHelpAgentConsole", useHelpAgentConsole);
            useHelpAgentEditor = prefs2.getBoolean("UseHelpAgentEditor", useHelpAgentEditor);
            useEmacsKeyBindings = prefs2.getBoolean("UseEmacsKeyBindings", Common.isMac());
            previousPackages = prefs2.get("PreviousPackages", null);
            showHiddenFiles = prefs2.getBoolean("ShowHiddenFiles", false);
            workingDirectory = prefs2.get("WorkingDirectory", System.getProperty("user.home"));
            tabWidth = prefs2.getInt("tabWidth", 4);
            askForSavingWorkspace = prefs2.getBoolean("AskForSavingWorkspace", true);
            is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(System.getProperty("user.home") + File.separator + ".JGREditorprefsrc"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            try {
                if (is == null) break block17;
                editPrefs = Preferences.userNodeForPackage(Editor.class);
                try {
                    editPrefs.clear();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                editPrefs = null;
                Preferences.importPreferences(is);
            }
            catch (InvalidPreferencesFormatException e) {
                new ErrorMsg(e);
            }
            catch (IOException e) {
                new ErrorMsg(e);
            }
        }
        if (is == null) {
            return;
        }
        editPrefs = Preferences.userNodeForPackage(Editor.class);
        CMDColor = Color.decode(editPrefs.get("CMDColor", "#ff0000"));
        RESULTColor = Color.decode(editPrefs.get("RESULTColor", "#0000ff"));
        ERRORColor = Color.decode(editPrefs.get("ERRORColor", "#ff0000"));
        BRACKETHighLight = Color.decode(editPrefs.get("BRACKETHighLight", "#ffffff"));
        NUMBERColor = Color.decode(editPrefs.get("NUMBERColor", "#ff0000"));
        KEYWORDColor = Color.decode(editPrefs.get("KEYWORDColor", "#00008c"));
        KEYWORD_BOLD = editPrefs.getBoolean("KEYWORD_BOLD", true);
        OBJECTColor = Color.decode(editPrefs.get("OBJECTColor", "#32008c"));
        OBJECT_IT = editPrefs.getBoolean("OBJECT_IT", true);
        AUTOTAB = editPrefs.getBoolean("AUTOTAB", true);
        COMMENTColor = Color.decode(editPrefs.get("COMMENTColor", "#000000"));
        COMMENT_IT = editPrefs.getBoolean("COMMENT_IT", true);
        QUOTEColor = Color.decode(editPrefs.get("QUOTEColor", "#0000ff"));
        LINE_HIGHLIGHT = editPrefs.getBoolean("LINE_HIGHLIGHT", true);
        HIGHLIGHTColor = Color.decode(editPrefs.get("HIGHLIGHTColor", "#e0e0e0"));
        LINE_NUMBERS = editPrefs.getBoolean("LINE_NUMBERS", true);
        consoleWidth = editPrefs.getInt("consoleWidth", 550);
        consoleHeight = editPrefs.getInt("consoleHeight", 700);
    }

    public static void writePrefs() {
        Preferences prefs = Preferences.userNodeForPackage(JGR.class);
        try {
            prefs.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        prefs.putBoolean("AskForSavingWorkspace", askForSavingWorkspace);
        prefs.putInt("PrefsVersion", 258);
        prefs.put("FontName", FontName);
        int screenRes = Toolkit.getDefaultToolkit().getScreenResolution();
        double fs = (double)FontSize * (72.0 / (double)screenRes);
        prefs.putInt("FontSize", (int)Math.round(fs));
        prefs.putInt("MaxHelpTabs", maxHelpTabs);
        prefs.putBoolean("UseHelpAgent", useHelpAgent);
        prefs.putBoolean("UseHelpAgentConsole", useHelpAgentConsole);
        prefs.putBoolean("UseHelpAgentEditor", useHelpAgentEditor);
        prefs.putBoolean("UseEmacsKeyBindings", useEmacsKeyBindings);
        prefs.putBoolean("ShowHiddenFiles", showHiddenFiles);
        String tmp = RController.getCurrentPackages();
        prefs.put("PreviousPackages", tmp.substring(0, Math.min(tmp.length(), 8182)) + (JGRPackageManager.remindPackages == null ? "" : "," + JGRPackageManager.remindPackages));
        prefs.put("WorkingDirectory", workingDirectory);
        prefs.putInt("tabWidth", tabWidth);
        if (JGRPackageManager.defaultPackages != null && JGRPackageManager.defaultPackages.length > 0) {
            String packages = JGRPackageManager.defaultPackages[JGRPackageManager.defaultPackages.length - 1].toString();
            for (int i = JGRPackageManager.defaultPackages.length - 2; i >= 0; --i) {
                String pkg = (String)JGRPackageManager.defaultPackages[i];
                if ("JGR".equals(pkg) || "rJava".equals(pkg) || "JavaGD".equals(pkg) || "iplots".equals(pkg)) continue;
                packages = packages + ", " + pkg;
            }
            prefs.put("DefaultPackages", packages);
        }
        try {
            prefs.exportNode(new FileOutputStream(System.getProperty("user.home") + File.separator + ".JGRprefsrc"));
        }
        catch (IOException packages) {
        }
        catch (BackingStoreException packages) {
            // empty catch block
        }
        Preferences editPrefs = Preferences.userNodeForPackage(Editor.class);
        try {
            editPrefs.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        editPrefs.putInt("PrefsVersion", 258);
        editPrefs.put("CMDColor", "#" + Integer.toHexString(CMDColor.getRGB()).substring(2));
        editPrefs.put("RESULTColor", "#" + Integer.toHexString(RESULTColor.getRGB()).substring(2));
        editPrefs.put("ERRORColor", "#" + Integer.toHexString(ERRORColor.getRGB()).substring(2));
        editPrefs.put("BRACKETHighLight", "#" + Integer.toHexString(BRACKETHighLight.getRGB()).substring(2));
        editPrefs.put("NUMBERColor", "#" + Integer.toHexString(NUMBERColor.getRGB()).substring(2));
        editPrefs.put("KEYWORDColor", "#" + Integer.toHexString(KEYWORDColor.getRGB()).substring(2));
        editPrefs.putBoolean("KEYWORD_BOLD", KEYWORD_BOLD);
        editPrefs.put("OBJECTColor", "#" + Integer.toHexString(OBJECTColor.getRGB()).substring(2));
        editPrefs.putBoolean("OBJECT_IT", OBJECT_IT);
        editPrefs.putBoolean("AUTOTAB", AUTOTAB);
        editPrefs.put("COMMENTColor", "#" + Integer.toHexString(COMMENTColor.getRGB()).substring(2));
        editPrefs.putBoolean("COMMENT_IT", COMMENT_IT);
        editPrefs.put("QUOTEColor", "#" + Integer.toHexString(QUOTEColor.getRGB()).substring(2));
        editPrefs.putBoolean("LINE_HIGHLIGHT", LINE_HIGHLIGHT);
        editPrefs.put("HIGHLIGHTColor", "#" + Integer.toHexString(HIGHLIGHTColor.getRGB()).substring(2));
        editPrefs.putBoolean("LINE_NUMBERS", LINE_NUMBERS);
        editPrefs.putInt("consoleWidth", JGR.MAINRCONSOLE.getWidth());
        editPrefs.putInt("consoleHeight", JGR.MAINRCONSOLE.getHeight());
        try {
            editPrefs.exportNode(new FileOutputStream(System.getProperty("user.home") + File.separator + ".JGREditorprefsrc"));
        }
        catch (IOException iOException) {
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static void writeCurrentPackagesWhenExit() {
        JGRPrefs.readPrefs();
        JGRPrefs.writePrefs();
    }

    static {
        HighLightColor = Color.green;
        CMDColor = Color.red;
        RESULTColor = Color.black;
        ERRORColor = Color.red;
        BRACKETHighLight = new Color(200, 255, 255);
        DEFAULTFONT = new SimpleAttributeSet();
        SIZE = new SimpleAttributeSet();
        CMD = new SimpleAttributeSet();
        RESULT = new SimpleAttributeSet();
        NORMAL = new SimpleAttributeSet();
        NUMBER = new SimpleAttributeSet();
        NUMBERColor = Color.red;
        KEYWORD = new SimpleAttributeSet();
        KEYWORDColor = new Color(0, 0, 140);
        KEYWORD_BOLD = true;
        OBJECT = new SimpleAttributeSet();
        OBJECTColor = new Color(50, 0, 140);
        OBJECT_IT = true;
        AUTOTAB = true;
        COMMENT = new SimpleAttributeSet();
        COMMENTColor = new Color(0, 120, 0);
        COMMENT_IT = true;
        QUOTE = new SimpleAttributeSet();
        QUOTEColor = Color.blue;
        LINE_HIGHLIGHT = true;
        HIGHLIGHTColor = new Color(0xE0E0E0);
        LINE_NUMBERS = true;
        maxHelpTabs = 10;
        useHelpAgent = true;
        useHelpAgentEditor = true;
        useHelpAgentConsole = true;
        useEmacsKeyBindings = false;
        showHiddenFiles = false;
        previousPackages = null;
        workingDirectory = System.getProperty("user.home");
        defaultPackages = null;
        askForSavingWorkspace = true;
        tabWidth = 4;
        consoleWidth = 550;
        consoleHeight = 700;
    }
}

