% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_Pcheck.R
\name{pCheck}
\alias{pCheck}
\title{pCheck}
\usage{
pCheck(stats, alpha = 0.05, criticalDif = 0.02, add = TRUE, warnings = TRUE)
}
\arguments{
\item{stats}{Data frame. A data frame object of standard stats that was created by get.stats() or standardStats()}

\item{alpha}{Numeric. Set the alpha level of tests.}

\item{criticalDif}{Numeric. Defines the absolute threshold of absolute differences in extracted and recalculated p-value to be labeled as inconsistency.}

\item{add}{Logical. If TRUE the result of Pcheck are added to the input data frame.}

\item{warnings}{Logical. If FALSE warning messages are omitted.}
}
\value{
A data frame with error report on each entry in the result of a standard stats data frame.
}
\description{
Wrapper function for a standardStats data frame to check extracted and recalculated p-value for consistency
}
\examples{
## Extract and check results from plain text input with get.stats(x,checkP=TRUE)
get.stats("some text with consistent or inconsistent statistical results: 
t(12)=3.4, p<.05 or t(12)=3.4, p>=.05",checkP=TRUE)
## Check standardStats extracted with get.stats(x)$standardStats
pCheck(get.stats("some text with consistent or inconsistent statistical results: 
t(12)=3.4, p<.05 or t(12)=3.4, p>=.05")$standardStats)
}
