% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/character_standardStats.R
\name{standardStats}
\alias{standardStats}
\title{standardStats}
\source{
A minimal web application that extracts statistical results from single documents with \code{\link[JATSdecoder]{get.stats}} is hosted at: \href{https://www.get-stats.app}{https://www.get-stats.app/}

Statistical results extracted with \code{\link[JATSdecoder]{get.stats}} can be analyzed and used to identify articles stored in the PubMed Central library at: \href{https://www.scianalyzer.com}{https://www.scianalyzer.com/}.
}
\usage{
standardStats(
  x,
  stats.mode = "all",
  recalculate.p = TRUE,
  alternative = "undirected",
  estimateZ = FALSE,
  T2t = FALSE,
  R2r = FALSE,
  select = NULL,
  rm.na.col = TRUE
)
}
\arguments{
\item{x}{result vector by \code{\link[JATSdecoder]{allStats}} or chracter vector with a statistical test result per cell, e.g. c("t(12)=1.2, p>.05","chi2(2)=12.7, p<.05")}

\item{stats.mode}{Select subset of standard stats. One of: c("all", "checkable", "computable", "uncomputable").}

\item{recalculate.p}{Logical. If TRUE recalculates p values (for 2 sided test) if possible.}

\item{alternative}{Character. Select sidedness of recomputed p-values from t-, r- and beta-values. One of c("undirected", "directed", "both").}

\item{estimateZ}{Logical. If TRUE detected beta-/d-value is divided by reported standard error "SE" to estimate Z-value ("Zest") for observed beta/d and recompute p-value. Note: This is only valid, if Gauss-Marcov assumptions are met and a sufficiently large sample size is used. If a Z- or t-value is detected in a report of a beta-/d-coefficient with SE, no estimation will be performed, although set to TRUE.}

\item{T2t}{Logical. If TRUE capital letter T is treated as t-statistic.}

\item{R2r}{Logical. If TRUE capital letter R is treated as correlation.}

\item{select}{Select specific standard statistics only (e.g.: c("t", "F", "Chi2")).}

\item{rm.na.col}{Logical. If TRUE removes all columns with only NA.}
}
\value{
Matrix with recognized statistical standard results and recalculated p-values. Empty, if no result is detected.
}
\description{
Extracts and restructures statistical standard results like Z, t, Cohen's d, F, eta^2, r, R^2, chi^2, BF_10, Q, U, H, OR, RR, beta values into a matrix. Performs a recomputation of two- and one-sided p-values if possible. This function is implemented in \code{\link[JATSdecoder]{get.stats}} which returns the results of \code{\link[JATSdecoder]{allStats}} and \code{\link[JATSdecoder]{standardStats}}. Besides only plain textual input, \code{\link[JATSdecoder]{get.stats}} enables direct processing of different file formats (NISO-JATS coded XML, DOCX, HTML) without text preprocessing.
}
\examples{
x<-c("t(38.8)<=>1.96, p<=>.002","F(2,39)<=>4, p<=>.05",
"U(2)=200, p>.25","Z=2.1, F(20.8,22.6)=200, p<.005, 
BF(01)>4","chi=3.2, r(34)=-.7, p<.01, R2=76\%.")
standardStats(x)
}
\references{
Böschen (2021). "Evaluation of JATSdecoder as an automated text extraction tool for statistical results in scientific reports.” \emph{Scientific Reports.} doi: \href{https://www.nature.com/articles/s41598-021-98782-3}{10.1038/s41598-021-98782-3}.
}
\seealso{
\code{\link[JATSdecoder]{study.character}} for extracting multiple study characteristics at once.

\code{\link[JATSdecoder]{get.stats}} for extracting statistical results from textual input and different file formats.
}
