% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_issues.R
\name{contains}
\alias{contains}
\alias{contains.IssueTB}
\alias{contains.IssuesTB}
\alias{contains.default}
\title{Does the issue(s) contains this text?}
\usage{
contains(x, ...)

\method{contains}{IssueTB}(
  x,
  values,
  fields = c("body", "title", "labels", "milestone"),
  values_logic_gate = c("AND", "OR"),
  fields_logic_gate = c("OR", "AND"),
  negate = FALSE,
  ...
)

\method{contains}{IssuesTB}(x, values, ...)

\method{contains}{default}(x, ...)
}
\arguments{
\item{x}{a \code{IssueTB} or \code{IssuesTB} object.}

\item{\dots}{Arguments passed on to \code{\link[IssueTrackeR]{vgrepl}} and
therefore to \code{\link[base]{grepl}}}

\item{values}{a vector \code{string}. Patterns to look for in the outcome.}

\item{fields}{a vector \code{string}. The different fields of the issue in
which to search for the pattern (among \code{"title"}, \code{"body"},
\code{"labels"} and \code{"milestone"}).}

\item{values_logic_gate}{the logic operator which will aggregate the
different assertion related to values: \code{"OR"} or \code{"AND"} (by
default).}

\item{fields_logic_gate}{the logic operator which will aggregate the
different assertion related to fields: \code{"OR"} (by default) or
\code{"AND"}.}

\item{negate}{a boolean indicate the negation of the assertion.}
}
\value{
a boolean (of length equals 1 if the class of \code{x} is
\code{IssueTB} and length superior to 1 if \code{x} if of class
\code{IssuesTB}) specifying if the \code{pattern} is contained in the field
\code{field} of the issue.
}
\description{
Check if the issues contains text, values in its title, labels, body and
milestone.
}
\details{
The contains function in R is designed to check if specific fields of GitHub
issues contain certain values, offering a flexible mechanism for constructing
complex assertions. The function operates with two main logical gates:
\code{fields_logic_gate} and \code{values_logic_gate}.

The \code{fields_logic_gate} determines how conditions on multiple fields are
combined (either "OR" or "AND"). This means that the call \code{
contains(x = issue_1,
         fields = c("body", "title"),
         values = "README",
         fields_logic_gate = "OR")
} will say whether the issue \code{issue_1} contains the string
\code{"README"} in its title OR in its body.

The \code{values_logic_gate} specifies how conditions on multiple values are
combined within each field (either "OR" or "AND"). For example the call
\preformatted{
contains(x = issue_1,
         fields = "body",
         values = c("README", "package"),
         values_logic_gate = "OR")
} will say whether the issue \code{issue_1} contains the string
\code{"README"} OR \code{"package"} in its body. Whereas the call
\preformatted{
contains(x = issue_1,
         fields = "title",
         values = c("README", "package"),
         values_logic_gate = "AND")
} will say whether the issue \code{issue_1} contains the string
\code{"README"} AND \code{"package"} in its body.

The function can also negate the condition using the \code{negate} argument,
effectively allowing users to negate an assertion.

The following example:
\preformatted{
contains(
    x = all_issues,
    fields = "labels",
    values = c("unknown", "medium"),
    values_logic_gate = "OR",
    negate = TRUE,
    fields_logic_gate = "AND"
)
}  designates issues that contain neither "unknown" nor "medium" in their
label.

Note that in the last example, the \code{fields_logic_gate} argument has no
importance and is not taken into account because there is only one field on
which to filter. In the same way, if the \code{values} argument contains only
one element, the \code{values_logic_gate} argument has no importance and is
not taken into account.

This function is not case-sensitive.
}
\section{How assertions with multiple values and multiple fields are built}{


For the order of logical assertions, as it is easy to add assertions linked
by an AND (by piping a new filter_issues), it has been decided that
assertions containing AND gates will be distributed and assertions containing
OR gates will be factorised. The assertions used by \code{filter_issues} will
therefore have the following format:
\eqn{(P1 AND Q1) OR (P2 AND Q2)}

Thus the following call to filter_issue:
\preformatted{
filter_issues(
    ...,
    values = c("v1", "v2"), fields = c("f1", "f2"),
    values_logic_gate = "AND", fields_logic_gate = "OR",
    ...
)
}
will be represented by the following logical proposition:
\eqn{(v1 in f1 AND v2 in f1) OR (v1 in f2 AND v2 in f2)}.

This makes it possible to create more complex logical forms by combining AND
gates and OR gates.
}

\section{Short names}{

\itemize{
\item \code{fields = "b"} for \code{"body"};
\item \code{fields = "t"} for \code{"title"};
\item \code{fields = "l"} for \code{"labels"};
\item \code{fields = "m"} for \code{"milestone"}.
}
}

\examples{

\donttest{
all_issues <- get_issues(source = "online", verbose = FALSE)
issue_1 <- all_issues[[1L]]
# This will return TRUE if the issue contains either "README" or "package"
# in its body.
contains(x = issue_1,
         fields = "body",
         values = c("README", "package"),
         values_logic_gate = "OR")
# This will return TRUE if the issue contains "README" in its body AND its
# title.
contains(x = issue_1,
         values = "README",
         fields = c("body", "title"),
         fields_logic_gate = "AND")
}

}
