% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{evolution}
\alias{evolution}
\title{Th-U evolution diagram}
\usage{
evolution(
  x,
  xlim = NULL,
  ylim = NULL,
  alpha = 0.05,
  transform = FALSE,
  detritus = 0,
  show.numbers = FALSE,
  levels = NA,
  clabel = "",
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  line.col = "darksalmon",
  isochron = FALSE,
  model = 1,
  exterr = TRUE,
  sigdig = 2,
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  ...
)
}
\arguments{
\item{x}{an object of class \code{ThU}}

\item{xlim}{x-axis limits}

\item{ylim}{y-axis limits}

\item{alpha}{probability cutoff for the error ellipses and
confidence intervals}

\item{transform}{if \code{TRUE}, plots \eqn{^{234}}U/\eqn{^{238}}U
vs. Th-U age.}

\item{detritus}{detrital \eqn{^{230}}Th correction (only applicable
    when \code{x$format} is \code{2} or \code{3}.

\code{0}: no correction

\code{1}: project the data along an isochron fit

\code{2}: correct the data using an assumed initial
\eqn{^{230}}Th/\eqn{^{232}}Th-ratio for the detritus.

\code{3}: correct the data using the measured present day
\eqn{^{230}}Th/\eqn{^{238}}U, \eqn{^{232}}Th/\eqn{^{238}}U and
\eqn{^{234}}U/\eqn{^{238}}U-ratios in the detritus.}

\item{show.numbers}{label the error ellipses with the grain
numbers?}

\item{levels}{a vector with additional values to be displayed as
different background colours within the error ellipses.}

\item{clabel}{label of the colour legend.}

\item{ellipse.fill}{Fill colour for the error ellipses. This can either be a single
colour or multiple colours to form a colour ramp. Examples:

a single colour: \code{rgb(0,1,0,0.5)}, \code{'#FF000080'},
\code{'white'}, etc.;

multiple colours: \code{c(rbg(1,0,0,0.5)},
\code{rgb(0,1,0,0.5))}, \code{c('#FF000080','#00FF0080')},
\code{c('blue','red')}, \code{c('blue','yellow','red')}, etc.;

a colour palette: \code{rainbow(n=100)},
\code{topo.colors(n=100,alpha=0.5)}, etc.; or

a reversed palette: \code{rev(topo.colors(n=100,alpha=0.5))},
etc.

For empty ellipses, set \code{ellipse.fill=NA}}

\item{ellipse.stroke}{the stroke colour for the error
ellipses. Follows the same formatting guidelines as
\code{ellipse.fill}}

\item{line.col}{colour of the age grid}

\item{isochron}{fit a 3D isochron to the data?}

\item{model}{if \code{isochron=TRUE}, choose one of three
    regression models:

\code{1}: maximum likelihood regression, using either the modified
error weighted least squares algorithm of York et al. (2004) for
2-dimensional data, or the Maximum Likelihood formulation of Ludwig
and Titterington (1994) for 3-dimensional data. These algorithms
take into account the analytical uncertainties and error
correlations, under the assumption that the scatter between the
data points is solely caused by the analytical uncertainty. If this
assumption is correct, then the MSWD value should be approximately
equal to one. There are three strategies to deal with the case
where MSWD>1. The first of these is to assume that the analytical
uncertainties have been underestipmated by a factor
\eqn{\sqrt{MSWD}}.

\code{2}: ordinary least squares regression: a second way to deal
with over- or underdispersed datasets is to simply ignore the
analytical uncertainties.

\code{3}: maximum likelihood regression with overdispersion:
instead of attributing any overdispersion (MSWD > 1) to
underestimated analytical uncertainties (model 1), one can also
attribute it to the presence of geological uncertainty, which
manifests itself as an added (co)variance term.}

\item{exterr}{propagate the decay constant uncertainty in the
isochron age?}

\item{sigdig}{number of significant digits for the isochron age}

\item{hide}{vector with indices of aliquots that should be removed
from the plot.}

\item{omit}{vector with indices of aliquots that should be plotted
but omitted from the isochron age calculation.}

\item{omit.fill}{fill colour that should be used for the omitted
aliquots.}

\item{omit.stroke}{stroke colour that should be used for the omitted
aliquots.}

\item{...}{optional arguments to the generic \code{plot} function}
}
\description{
Plots Th-U data on a
\eqn{^{234}}U/\eqn{^{238}}U-\eqn{^{230}}Th/\eqn{^{238}}U evolution
diagram, a \eqn{^{234}}U/\eqn{^{238}}U-age diagram, or (if
\eqn{^{234}}U/\eqn{^{238}}U is assumed to be in secular
equilibrium), a
\eqn{^{230}}Th/\eqn{^{232}}Th-\eqn{^{238}}U/\eqn{^{232}}Th diagram,
calculates isochron ages.
}
\details{
Similar to the \code{\link{concordia}} diagram (for U-Pb data) and
the \code{\link{helioplot}} diagram (for U-Th-He data), the
evolution diagram simultaneously displays the isotopic composition
and age of U-series data. For carbonate data (Th-U formats 1 and
2), the Th-U evolution diagram consists of a scatter plot that sets
out the \eqn{^{234}}U/\eqn{^{238}}U-activity ratios against the
\eqn{^{230}}Th/\eqn{^{238}}U-activity ratios as error ellipses, and
displays the initial \eqn{^{234}}U/\eqn{^{238}}U-activity ratios
and ages as a set of intersecting lines.  Alternatively, the
\eqn{^{234}}U/\eqn{^{238}}U-ratios can also be set out against the
\eqn{^{230}}Th-\eqn{^{234}}U-\eqn{^{238}}U-ages.  In both types of
evolution diagrams, \code{IsoplotR} provides the option to project
the raw measurements along the best fitting isochron line and
thereby remove the detrital \eqn{^{230}}Th-component. This
procedure allows a visual assessment of the degree of homogeneity
within a dataset, as is quantified by the MSWD.

Neither the U-series evolution diagram, nor the
\eqn{^{234}}U/\eqn{^{238}}U vs. age plot is applicable to igneous
datasets (Th-U formats 3 and 4), in which \eqn{^{234}}U and
\eqn{^{238}}U are in secular equilibrium.  For such datasets,
\code{IsoplotR} produces an Osmond-style regression plot that is
decorated with a fanning set of \code{\link{isochron}} lines.
}
\examples{
attach(examples)
evolution(ThU)

dev.new()
evolution(ThU,transform=TRUE,
          isochron=TRUE,model=1)

}
\references{
Ludwig, K.R. and Titterington, D.M., 1994. Calculation
    of \eqn{^{230}}Th/U isochrons, ages, and errors. Geochimica et
    Cosmochimica Acta, 58(22), pp.5031-5042.

Ludwig, K.R., 2003. Mathematical-statistical treatment of data and
    errors for \eqn{^{230}}Th/U geochronology. Reviews in Mineralogy and
    Geochemistry, 52(1), pp.631-656.
}
\seealso{
\code{\link{isochron}}
}
