% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedmean.R
\name{weightedmean}
\alias{weightedmean}
\alias{weightedmean.ArAr}
\alias{weightedmean.UPb}
\alias{weightedmean.default}
\title{Calculate the weighted mean age}
\usage{
weightedmean(x, ...)

\method{weightedmean}{default}(x, detect.outliers = TRUE, plot = TRUE,
  rect.col = rgb(0, 1, 0, 0.5), outlier.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, alpha = 0.05, ...)

\method{weightedmean}{UPb}(x, detect.outliers = TRUE, plot = TRUE,
  rect.col = rgb(0, 1, 0, 0.5), outlier.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, type = 4, cutoff.76 = 1100, cutoff.disc = c(-15, 5),
  alpha = 0.05, dcu = TRUE, ...)

\method{weightedmean}{ArAr}(x, detect.outliers = TRUE, plot = TRUE,
  rect.col = rgb(0, 1, 0, 0.5), outlier.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, alpha = 0.05, dcu = TRUE, ...)
}
\arguments{
\item{x}{a two column matrix of values (first column) and their
standard errors (second column) OR an object of class
\code{UPb} OR an object of class \code{ArAr}}

\item{...}{optional arguments}

\item{detect.outliers}{Boolean flag indicating whether outliers
should be detected and rejected using Chauvenet's Criterion.}

\item{plot}{Boolean flag indicating whether the function should
produce graphical output or return numerical values to the
user.}

\item{rect.col}{the fill colour of the rectangles used to show the
measurements or age estimates.}

\item{outlier.col}{if \code{detect.outliers=TRUE}, the outliers are
given a different colour.}

\item{sigdig}{the number of significant digits of the numerical
values reported in the title of the graphical output.}

\item{alpha}{the confidence limits of the error bars/rectangles.}

\item{type}{scalar indicating whether to plot the
\eqn{^{207}}Pb/\eqn{^{235}}U age (type=1), the
\eqn{^{206}}Pb/\eqn{^{238}}U age (type=2), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age (type=3), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb-\eqn{^{206}}Pb/\eqn{^{238}}U age
(type=4), or the (Wetherill) concordia age (type=5)}

\item{cutoff.76}{the age (in Ma) below which the
\eqn{^{206}}Pb/\eqn{^{238}}U and above which the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age is used. This parameter is
only used if \code{type=4}.}

\item{cutoff.disc}{two element vector with the maximum and minimum
percentage discordance allowed between the
\eqn{^{207}}Pb/\eqn{^{235}}U and \eqn{^{206}}Pb/\eqn{^{238}}U
age (if \eqn{^{206}}Pb/\eqn{^{238}}U < cutoff.76) or between
the \eqn{^{206}}Pb/\eqn{^{238}}U and
\eqn{^{207}}Pb/\eqn{^{206}}Pb age (if
\eqn{^{206}}Pb/\eqn{^{238}}U > cutoff.76).  Set
\code{cutoff.disc=NA} if you do not want to use this filter.}

\item{dcu}{propagate decay constant uncertainty?}
}
\value{
if \code{PLOT=FALSE}, returns a list with the follwing items:

\code{mean:} a two element vector with the weighted mean and its
standard error.

\code{disp:} a two element vector with the (over)dispersion and its
standard error.

\code{mswd:} the Mean Square of the Weighted Deviates
(a.k.a. `reduced Chi-square' statistic)

\code{p.value:} the p-value of a Chi-square test with n-1 degrees
of freedom, testing the null hypothesis that the underlying
population is not overdispersed.

\code{valid:} vector of Boolean flags indicating which steps are
included into the weighted mean calculation
}
\description{
Models the data as a Normal distribution with two sources of
variance.  Estimates the mean and 'overdispersion' using the method
of Maximum Likelihood. Computes the MSWD of a Normal fit without
overdispersion. Implements Chauvenet's Criterion to detect and
reject outliers. Only propagates the analytical uncertainty
associated with decay constants and J-factors after computing the
weighted mean isotopic composition.
}
\examples{
ages <- c(251.9,251.59,251.47,251.35,251.1,251.04,250.79,250.73,251.22,228.43)
errs <- c(0.28,0.28,0.63,0.34,0.28,0.63,0.28,0.4,0.28,0.33)
weightedmean(cbind(ages,errs))
#data(examples)
#weightedmean(examples$ArAr)
}

