% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IIWcode.R
\name{Liang}
\alias{Liang}
\title{Fit a semi-parametric joint model}
\usage{
Liang(data, Yname, Xnames, Wnames, id, time, maxfu, baseline)
}
\arguments{
\item{data}{data frame containing the variables in the model}

\item{Yname}{character string indicating the column containing the outcome variable}

\item{Xnames}{vector of character strings indicating the names of the columns of the fixed effects in the outcome regression model}

\item{Wnames}{vector of character strings indicating the names of the columns of the random effects in the outcome regression model}

\item{id}{character string indicating which column of the data identifies subjects}

\item{time}{character string indicating which column of the data contains the time at which the visit occurred}

\item{maxfu}{The maximum follow-up time per subject. If all subjects have the same follow-up time, this can be supplied as a single number. Otherwise, maxfu should be a dataframe with the first column specifying subject identifiers and the second giving the follow-up time for each subject.}

\item{baseline}{An indicator for whether baseline (time=0) measurements are included by design. Equal to 1 if yes, 0 if no.}
}
\value{
the regression coefficients corresponding to the fixed effects in the outcome regression model.  Closed form expressions for standard errors of the regression coefficients are not available, and Liang et al (2009) recommend obtaining these through bootstrapping.
}
\description{
Fits a semi-parametric joint model as described by Liang et al. (2009).
}
\details{
This function is designed to be used in conjunction with multiple outputation and hence assumes no fixed effects in the visit process model. The visit process model thus contains a baseline hazard and a random effect only.
}
\references{
Liang Y, Lu W, Ying Z. Joint modelling and analysis of longitudinal data with informative observation times. Biometrics 2009; 65:377-384.
}
