% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{intersected}
\alias{intersected}
\title{Determine whether each interval in a given set are intersected by any in another set}
\usage{
intersected(x, by_intervals)
}
\arguments{
\item{x}{Integer matrix of two columns, the first column giving the (inclusive) start points of intervals and the second column giving the corresponding (exclusive) end points, or, an integer vector specifying the location of points.}

\item{by_intervals}{Matrix specifying intervals to test for intersection of.}
}
\value{
Logical vector with elements corresponding to rows of \code{x}.
}
\description{
Compute a logical vector indicating whether corresponding intervals specified by \code{x} overlap any in \code{by_intervals}.
}
\examples{
intersected(rbind(c(1, 2), c(49, 51), c(50, 200)), rbind(c(50, 100)))
}
