% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{depth}
\alias{depth}
\title{Depth of piled intervals}
\usage{
depth(x, include_intervals = FALSE)
}
\arguments{
\item{x}{Integer matrix of two columns, the first column giving the (inclusive) start points of intervals and the second column giving the corresponding (exclusive) end points.}

\item{include_intervals}{Logical value determining whether the function should return a vector of depths at each `section' in the range of \code{x} (see \code{\link{sections}}), or a list with properties \code{intervals} and \code{depths} specifying the intervals of the sections and the corresponding depths respectively.}
}
\value{
Integer vector giving depth of piled intervals from \code{x} (within each sub-interval) or list containing a property \code{"intervals"}, a matrix of sections, and property \code{"depths"}, giving the corresponding pile depths.
}
\description{
Get the depth of piled intervals for each section in the sections of \code{x} (see \code{\link{sections}}).
}
\examples{
depth(cbind(1:10, 11:20))
}
