% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-distance.R
\docType{methods}
\name{distance}
\alias{distance}
\alias{distance,IntervalData,IntervalData-method}
\title{Calculate the \eqn{\theta}-distance between two interval-valued data}
\usage{
\S4method{distance}{IntervalData,IntervalData}(e1, e2, theta = 1)
}
\arguments{
\item{e1}{an interval-valued data.}

\item{e2}{an interval-valued data.}

\item{theta}{a single positive numeric value. By default \code{theta}=1.}
}
\value{
Returns the calculated \eqn{\theta}-distance, i.e. a single numeric value.
}
\description{
The \eqn{\theta}-distance for two given interval-valued data \eqn{A} and \eqn{B}  was defined by Gil et al. (2002) as follows,
\deqn{d_{\theta}(A,B) = \sqrt{(\mathrm{mid}~A - \mathrm{mid}~B)^2+\theta\cdot(\mathrm{spr}~A -\mathrm{spr}~B)^2},}
where \eqn{\theta} is a positive real number.
}
\examples{
i1 <- IntervalData(0, 1)
i2 <- IntervalData(3, 7)
distance(i1, i2)
distance(i1, i2, 1/3)
}
\references{
Gil, M.A.; Lubiano, M.A.; Montenegro, M.; Lopez, M.T. (2002).
Least squares fitting of an affine function and strength of association for interval-valued data.
Metrika 56:97-111.
}
\seealso{
Other IntervalData-method: 
\code{\link{IntervalData-class}},
\code{\link{IntervalData}},
\code{\link{arithmetic}},
\code{\link{as.IntervalData}()},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()},
\code{\link{plot}()},
\code{\link{show}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalData-method}
