% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supportingfunctions.R
\name{pop.ct.prop.scRNA}
\alias{pop.ct.prop.scRNA}
\title{Calculate the population-level cell type proportions from a single-cell data.}
\usage{
pop.ct.prop.scRNA(scRNA,cluster="cluster",sample="sample",cell_type_unique)
}
\arguments{
\item{scRNA}{The `ExpressionSet` object for single-cell data.}

\item{cluster}{The character string specifying the variable name for cell types. The default is "cluster".}

\item{sample}{The character string specifying the variable name for subject/samples. The default is "sample".}

\item{cell_type_unique}{A vector of cell types. It should match the order in list.marker.}
}
\value{
The population-level cell type proportions (`pop.ct.prop`) and corresponding standard deviations (`pop.ct.sd`).
}
\description{
Calculate population-level cell type proportions from single-cell data.
}
\examples{
##read data
library(InteRD)
readRDSFromWeb<-function(ref) {readRDS(gzcon(url(ref)))}
urlremote<-"https://github.com/chencxxy28/Data/raw/main/data_InteRD/"
seger<-readRDSFromWeb(paste0(urlremote,"segerstolpe.rds"))
cell_type_unique<-c("alpha","beta","delta","gamma")
ave_est<-pop.ct.prop.scRNA(scRNA=seger[["sc.eset.qc"]],
cell_type_unique=cell_type_unique)$pop.ct.prop
ave_est

}
