% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{CharacteristicFeatures}
\alias{CharacteristicFeatures}
\title{Determining the characteristic features of a cluster}
\usage{
CharacteristicFeatures(List, Selection = NULL, binData = NULL,
  contData = NULL, datanames = NULL, nrclusters = NULL, sign = 0.05,
  topChar = NULL, fusionsLog = TRUE, weightclust = TRUE, names = NULL)
}
\arguments{
\item{List}{A list of the clustering outputs to be compared. The first
element of the list will be used as the reference in
\code{ReorderToReference}.}

\item{Selection}{If differential gene expression should be investigated for
a specific selection of objects, this selection can be provided here.
Selection can be of the type "character" (names of the objects) or
"numeric" (the number of specific cluster). Default is NULL.}

\item{binData}{A list of the binary feature data matrices. These will be
evaluated with the fisher's extact test. Default is NULL.}

\item{contData}{A list of continuous data sets of the objects. These will
be evaluated with the t-test. Default is NULL.}

\item{datanames}{A vector with the names of the data matrices. Default is NULL.}

\item{nrclusters}{Optional. The number of clusters to cut the dendrogram in.
The number of clusters should not be specified if the interest lies only in
a specific selection of objects which is known by name.  Otherwise, it is
required. Default is NULL.}

\item{sign}{The significance level to be handled. Default is 0.05.}

\item{topChar}{Overrules sign. The number of features to display for each
cluster.  If not specified, only the significant genes are shown. Default is NULL.}

\item{fusionsLog}{Logical. To be handed to \code{ReorderToReference}: indicator for the fusion of clusters. Default is TRUE}

\item{weightclust}{Logical. To be handed to \code{ReorderToReference}: to be used for the outputs of CEC,
WeightedClust or WeightedSimClust. If TRUE, only the result of the Clust element is considered. Default is TRUE.}

\item{names}{Optional. Names of the methods. Default is NULL.}
}
\value{
The returned value is a list with an element per method. Each
element contains a list per cluster with the following elements:
\item{objects}{A list with the elements LeadCpds (the objects of
interest) and OrderedCpds (all objects in the order of the clustering
result)} \item{Characteristics}{A list with an element per defined binary
data matrix in BinData and continuous data in ContData. Each element is
again a list with the elements TopFeat (a table with information on the top
features) and AllFeat (a table with information on all features)}
}
\description{
The function \code{CharacteristicFeatures} requires as input a list of one
or multiple clustering results. It is capable of selecting the binary
features which determine a cluster with the help of the fisher's exact test.
}
\details{
The function rearranges the clusters of the methods to a reference method
such that a comparison is made easier.  Given a list of methods, it calls
upon \code{ReorderToReference} to rearrange the number of clusters according
to the first element of the list which will be used as the reference.
}
\examples{

\dontrun{
data(fingerprintMat)
data(targetMat)
data(geneMat)

MCF7_F = Cluster(fingerprintMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)
MCF7_T = Cluster(targetMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)

L=list(MCF7_T ,MCF7_F)

MCF7_Char=CharacteristicFeatures(List=L,Selection=NULL,BinData=list(fingerprintMat,
targetMat),datanames=c("FP","TP"),nrclusters=7,topC=NULL,sign=0.05,fusionsLog=TRUE,
weightclust=TRUE,names=c("FP","TP"))
}
}
