% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitValues.R
\name{unitValues}
\alias{unitValues}
\title{Aggregates prices to unit values and quantities to sums}
\usage{
unitValues(x, pvar, qvar, pervar, prodID)
}
\arguments{
\item{x}{A dataframe containing price, quantity, a time period identifier
and a product identifier. It must have column names.}

\item{pvar}{A character string for the name of the price variable}

\item{qvar}{A character string for the name of the quantity variable}

\item{pervar}{character string for the name of the time variable. This variable
must contain integers starting at period 1 and increasing in increments of 1 period.
There may be observations on multiple products for each time period.}

\item{prodID}{A character string for the name of the product identifier}
}
\value{
A dataframe containing columns for product identifier, time period,
quantities, and unit values.
}
\description{
A function to aggregate price and quantity data to unit values
}
\examples{
# suppose the CES_sigma_2 dataset contains 12 monthly observations
# and suppose we want quarterly unit values.
df <- CES_sigma_2
# convert the monthly time variable into quarterly
df$time <- ceiling(CES_sigma_2$time/3)
# compute unit values using the quarterly time variable
unitValues(df,pvar="prices",qvar="quantities",pervar="time",prodID="prodID")
}
