/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.PersistentObject;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseRCIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;

public class IntFactory2D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final IntFactory2D dense = new IntFactory2D();
    public static final IntFactory2D sparse = new IntFactory2D();
    public static final IntFactory2D rowCompressed = new IntFactory2D();

    protected IntFactory2D() {
    }

    public IntMatrix2D appendColumns(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2) {
        if (intMatrix2D2.rows() > intMatrix2D.rows()) {
            intMatrix2D2 = intMatrix2D2.viewPart(0, 0, intMatrix2D.rows(), intMatrix2D2.columns());
        } else if (intMatrix2D2.rows() < intMatrix2D.rows()) {
            intMatrix2D = intMatrix2D.viewPart(0, 0, intMatrix2D2.rows(), intMatrix2D.columns());
        }
        int n = intMatrix2D.columns();
        int n2 = intMatrix2D2.columns();
        int n3 = intMatrix2D.rows();
        IntMatrix2D intMatrix2D3 = this.make(n3, n + n2);
        intMatrix2D3.viewPart(0, 0, n3, n).assign(intMatrix2D);
        intMatrix2D3.viewPart(0, n, n3, n2).assign(intMatrix2D2);
        return intMatrix2D3;
    }

    public IntMatrix2D appendColumn(IntMatrix2D intMatrix2D, IntMatrix1D intMatrix1D) {
        if (intMatrix1D.size() > (long)intMatrix2D.rows()) {
            intMatrix1D = intMatrix1D.viewPart(0, intMatrix2D.rows());
        } else if (intMatrix1D.size() < (long)intMatrix2D.rows()) {
            intMatrix2D = intMatrix2D.viewPart(0, 0, (int)intMatrix1D.size(), intMatrix2D.columns());
        }
        int n = intMatrix2D.columns();
        int n2 = 1;
        int n3 = intMatrix2D.rows();
        IntMatrix2D intMatrix2D2 = this.make(n3, n + n2);
        intMatrix2D2.viewPart(0, 0, n3, n).assign(intMatrix2D);
        intMatrix2D2.viewColumn(n).assign(intMatrix1D);
        return intMatrix2D2;
    }

    public IntMatrix2D appendRows(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2) {
        if (intMatrix2D2.columns() > intMatrix2D.columns()) {
            intMatrix2D2 = intMatrix2D2.viewPart(0, 0, intMatrix2D2.rows(), intMatrix2D.columns());
        } else if (intMatrix2D2.columns() < intMatrix2D.columns()) {
            intMatrix2D = intMatrix2D.viewPart(0, 0, intMatrix2D.rows(), intMatrix2D2.columns());
        }
        int n = intMatrix2D.rows();
        int n2 = intMatrix2D2.rows();
        int n3 = intMatrix2D.columns();
        IntMatrix2D intMatrix2D3 = this.make(n + n2, n3);
        intMatrix2D3.viewPart(0, 0, n, n3).assign(intMatrix2D);
        intMatrix2D3.viewPart(n, 0, n2, n3).assign(intMatrix2D2);
        return intMatrix2D3;
    }

    public IntMatrix2D appendRow(IntMatrix2D intMatrix2D, IntMatrix1D intMatrix1D) {
        if (intMatrix1D.size() > (long)intMatrix2D.columns()) {
            intMatrix1D = intMatrix1D.viewPart(0, intMatrix2D.columns());
        } else if (intMatrix1D.size() < (long)intMatrix2D.columns()) {
            intMatrix2D = intMatrix2D.viewPart(0, 0, intMatrix2D.rows(), (int)intMatrix1D.size());
        }
        int n = intMatrix2D.rows();
        int n2 = 1;
        int n3 = intMatrix2D.columns();
        IntMatrix2D intMatrix2D2 = this.make(n + n2, n3);
        intMatrix2D2.viewPart(0, 0, n, n3).assign(intMatrix2D);
        intMatrix2D2.viewRow(n).assign(intMatrix1D);
        return intMatrix2D2;
    }

    public IntMatrix2D ascending(int n, int n2) {
        IntFunctions intFunctions = IntFunctions.intFunctions;
        return this.descending(n, n2).assign(IntFunctions.chain(IntFunctions.neg, IntFunctions.minus(n2 * n)));
    }

    protected static void checkRectangularShape(int[][] nArray) {
        int n = -1;
        int n2 = nArray.length;
        while (--n2 >= 0) {
            if (nArray[n2] == null) continue;
            if (n == -1) {
                n = nArray[n2].length;
            }
            if (nArray[n2].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected static void checkRectangularShape(IntMatrix2D[][] intMatrix2DArray) {
        int n = -1;
        int n2 = intMatrix2DArray.length;
        while (--n2 >= 0) {
            if (intMatrix2DArray[n2] == null) continue;
            if (n == -1) {
                n = intMatrix2DArray[n2].length;
            }
            if (intMatrix2DArray[n2].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    public IntMatrix2D reshape(IntMatrix1D intMatrix1D, int n, int n2) {
        if (intMatrix1D.size() != (long)(n * n2)) {
            throw new IllegalArgumentException("a.size() != rows*columns");
        }
        IntMatrix2D intMatrix2D = this == sparse ? new SparseIntMatrix2D(n, n2) : new DenseIntMatrix2D(n, n2);
        for (int i = 0; i < n2; ++i) {
            intMatrix2D.viewColumn(i).assign(intMatrix1D.viewPart(i * n, n));
        }
        return intMatrix2D;
    }

    public IntMatrix2D compose(IntMatrix2D[][] intMatrix2DArray) {
        int n;
        int n2;
        int n3;
        IntFactory2D.checkRectangularShape(intMatrix2DArray);
        int n4 = intMatrix2DArray.length;
        int n5 = 0;
        if (intMatrix2DArray.length > 0) {
            n5 = intMatrix2DArray[0].length;
        }
        IntMatrix2D intMatrix2D = this.make(0, 0);
        if (n4 == 0 || n5 == 0) {
            return intMatrix2D;
        }
        int[] nArray = new int[n5];
        int n6 = n5;
        while (--n6 >= 0) {
            n3 = 0;
            n2 = n4;
            while (--n2 >= 0) {
                IntMatrix2D intMatrix2D2 = intMatrix2DArray[n2][n6];
                if (intMatrix2D2 == null) continue;
                int n7 = intMatrix2D2.columns();
                if (n3 > 0 && n7 > 0 && n7 != n3) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n3 = Math.max(n3, n7);
            }
            nArray[n6] = n3;
        }
        int[] nArray2 = new int[n4];
        n3 = n4;
        while (--n3 >= 0) {
            n2 = 0;
            int n8 = n5;
            while (--n8 >= 0) {
                IntMatrix2D intMatrix2D3 = intMatrix2DArray[n3][n8];
                if (intMatrix2D3 == null) continue;
                n = intMatrix2D3.rows();
                if (n2 > 0 && n > 0 && n != n2) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n2 = Math.max(n2, n);
            }
            nArray2[n3] = n2;
        }
        n3 = 0;
        n2 = n4;
        while (--n2 >= 0) {
            n3 += nArray2[n2];
        }
        n2 = 0;
        int n9 = n5;
        while (--n9 >= 0) {
            n2 += nArray[n9];
        }
        IntMatrix2D intMatrix2D4 = this.make(n3, n2);
        int n10 = 0;
        for (n = 0; n < n4; ++n) {
            int n11 = 0;
            for (int i = 0; i < n5; ++i) {
                IntMatrix2D intMatrix2D5 = intMatrix2DArray[n][i];
                if (intMatrix2D5 != null) {
                    intMatrix2D4.viewPart(n10, n11, intMatrix2D5.rows(), intMatrix2D5.columns()).assign(intMatrix2D5);
                }
                n11 += nArray[i];
            }
            n10 += nArray2[n];
        }
        return intMatrix2D4;
    }

    public IntMatrix2D composeDiagonal(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2) {
        int n = intMatrix2D.rows();
        int n2 = intMatrix2D.columns();
        int n3 = intMatrix2D2.rows();
        int n4 = intMatrix2D2.columns();
        IntMatrix2D intMatrix2D3 = this.make(n + n3, n2 + n4);
        intMatrix2D3.viewPart(0, 0, n, n2).assign(intMatrix2D);
        intMatrix2D3.viewPart(n, n2, n3, n4).assign(intMatrix2D2);
        return intMatrix2D3;
    }

    public IntMatrix2D composeDiagonal(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2, IntMatrix2D intMatrix2D3) {
        IntMatrix2D intMatrix2D4 = this.make(intMatrix2D.rows() + intMatrix2D2.rows() + intMatrix2D3.rows(), intMatrix2D.columns() + intMatrix2D2.columns() + intMatrix2D3.columns());
        intMatrix2D4.viewPart(0, 0, intMatrix2D.rows(), intMatrix2D.columns()).assign(intMatrix2D);
        intMatrix2D4.viewPart(intMatrix2D.rows(), intMatrix2D.columns(), intMatrix2D2.rows(), intMatrix2D2.columns()).assign(intMatrix2D2);
        intMatrix2D4.viewPart(intMatrix2D.rows() + intMatrix2D2.rows(), intMatrix2D.columns() + intMatrix2D2.columns(), intMatrix2D3.rows(), intMatrix2D3.columns()).assign(intMatrix2D3);
        return intMatrix2D4;
    }

    public IntMatrix2D composeBidiagonal(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2) {
        int n = intMatrix2D.rows();
        int n2 = intMatrix2D.columns();
        int n3 = intMatrix2D2.rows();
        int n4 = intMatrix2D2.columns();
        IntMatrix2D intMatrix2D3 = this.make(n + n3 - 1, n2 + n4);
        intMatrix2D3.viewPart(0, 0, n, n2).assign(intMatrix2D);
        intMatrix2D3.viewPart(n - 1, n2, n3, n4).assign(intMatrix2D2);
        return intMatrix2D3;
    }

    public void decompose(IntMatrix2D[][] intMatrix2DArray, IntMatrix2D intMatrix2D) {
        int n;
        int n2;
        int n3;
        IntFactory2D.checkRectangularShape(intMatrix2DArray);
        int n4 = intMatrix2DArray.length;
        int n5 = 0;
        if (intMatrix2DArray.length > 0) {
            n5 = intMatrix2DArray[0].length;
        }
        if (n4 == 0 || n5 == 0) {
            return;
        }
        int[] nArray = new int[n5];
        int n6 = n5;
        while (--n6 >= 0) {
            n3 = 0;
            n2 = n4;
            while (--n2 >= 0) {
                IntMatrix2D intMatrix2D2 = intMatrix2DArray[n2][n6];
                if (intMatrix2D2 == null) continue;
                int n7 = intMatrix2D2.columns();
                if (n3 > 0 && n7 > 0 && n7 != n3) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n3 = Math.max(n3, n7);
            }
            nArray[n6] = n3;
        }
        int[] nArray2 = new int[n4];
        n3 = n4;
        while (--n3 >= 0) {
            n2 = 0;
            int n8 = n5;
            while (--n8 >= 0) {
                IntMatrix2D intMatrix2D3 = intMatrix2DArray[n3][n8];
                if (intMatrix2D3 == null) continue;
                n = intMatrix2D3.rows();
                if (n2 > 0 && n > 0 && n != n2) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n2 = Math.max(n2, n);
            }
            nArray2[n3] = n2;
        }
        n3 = 0;
        n2 = n4;
        while (--n2 >= 0) {
            n3 += nArray2[n2];
        }
        n2 = 0;
        int n9 = n5;
        while (--n9 >= 0) {
            n2 += nArray[n9];
        }
        if (intMatrix2D.rows() < n3 || intMatrix2D.columns() < n2) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        n9 = 0;
        for (int i = 0; i < n4; ++i) {
            n = 0;
            for (int j = 0; j < n5; ++j) {
                IntMatrix2D intMatrix2D4 = intMatrix2DArray[i][j];
                if (intMatrix2D4 != null) {
                    intMatrix2D4.assign(intMatrix2D.viewPart(n9, n, intMatrix2D4.rows(), intMatrix2D4.columns()));
                }
                n += nArray[j];
            }
            n9 += nArray2[i];
        }
    }

    public void demo1() {
        System.out.println("\n\n");
        IntMatrix2D[][] intMatrix2DArray = new IntMatrix2D[][]{{null, this.make(2, 2, 1), null}, {this.make(4, 4, 2), null, this.make(4, 3, 3)}, {null, this.make(2, 2, 4), null}};
        System.out.println("\n" + this.compose(intMatrix2DArray));
        IntMatrix2D[][] intMatrix2DArray2 = new IntMatrix2D[][]{{this.identity(3), null}, {null, this.identity(3).viewColumnFlip()}, {this.identity(3).viewRowFlip(), null}};
        System.out.println("\n" + this.compose(intMatrix2DArray2));
        IntMatrix2D intMatrix2D = this.ascending(2, 2);
        IntMatrix2D intMatrix2D2 = this.descending(2, 2);
        Object var5_5 = null;
        IntMatrix2D[][] intMatrix2DArray3 = new IntMatrix2D[][]{{intMatrix2D, var5_5, intMatrix2D, var5_5}, {var5_5, intMatrix2D, var5_5, intMatrix2D2}};
        System.out.println("\n" + this.compose(intMatrix2DArray3));
    }

    public void demo2() {
        System.out.println("\n\n");
        Object var9_1 = null;
        IntMatrix2D intMatrix2D = this.make(2, 2, 1);
        IntMatrix2D intMatrix2D2 = this.make(4, 4, 2);
        IntMatrix2D intMatrix2D3 = this.make(4, 3, 3);
        IntMatrix2D intMatrix2D4 = this.make(2, 2, 4);
        IntMatrix2D[][] intMatrix2DArray = new IntMatrix2D[][]{{var9_1, intMatrix2D, var9_1}, {intMatrix2D2, var9_1, intMatrix2D3}, {var9_1, intMatrix2D4, var9_1}};
        IntMatrix2D intMatrix2D5 = this.compose(intMatrix2DArray);
        System.out.println("\n" + intMatrix2D5);
        intMatrix2D.assign(9);
        intMatrix2D2.assign(9);
        intMatrix2D3.assign(9);
        intMatrix2D4.assign(9);
        this.decompose(intMatrix2DArray, intMatrix2D5);
        System.out.println(intMatrix2D);
        System.out.println(intMatrix2D2);
        System.out.println(intMatrix2D3);
        System.out.println(intMatrix2D4);
    }

    public IntMatrix2D descending(int n, int n2) {
        IntMatrix2D intMatrix2D = this.make(n, n2);
        int n3 = 0;
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = n2;
            while (--n5 >= 0) {
                intMatrix2D.setQuick(n4, n5, n3++);
            }
        }
        return intMatrix2D;
    }

    public IntMatrix2D diagonal(IntMatrix1D intMatrix1D) {
        int n = (int)intMatrix1D.size();
        IntMatrix2D intMatrix2D = this.make(n, n);
        int n2 = n;
        while (--n2 >= 0) {
            intMatrix2D.setQuick(n2, n2, intMatrix1D.getQuick(n2));
        }
        return intMatrix2D;
    }

    public IntMatrix2D diagonal(int[] nArray) {
        int n = nArray.length;
        IntMatrix2D intMatrix2D = this.make(n, n);
        for (int i = 0; i < n; ++i) {
            intMatrix2D.setQuick(i, i, nArray[i]);
        }
        return intMatrix2D;
    }

    public IntMatrix1D diagonal(IntMatrix2D intMatrix2D) {
        int n = Math.min(intMatrix2D.rows(), intMatrix2D.columns());
        IntMatrix1D intMatrix1D = this.make1D(n);
        int n2 = n;
        while (--n2 >= 0) {
            intMatrix1D.setQuick(n2, intMatrix2D.getQuick(n2, n2));
        }
        return intMatrix1D;
    }

    public IntMatrix2D identity(int n) {
        IntMatrix2D intMatrix2D = this.make(n, n);
        int n2 = n;
        while (--n2 >= 0) {
            intMatrix2D.setQuick(n2, n2, 1);
        }
        return intMatrix2D;
    }

    public IntMatrix2D make(int[][] nArray) {
        if (this == sparse) {
            return new SparseIntMatrix2D(nArray);
        }
        return new DenseIntMatrix2D(nArray);
    }

    public IntMatrix2D make(int[] nArray, int n) {
        int n2;
        int n3 = n2 = n != 0 ? nArray.length / n : 0;
        if (n * n2 != nArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        IntMatrix2D intMatrix2D = this.make(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                intMatrix2D.setQuick(i, j, nArray[i + j * n]);
            }
        }
        return intMatrix2D;
    }

    public IntMatrix2D make(int n, int n2) {
        if (this == sparse) {
            return new SparseIntMatrix2D(n, n2);
        }
        if (this == rowCompressed) {
            return new SparseRCIntMatrix2D(n, n2);
        }
        return new DenseIntMatrix2D(n, n2);
    }

    public IntMatrix2D make(int n, int n2, int n3) {
        if (n3 == 0) {
            return this.make(n, n2);
        }
        return this.make(n, n2).assign(n3);
    }

    protected IntMatrix1D make1D(int n) {
        return this.make(0, 0).like1D(n);
    }

    public IntMatrix2D random(int n, int n2) {
        return this.make(n, n2).assign(IntFunctions.random());
    }

    public IntMatrix2D repeat(IntMatrix2D intMatrix2D, int n, int n2) {
        int n3 = intMatrix2D.rows();
        int n4 = intMatrix2D.columns();
        IntMatrix2D intMatrix2D2 = this.make(n3 * n, n4 * n2);
        int n5 = n;
        while (--n5 >= 0) {
            int n6 = n2;
            while (--n6 >= 0) {
                intMatrix2D2.viewPart(n3 * n5, n4 * n6, n3, n4).assign(intMatrix2D);
            }
        }
        return intMatrix2D2;
    }

    public IntMatrix2D sample(int n, int n2, int n3, int n4) {
        IntMatrix2D intMatrix2D = this.make(n, n2);
        this.sample(intMatrix2D, n3, n4);
        return intMatrix2D;
    }

    public IntMatrix2D sample(IntMatrix2D intMatrix2D, int n, int n2) {
        int n3 = intMatrix2D.rows();
        int n4 = intMatrix2D.columns();
        double d = 1.0E-9;
        if ((double)n2 < 0.0 - d || (double)n2 > 1.0 + d) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 1) {
            n2 = 1;
        }
        intMatrix2D.assign(0);
        int n5 = n3 * n4;
        int n6 = Math.round(n5 * n2);
        if (n6 == 0) {
            return intMatrix2D;
        }
        DoubleRandomSamplingAssistant doubleRandomSamplingAssistant = new DoubleRandomSamplingAssistant(n6, n5, new DoubleMersenneTwister());
        for (int i = 0; i < n5; ++i) {
            if (!doubleRandomSamplingAssistant.sampleNextElement()) continue;
            int n7 = i / n4;
            int n8 = i % n4;
            intMatrix2D.set(n7, n8, n);
        }
        return intMatrix2D;
    }
}

