/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseCCLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.WrapperLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongMult;
import cern.jet.math.tlong.LongPlusMultFirst;
import cern.jet.math.tlong.LongPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseRCLongMatrix2D
extends WrapperLongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] rowPointers;
    protected int[] columnIndexes;
    protected long[] values;
    protected boolean columnIndexesSorted;

    private static int searchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -(n2 + 1);
    }

    public SparseRCLongMatrix2D(long[][] lArray) {
        this(lArray.length, lArray.length == 0 ? 0 : lArray[0].length);
        this.assign(lArray);
    }

    public SparseRCLongMatrix2D(int n, int n2) {
        this(n, n2, (int)Math.min(10L * (long)n, Integer.MAX_VALUE));
    }

    public SparseRCLongMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnIndexes = new int[n3];
        this.values = new long[n3];
        this.rowPointers = new int[n + 1];
    }

    public SparseRCLongMatrix2D(int n, int n2, int[] nArray, int[] nArray2, long l, boolean bl, boolean bl2) {
        int n3;
        block8: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block8;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (l == 0L) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int n4 = Math.max(nArray.length, 1);
        this.columnIndexes = new int[n4];
        this.values = new long[n4];
        this.rowPointers = new int[n + 1];
        int[] nArray3 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.rowPointers, nArray3, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.columnIndexes[var11_12] = nArray2[n3];
            this.values[var11_12] = l;
        }
        if (bl) {
            this.removeDuplicates();
        }
        if (bl2) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCLongMatrix2D(int n, int n2, int[] nArray, int[] nArray2, long[] lArray, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        block9: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block9;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (nArray.length != lArray.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int n4 = Math.max(nArray.length, 1);
        this.columnIndexes = new int[n4];
        this.values = new long[n4];
        this.rowPointers = new int[n + 1];
        int[] nArray3 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.rowPointers, nArray3, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.columnIndexes[var11_13] = nArray2[n3];
            this.values[var11_13] = lArray[n3];
        }
        if (bl2) {
            this.removeZeroes();
        }
        if (bl) {
            this.removeDuplicates();
        }
        if (bl3) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCLongMatrix2D(int n, int n2, int[] nArray, int[] nArray2, long[] lArray) {
        block3: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != n + 1) {
            throw new IllegalArgumentException("rowPointers.length != rows + 1");
        }
        this.rowPointers = nArray;
        this.columnIndexes = nArray2;
        this.values = lArray;
    }

    public LongMatrix2D assign(final LongFunction longFunction) {
        if (longFunction instanceof LongMult) {
            long l = ((LongMult)longFunction).multiplicator;
            if (l == 1L) {
                return this;
            }
            if (l == 0L) {
                return this.assign(0L);
            }
            if (l != l) {
                return this.assign(l);
            }
            int n = this.cardinality();
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                this.values[n3] = this.values[n3] * l;
            }
        } else {
            this.forEachNonZero(new IntIntLongFunction(){

                public long apply(int n, int n2, long l) {
                    return longFunction.apply(l);
                }
            });
        }
        return this;
    }

    public LongMatrix2D assign(long l) {
        if (l == 0L) {
            Arrays.fill(this.rowPointers, 0);
            Arrays.fill(this.columnIndexes, 0);
            Arrays.fill(this.values, 0L);
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.values[i] = l;
            }
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D) {
        if (longMatrix2D == this) {
            return this;
        }
        this.checkShape(longMatrix2D);
        if (longMatrix2D instanceof SparseRCLongMatrix2D) {
            SparseRCLongMatrix2D sparseRCLongMatrix2D = (SparseRCLongMatrix2D)longMatrix2D;
            System.arraycopy(sparseRCLongMatrix2D.rowPointers, 0, this.rowPointers, 0, this.rows + 1);
            int n = sparseRCLongMatrix2D.columnIndexes.length;
            if (this.columnIndexes.length < n) {
                this.columnIndexes = new int[n];
                this.values = new long[n];
            }
            System.arraycopy(sparseRCLongMatrix2D.columnIndexes, 0, this.columnIndexes, 0, n);
            System.arraycopy(sparseRCLongMatrix2D.values, 0, this.values, 0, n);
            this.columnIndexesSorted = sparseRCLongMatrix2D.columnIndexesSorted;
        } else if (longMatrix2D instanceof SparseCCLongMatrix2D) {
            SparseCCLongMatrix2D sparseCCLongMatrix2D = ((SparseCCLongMatrix2D)longMatrix2D).getTranspose();
            this.rowPointers = sparseCCLongMatrix2D.getColumnPointers();
            this.columnIndexes = sparseCCLongMatrix2D.getRowIndexes();
            this.values = sparseCCLongMatrix2D.getValues();
            this.columnIndexesSorted = true;
        } else {
            this.assign(0L);
            longMatrix2D.forEachNonZero(new IntIntLongFunction(){

                public long apply(int n, int n2, long l) {
                    SparseRCLongMatrix2D.this.setQuick(n, n2, l);
                    return l;
                }
            });
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D, LongLongFunction longLongFunction) {
        this.checkShape(longMatrix2D);
        if (longMatrix2D instanceof SparseRCLongMatrix2D && longLongFunction == LongFunctions.plus) {
            SparseRCLongMatrix2D sparseRCLongMatrix2D = (SparseRCLongMatrix2D)longMatrix2D;
            int[] nArray = sparseRCLongMatrix2D.rowPointers;
            int[] nArray2 = sparseRCLongMatrix2D.columnIndexes;
            long[] lArray = sparseRCLongMatrix2D.values;
            int[] nArray3 = new int[this.rows + 1];
            int n = Math.max(this.columnIndexes.length, (int)Math.min(Integer.MAX_VALUE, (long)this.rowPointers[this.rows] + (long)nArray[this.rows]));
            int[] nArray4 = new int[n];
            long[] lArray2 = new long[n];
            int n2 = this.rows;
            int n3 = this.columns;
            int n4 = lArray2.length;
            if (longLongFunction == LongFunctions.plus) {
                int n5;
                nArray3[0] = n5 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n6 = this.rowPointers[i];
                    int n7 = nArray[i];
                    int n8 = this.rowPointers[i + 1] - 1;
                    int n9 = nArray[i + 1] - 1;
                    while (n6 <= n8 || n7 <= n9) {
                        int n10;
                        int n11 = n6 <= n8 ? this.columnIndexes[n6] : n3 + 1;
                        if (n11 == (n10 = n7 <= n9 ? nArray2[n7] : n3 + 1)) {
                            lArray2[n5] = this.values[n6] + lArray[n7];
                            nArray4[n5] = n11;
                            ++n6;
                            ++n7;
                            ++n5;
                        } else if (n11 < n10) {
                            nArray4[n5] = n11;
                            lArray2[n5] = this.values[n6];
                            ++n6;
                            ++n5;
                        } else if (n11 > n10) {
                            nArray4[n5] = n10;
                            lArray2[n5] = lArray[n7];
                            ++n7;
                            ++n5;
                        }
                        if (n5 < n4) continue;
                        throw new IllegalArgumentException("The number of elements in C exceeds nzmax");
                    }
                    nArray3[i + 1] = n5;
                }
                this.rowPointers = nArray3;
                this.columnIndexes = nArray4;
                this.values = lArray2;
                return this;
            }
        }
        if (longLongFunction instanceof LongPlusMultSecond) {
            final long l = ((LongPlusMultSecond)longLongFunction).multiplicator;
            if (l == 0L) {
                return this;
            }
            longMatrix2D.forEachNonZero(new IntIntLongFunction(){

                public long apply(int n, int n2, long l2) {
                    SparseRCLongMatrix2D.this.setQuick(n, n2, SparseRCLongMatrix2D.this.getQuick(n, n2) + l * l2);
                    return l2;
                }
            });
            return this;
        }
        if (longLongFunction instanceof LongPlusMultFirst) {
            final long l = ((LongPlusMultFirst)longLongFunction).multiplicator;
            if (l == 0L) {
                return this.assign(longMatrix2D);
            }
            longMatrix2D.forEachNonZero(new IntIntLongFunction(){

                public long apply(int n, int n2, long l2) {
                    SparseRCLongMatrix2D.this.setQuick(n, n2, l * SparseRCLongMatrix2D.this.getQuick(n, n2) + l2);
                    return l2;
                }
            });
            return this;
        }
        if (longLongFunction == LongFunctions.mult) {
            int n = this.rows;
            while (--n >= 0) {
                int n12 = this.rowPointers[n];
                int n13 = this.rowPointers[n + 1];
                while (--n13 >= n12) {
                    int n14 = this.columnIndexes[n13];
                    int n15 = n13;
                    this.values[n15] = this.values[n15] * longMatrix2D.getQuick(n, n14);
                    if (this.values[n13] != 0L) continue;
                    this.remove(n, n14);
                }
            }
            return this;
        }
        if (longLongFunction == LongFunctions.div) {
            int n = this.rows;
            while (--n >= 0) {
                int n16 = this.rowPointers[n];
                int n17 = this.rowPointers[n + 1];
                while (--n17 >= n16) {
                    int n18 = this.columnIndexes[n17];
                    int n19 = n17;
                    this.values[n19] = this.values[n19] / longMatrix2D.getQuick(n, n18);
                    if (this.values[n17] != 0L) continue;
                    this.remove(n, n18);
                }
            }
            return this;
        }
        return super.assign(longMatrix2D, longLongFunction);
    }

    public int cardinality() {
        return this.rowPointers[this.rows];
    }

    public LongMatrix2D forEachNonZero(IntIntLongFunction intIntLongFunction) {
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.rowPointers[n];
            int n3 = this.rowPointers[n + 1];
            while (--n3 >= n2) {
                int n4 = this.columnIndexes[n3];
                long l = this.values[n3];
                long l2 = intIntLongFunction.apply(n, n4, l);
                if (l2 == l) continue;
                this.values[n3] = l2;
            }
        }
        return this;
    }

    public SparseCCLongMatrix2D getColumnCompressed() {
        SparseRCLongMatrix2D sparseRCLongMatrix2D = this.getTranspose();
        SparseCCLongMatrix2D sparseCCLongMatrix2D = new SparseCCLongMatrix2D(this.rows, this.columns);
        sparseCCLongMatrix2D.rowIndexes = sparseRCLongMatrix2D.columnIndexes;
        sparseCCLongMatrix2D.columnPointers = sparseRCLongMatrix2D.rowPointers;
        sparseCCLongMatrix2D.values = sparseRCLongMatrix2D.values;
        sparseCCLongMatrix2D.rowIndexesSorted = true;
        return sparseCCLongMatrix2D;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public DenseLongMatrix2D getDense() {
        final DenseLongMatrix2D denseLongMatrix2D = new DenseLongMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntLongFunction(){

            public long apply(int n, int n2, long l) {
                denseLongMatrix2D.setQuick(n, n2, SparseRCLongMatrix2D.this.getQuick(n, n2));
                return l;
            }
        });
        return denseLongMatrix2D;
    }

    public synchronized long getQuick(int n, int n2) {
        int n3 = SparseRCLongMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        long l = 0L;
        if (n3 >= 0) {
            l = this.values[n3];
        }
        return l;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    public SparseRCLongMatrix2D getTranspose() {
        int n = this.rowPointers[this.rows];
        int[] nArray = new int[this.columns];
        int[] nArray2 = new int[this.columns + 1];
        int[] nArray3 = new int[n];
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.columnIndexes[i];
            nArray[n2] = nArray[n2] + 1;
        }
        this.cumsum(nArray2, nArray, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            int n3 = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n3; ++j) {
                int n4 = this.columnIndexes[j];
                nArray[n4] = nArray[n4] + 1;
                nArray3[i] = i;
                lArray[i] = this.values[j];
            }
        }
        SparseRCLongMatrix2D sparseRCLongMatrix2D = new SparseRCLongMatrix2D(this.columns, this.rows);
        sparseRCLongMatrix2D.rowPointers = nArray2;
        sparseRCLongMatrix2D.columnIndexes = nArray3;
        sparseRCLongMatrix2D.values = lArray;
        return sparseRCLongMatrix2D;
    }

    public long[] getValues() {
        return this.values;
    }

    public boolean hasColumnIndexesSorted() {
        return this.columnIndexesSorted;
    }

    public LongMatrix2D like(int n, int n2) {
        return new SparseRCLongMatrix2D(n, n2);
    }

    public LongMatrix1D like1D(int n) {
        return new SparseLongMatrix1D(n);
    }

    public void removeDuplicates() {
        int n;
        int n2 = 0;
        int[] nArray = new int[this.columns];
        for (n = 0; n < this.columns; ++n) {
            nArray[n] = -1;
        }
        for (int i = 0; i < this.rows; ++i) {
            int n3 = n2;
            for (int j = this.rowPointers[i]; j < this.rowPointers[i + 1]; ++j) {
                n = this.columnIndexes[j];
                if (nArray[n] >= n3) {
                    int n4 = nArray[n];
                    this.values[n4] = this.values[n4] + this.values[j];
                    continue;
                }
                nArray[n] = n2;
                this.columnIndexes[n2] = n;
                this.values[n2++] = this.values[j];
            }
            this.rowPointers[i] = n3;
        }
        this.rowPointers[this.rows] = n2;
    }

    public void removeZeroes() {
        int n = 0;
        for (int i = 0; i < this.rows; ++i) {
            this.rowPointers[i] = n;
            for (int j = this.rowPointers[i]; j < this.rowPointers[i + 1]; ++j) {
                if (this.values[j] == 0L) continue;
                this.values[n] = this.values[j];
                this.columnIndexes[n++] = this.columnIndexes[j];
            }
        }
        this.rowPointers[this.rows] = n;
    }

    public synchronized void setQuick(int n, int n2, long l) {
        int n3 = SparseRCLongMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        if (n3 >= 0) {
            if (l == 0L) {
                this.remove(n, n3);
            } else {
                this.values[n3] = l;
            }
            return;
        }
        if (l != 0L) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, l);
        }
    }

    public void sortColumnIndexes() {
        SparseRCLongMatrix2D sparseRCLongMatrix2D = this.getTranspose();
        this.rows = sparseRCLongMatrix2D.rows;
        this.columns = sparseRCLongMatrix2D.columns;
        this.columnIndexes = sparseRCLongMatrix2D.columnIndexes;
        this.rowPointers = sparseRCLongMatrix2D.rowPointers;
        this.values = sparseRCLongMatrix2D.values;
        sparseRCLongMatrix2D = this.getTranspose();
        this.rows = sparseRCLongMatrix2D.rows;
        this.columns = sparseRCLongMatrix2D.columns;
        this.columnIndexes = sparseRCLongMatrix2D.columnIndexes;
        this.rowPointers = sparseRCLongMatrix2D.rowPointers;
        this.values = sparseRCLongMatrix2D.values;
        this.columnIndexesSorted = true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            int n = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n; ++j) {
                stringBuilder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[j]).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.realloc(0);
    }

    public LongMatrix1D zMult(LongMatrix1D longMatrix1D, LongMatrix1D longMatrix1D2, final long l, final long l2, boolean bl) {
        boolean bl2;
        int n = bl ? this.columns : this.rows;
        int n2 = bl ? this.rows : this.columns;
        boolean bl3 = bl2 = longMatrix1D2 == null || !bl;
        if (longMatrix1D2 == null) {
            longMatrix1D2 = new DenseLongMatrix1D(n);
        }
        if (!(longMatrix1D instanceof DenseLongMatrix1D) || !(longMatrix1D2 instanceof DenseLongMatrix1D)) {
            return super.zMult(longMatrix1D, longMatrix1D2, l, l2, bl);
        }
        if ((long)n2 != longMatrix1D.size() || (long)n > longMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + longMatrix1D.toStringShort() + ", " + longMatrix1D2.toStringShort());
        }
        DenseLongMatrix1D denseLongMatrix1D = (DenseLongMatrix1D)longMatrix1D2;
        final long[] lArray = denseLongMatrix1D.elements;
        final int n3 = denseLongMatrix1D.stride();
        final int n4 = (int)longMatrix1D2.index(0);
        DenseLongMatrix1D denseLongMatrix1D2 = (DenseLongMatrix1D)longMatrix1D;
        final long[] lArray2 = denseLongMatrix1D2.elements;
        final int n5 = denseLongMatrix1D2.stride();
        final int n6 = (int)longMatrix1D.index(0);
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (bl) {
            if (!bl2 && (double)l2 != 1.0) {
                longMatrix1D2.assign(LongFunctions.mult(l2));
            }
            if (n7 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n8;
                int n9;
                n7 = 2;
                Future[] futureArray = new Future[n7];
                final long[] lArray3 = new long[n];
                int n10 = this.rows / n7;
                for (n9 = 0; n9 < n7; ++n9) {
                    n8 = n9 * n10;
                    final int n11 = n9 == n7 - 1 ? this.rows : n8 + n10;
                    final int n12 = n9;
                    futureArray[n9] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (n12 == 0) {
                                for (int i = n8; i < n11; ++i) {
                                    int n = SparseRCLongMatrix2D.this.rowPointers[i + 1];
                                    long l2 = l * lArray2[n6 + n5 * i];
                                    for (int j = SparseRCLongMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                        int n2 = SparseRCLongMatrix2D.this.columnIndexes[j];
                                        int n32 = n4 + n3 * n2;
                                        lArray[n32] = lArray[n32] + SparseRCLongMatrix2D.this.values[j] * l2;
                                    }
                                }
                            } else {
                                for (int i = n8; i < n11; ++i) {
                                    int n = SparseRCLongMatrix2D.this.rowPointers[i + 1];
                                    long l3 = l * lArray2[n6 + n5 * i];
                                    for (int j = SparseRCLongMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                        int n42;
                                        int n52 = n42 = SparseRCLongMatrix2D.this.columnIndexes[j];
                                        lArray3[n52] = lArray3[n52] + SparseRCLongMatrix2D.this.values[j] * l3;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n8 = n9 = n % 10; n8 < n; n8 += 10) {
                    int n13 = n4 + n8 * n3;
                    lArray[n13] = lArray[n13] + lArray3[n8];
                    int n14 = n4 + (n8 + 1) * n3;
                    lArray[n14] = lArray[n14] + lArray3[n8 + 1];
                    int n15 = n4 + (n8 + 2) * n3;
                    lArray[n15] = lArray[n15] + lArray3[n8 + 2];
                    int n16 = n4 + (n8 + 3) * n3;
                    lArray[n16] = lArray[n16] + lArray3[n8 + 3];
                    int n17 = n4 + (n8 + 4) * n3;
                    lArray[n17] = lArray[n17] + lArray3[n8 + 4];
                    int n18 = n4 + (n8 + 5) * n3;
                    lArray[n18] = lArray[n18] + lArray3[n8 + 5];
                    int n19 = n4 + (n8 + 6) * n3;
                    lArray[n19] = lArray[n19] + lArray3[n8 + 6];
                    int n20 = n4 + (n8 + 7) * n3;
                    lArray[n20] = lArray[n20] + lArray3[n8 + 7];
                    int n21 = n4 + (n8 + 8) * n3;
                    lArray[n21] = lArray[n21] + lArray3[n8 + 8];
                    int n22 = n4 + (n8 + 9) * n3;
                    lArray[n22] = lArray[n22] + lArray3[n8 + 9];
                }
                for (n8 = 0; n8 < n9; ++n8) {
                    int n23 = n4 + n8 * n3;
                    lArray[n23] = lArray[n23] + lArray3[n8];
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int n24 = this.rowPointers[i + 1];
                    long l3 = l * lArray2[n6 + n5 * i];
                    for (int j = this.rowPointers[i]; j < n24; ++j) {
                        int n25 = this.columnIndexes[j];
                        int n26 = n4 + n3 * n25;
                        lArray[n26] = lArray[n26] + this.values[j] * l3;
                    }
                }
            }
            return longMatrix1D2;
        }
        if (n7 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n7 = Math.min(n7, this.rows);
            Future[] futureArray = new Future[n7];
            int n27 = this.rows / n7;
            for (int i = 0; i < n7; ++i) {
                final int n28 = i * n27;
                final int n29 = i == n7 - 1 ? this.rows : n28 + n27;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 + n28 * n3;
                        int n2 = SparseRCLongMatrix2D.this.rowPointers[n28];
                        if ((double)l2 == 0.0) {
                            for (int i = n28; i < n29; ++i) {
                                long l3 = 0L;
                                int n32 = SparseRCLongMatrix2D.this.rowPointers[i + 1];
                                while (n2 + 10 < n32) {
                                    int n42 = n2 + 9;
                                    l3 += SparseRCLongMatrix2D.this.values[n42] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n42--]] + SparseRCLongMatrix2D.this.values[n42] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n42--]] + SparseRCLongMatrix2D.this.values[n42] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n42--]] + SparseRCLongMatrix2D.this.values[n42] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n42--]] + SparseRCLongMatrix2D.this.values[n42] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n42--]] + SparseRCLongMatrix2D.this.values[n42] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n42--]] + SparseRCLongMatrix2D.this.values[n42] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n42--]] + SparseRCLongMatrix2D.this.values[n42] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n42--]] + SparseRCLongMatrix2D.this.values[n42] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n42--]] + SparseRCLongMatrix2D.this.values[n42] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n42--]];
                                    n2 += 10;
                                }
                                while (n2 < n32) {
                                    l3 += SparseRCLongMatrix2D.this.values[n2] * lArray2[SparseRCLongMatrix2D.this.columnIndexes[n2]];
                                    ++n2;
                                }
                                lArray[n] = l * l3;
                                n += n3;
                            }
                        } else {
                            for (int i = n28; i < n29; ++i) {
                                long l4 = 0L;
                                int n52 = SparseRCLongMatrix2D.this.rowPointers[i + 1];
                                while (n2 + 10 < n52) {
                                    int n62 = n2 + 9;
                                    l4 += SparseRCLongMatrix2D.this.values[n62] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n62--]] + SparseRCLongMatrix2D.this.values[n62] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n62--]] + SparseRCLongMatrix2D.this.values[n62] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n62--]] + SparseRCLongMatrix2D.this.values[n62] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n62--]] + SparseRCLongMatrix2D.this.values[n62] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n62--]] + SparseRCLongMatrix2D.this.values[n62] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n62--]] + SparseRCLongMatrix2D.this.values[n62] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n62--]] + SparseRCLongMatrix2D.this.values[n62] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n62--]] + SparseRCLongMatrix2D.this.values[n62] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n62--]] + SparseRCLongMatrix2D.this.values[n62] * lArray2[n6 + n5 * SparseRCLongMatrix2D.this.columnIndexes[n62--]];
                                    n2 += 10;
                                }
                                while (n2 < n52) {
                                    l4 += SparseRCLongMatrix2D.this.values[n2] * lArray2[SparseRCLongMatrix2D.this.columnIndexes[n2]];
                                    ++n2;
                                }
                                lArray[n] = l * l4 + l2 * lArray[n];
                                n += n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n30 = n4;
            int n31 = this.rowPointers[0];
            if ((double)l2 == 0.0) {
                for (int i = 0; i < this.rows; ++i) {
                    long l4 = 0L;
                    int n32 = this.rowPointers[i + 1];
                    while (n31 + 10 < n32) {
                        int n33 = n31 + 9;
                        l4 += this.values[n33] * lArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * lArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * lArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * lArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * lArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * lArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * lArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * lArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * lArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * lArray2[n6 + n5 * this.columnIndexes[n33--]];
                        n31 += 10;
                    }
                    while (n31 < n32) {
                        l4 += this.values[n31] * lArray2[this.columnIndexes[n31]];
                        ++n31;
                    }
                    lArray[n30] = l * l4;
                    n30 += n3;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    long l5 = 0L;
                    int n34 = this.rowPointers[i + 1];
                    while (n31 + 10 < n34) {
                        int n35 = n31 + 9;
                        l5 += this.values[n35] * lArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * lArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * lArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * lArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * lArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * lArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * lArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * lArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * lArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * lArray2[n6 + n5 * this.columnIndexes[n35--]];
                        n31 += 10;
                    }
                    while (n31 < n34) {
                        l5 += this.values[n31] * lArray2[this.columnIndexes[n31]];
                        ++n31;
                    }
                    lArray[n30] = l * l5 + l2 * lArray[n30];
                    n30 += n3;
                }
            }
        }
        return longMatrix1D2;
    }

    public LongMatrix2D zMult(LongMatrix2D longMatrix2D, LongMatrix2D longMatrix2D2, long l, long l2, boolean bl, boolean bl2) {
        boolean bl3;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = longMatrix2D.rows();
        int n4 = longMatrix2D.columns();
        if (bl2) {
            n3 = longMatrix2D.columns();
            n4 = longMatrix2D.rows();
        }
        int n5 = n4;
        boolean bl4 = bl3 = longMatrix2D2 == null;
        if (longMatrix2D2 == null) {
            longMatrix2D2 = longMatrix2D instanceof SparseRCLongMatrix2D ? new SparseRCLongMatrix2D(n, n5, n * n5) : new DenseLongMatrix2D(n, n5);
        }
        if (n3 != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? longMatrix2D.viewDice() : longMatrix2D).toStringShort());
        }
        if (longMatrix2D2.rows() != n || longMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? longMatrix2D.viewDice() : longMatrix2D).toStringShort() + ", " + longMatrix2D2.toStringShort());
        }
        if (this == longMatrix2D2 || longMatrix2D == longMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3 && (double)l2 != 1.0) {
            longMatrix2D2.assign(LongFunctions.mult(l2));
        }
        if (longMatrix2D instanceof DenseLongMatrix2D && longMatrix2D2 instanceof DenseLongMatrix2D) {
            SparseRCLongMatrix2D sparseRCLongMatrix2D = bl ? this.getTranspose() : this;
            DenseLongMatrix2D denseLongMatrix2D = bl2 ? (DenseLongMatrix2D)longMatrix2D.viewDice() : (DenseLongMatrix2D)longMatrix2D;
            DenseLongMatrix2D denseLongMatrix2D2 = (DenseLongMatrix2D)longMatrix2D2;
            int[] nArray = sparseRCLongMatrix2D.rowPointers;
            int[] nArray2 = sparseRCLongMatrix2D.columnIndexes;
            long[] lArray = sparseRCLongMatrix2D.values;
            for (int i = 0; i < n; ++i) {
                int n6 = nArray[i + 1];
                for (int j = nArray[i]; j < n6; ++j) {
                    long l3 = lArray[j] * l;
                    int n7 = nArray2[j];
                    denseLongMatrix2D2.viewRow(i).assign(denseLongMatrix2D.viewRow(n7), LongFunctions.plusMultSecond(l3));
                }
            }
        } else if (longMatrix2D instanceof SparseRCLongMatrix2D && longMatrix2D2 instanceof SparseRCLongMatrix2D) {
            int n8;
            SparseRCLongMatrix2D sparseRCLongMatrix2D = (SparseRCLongMatrix2D)longMatrix2D2;
            SparseRCLongMatrix2D sparseRCLongMatrix2D2 = bl ? this.getTranspose() : this;
            SparseRCLongMatrix2D sparseRCLongMatrix2D3 = bl2 ? ((SparseRCLongMatrix2D)longMatrix2D).getTranspose() : (SparseRCLongMatrix2D)longMatrix2D;
            int[] nArray = sparseRCLongMatrix2D2.rowPointers;
            int[] nArray3 = sparseRCLongMatrix2D2.columnIndexes;
            long[] lArray = sparseRCLongMatrix2D2.values;
            int[] nArray4 = sparseRCLongMatrix2D3.rowPointers;
            int[] nArray5 = sparseRCLongMatrix2D3.columnIndexes;
            long[] lArray2 = sparseRCLongMatrix2D3.values;
            int[] nArray6 = sparseRCLongMatrix2D.rowPointers;
            int[] nArray7 = sparseRCLongMatrix2D.columnIndexes;
            long[] lArray3 = sparseRCLongMatrix2D.values;
            int n9 = lArray3.length;
            int[] nArray8 = new int[n4 + 1];
            for (n8 = 0; n8 < nArray8.length; ++n8) {
                nArray8[n8] = -1;
            }
            n8 = -1;
            for (int i = 0; i < n; ++i) {
                int n10;
                int n11 = nArray[i + 1];
                for (n10 = nArray[i]; n10 < n11; ++n10) {
                    long l4 = lArray[n10] * l;
                    int n12 = nArray3[n10];
                    int n13 = nArray4[n12 + 1];
                    for (int j = nArray4[n12]; j < n13; ++j) {
                        int n14 = nArray5[j];
                        int n15 = nArray8[n14];
                        if (n15 == -1) {
                            if (++n8 >= n9) {
                                throw new IllegalArgumentException("The max number of nonzero elements in C is too small.");
                            }
                            nArray7[n8] = n14;
                            nArray8[n14] = n8;
                            lArray3[n8] = l4 * lArray2[j];
                            continue;
                        }
                        int n16 = n15;
                        lArray3[n16] = lArray3[n16] + l4 * lArray2[j];
                    }
                }
                for (n10 = nArray6[i]; n10 < n8 + 1; ++n10) {
                    nArray8[nArray7[n10]] = -1;
                }
                nArray6[i + 1] = n8 + 1;
            }
        } else {
            if (bl2) {
                longMatrix2D = longMatrix2D.viewDice();
            }
            LongMatrix1D[] longMatrix1DArray = new LongMatrix1D[n2];
            int n17 = n2;
            while (--n17 >= 0) {
                longMatrix1DArray[n17] = longMatrix2D.viewRow(n17);
            }
            LongMatrix1D[] longMatrix1DArray2 = new LongMatrix1D[n];
            int n18 = n;
            while (--n18 >= 0) {
                longMatrix1DArray2[n18] = longMatrix2D2.viewRow(n18);
            }
            LongPlusMultSecond longPlusMultSecond = LongPlusMultSecond.plusMult(0L);
            int[] nArray = this.columnIndexes;
            long[] lArray = this.values;
            int n19 = this.rows;
            while (--n19 >= 0) {
                int n20 = this.rowPointers[n19];
                int n21 = this.rowPointers[n19 + 1];
                while (--n21 >= n20) {
                    int n22 = nArray[n21];
                    longPlusMultSecond.multiplicator = lArray[n21] * l;
                    if (!bl) {
                        longMatrix1DArray2[n19].assign(longMatrix1DArray[n22], longPlusMultSecond);
                        continue;
                    }
                    longMatrix1DArray2[n22].assign(longMatrix1DArray[n19], longPlusMultSecond);
                }
            }
        }
        return longMatrix2D2;
    }

    private long cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            l += (long)nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return l;
    }

    private void realloc(int n) {
        if (n <= 0) {
            n = this.rowPointers[this.rows];
        }
        int[] nArray = new int[n];
        int n2 = Math.min(n, this.columnIndexes.length);
        System.arraycopy(this.columnIndexes, 0, nArray, 0, n2);
        this.columnIndexes = nArray;
        long[] lArray = new long[n];
        n2 = Math.min(n, this.values.length);
        System.arraycopy(this.values, 0, lArray, 0, n2);
        this.values = lArray;
    }

    protected LongMatrix2D getContent() {
        return this;
    }

    protected void insert(int n, int n2, int n3, long l) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        LongArrayList longArrayList = new LongArrayList(this.values);
        longArrayList.setSizeRaw(this.rowPointers[this.rows]);
        intArrayList.beforeInsert(n3, n2);
        longArrayList.beforeInsert(n3, l);
        int n4 = this.rowPointers.length;
        while (--n4 > n) {
            int n5 = n4;
            this.rowPointers[n5] = this.rowPointers[n5] + 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = longArrayList.elements();
    }

    protected void remove(int n, int n2) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        LongArrayList longArrayList = new LongArrayList(this.values);
        longArrayList.setSizeRaw(this.rowPointers[this.rows]);
        intArrayList.remove(n2);
        longArrayList.remove(n2);
        int n3 = this.rowPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.rowPointers[n4] = this.rowPointers[n4] - 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = longArrayList.elements();
    }
}

