/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.map.tobject.AbstractLongObjectMap;
import cern.colt.map.tobject.OpenLongObjectHashMap;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.SelectedSparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix3D;

public class SparseObjectMatrix1D
extends ObjectMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongObjectMap elements;

    public SparseObjectMatrix1D(Object[] objectArray) {
        this(objectArray.length);
        this.assign(objectArray);
    }

    public SparseObjectMatrix1D(int n) {
        this(n, n / 1000, 0.2, 0.5);
    }

    public SparseObjectMatrix1D(int n, int n2, double d, double d2) {
        this.setUp(n);
        this.elements = new OpenLongObjectHashMap(n2, d, d2);
    }

    protected SparseObjectMatrix1D(int n, AbstractLongObjectMap abstractLongObjectMap, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = abstractLongObjectMap;
        this.isNoView = false;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractLongObjectMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public synchronized Object getQuick(int n) {
        return this.elements.get((long)this.zero + (long)n * (long)this.stride);
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix1D objectMatrix1D) {
        if (objectMatrix1D instanceof SelectedSparseObjectMatrix1D) {
            SelectedSparseObjectMatrix1D selectedSparseObjectMatrix1D = (SelectedSparseObjectMatrix1D)objectMatrix1D;
            return this.elements == selectedSparseObjectMatrix1D.elements;
        }
        if (objectMatrix1D instanceof SparseObjectMatrix1D) {
            SparseObjectMatrix1D sparseObjectMatrix1D = (SparseObjectMatrix1D)objectMatrix1D;
            return this.elements == sparseObjectMatrix1D.elements;
        }
        return false;
    }

    public long index(int n) {
        return (long)this.zero + (long)n * (long)this.stride;
    }

    public ObjectMatrix1D like(int n) {
        return new SparseObjectMatrix1D(n);
    }

    public ObjectMatrix2D like2D(int n, int n2) {
        return new SparseObjectMatrix2D(n, n2);
    }

    public ObjectMatrix2D reshape(int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        SparseObjectMatrix2D sparseObjectMatrix2D = new SparseObjectMatrix2D(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Object object;
                if ((object = this.getQuick(n3++)) == null) continue;
                ((ObjectMatrix2D)sparseObjectMatrix2D).setQuick(j, i, object);
            }
        }
        return sparseObjectMatrix2D;
    }

    public ObjectMatrix3D reshape(int n, int n2, int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        SparseObjectMatrix3D sparseObjectMatrix3D = new SparseObjectMatrix3D(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    Object object;
                    if ((object = this.getQuick(n4++)) == null) continue;
                    ((ObjectMatrix3D)sparseObjectMatrix3D).setQuick(i, k, j, object);
                }
            }
        }
        return sparseObjectMatrix3D;
    }

    public synchronized void setQuick(int n, Object object) {
        long l = (long)this.zero + (long)n * (long)this.stride;
        if (object == null) {
            this.elements.removeKey(l);
        } else {
            this.elements.put(l, object);
        }
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected ObjectMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseObjectMatrix1D(this.elements, nArray);
    }
}

