/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;

public class DoubleGivensRotation {
    private final double c;
    private final double s;

    public DoubleGivensRotation(double d, double d2) {
        double d3 = Math.abs(d) > Math.abs(d2) ? d : d2;
        double d4 = Math.abs(d) + Math.abs(d2);
        if (d4 != 0.0) {
            double d5 = d / d4;
            double d6 = d2 / d4;
            double d7 = d4 * Math.sqrt(d5 * d5 + d6 * d6);
            if (d3 < 0.0) {
                d7 *= -1.0;
            }
            this.c = d / d7;
            this.s = d2 / d7;
        } else {
            this.c = 1.0;
            this.s = 0.0;
        }
    }

    public void apply(DoubleMatrix2D doubleMatrix2D, int n, int n2, int n3) {
        double d = this.c * doubleMatrix2D.getQuick(n2, n) + this.s * doubleMatrix2D.getQuick(n3, n);
        doubleMatrix2D.setQuick(n3, n, -this.s * doubleMatrix2D.getQuick(n2, n) + this.c * doubleMatrix2D.getQuick(n3, n));
        doubleMatrix2D.setQuick(n2, n, d);
    }

    public void apply(DoubleMatrix1D doubleMatrix1D, int n, int n2) {
        double d = this.c * doubleMatrix1D.getQuick(n) + this.s * doubleMatrix1D.getQuick(n2);
        doubleMatrix1D.setQuick(n2, -this.s * doubleMatrix1D.getQuick(n) + this.c * doubleMatrix1D.getQuick(n2));
        doubleMatrix1D.setQuick(n, d);
    }
}

