/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import edu.emory.mathcs.utils.IOUtils;
import java.util.Random;

public class AccuracyCheckDoubleFFT {
    private static int[] sizesPrimes = new int[]{997, 4999, 9973, 49999, 99991, 249989};
    private static int[] sizesPower2 = new int[]{8192, 16384, 32768, 65536, 131072, 262144};
    private static final int niters = 10;
    private static Random r;

    private AccuracyCheckDoubleFFT() {
    }

    public static void checkAccuracyRealFFT_1D() {
        DenseDoubleMatrix1D denseDoubleMatrix1D;
        DenseDComplexMatrix1D denseDComplexMatrix1D;
        DenseDoubleMatrix1D denseDoubleMatrix1D2;
        int n;
        int n2;
        System.out.println("Checking accuracy of 1D real forward full FFT (prime sizes)...");
        double[][] dArray = new double[10][sizesPrimes.length];
        for (n2 = 0; n2 < sizesPrimes.length; ++n2) {
            r = new Random(0L);
            for (n = 0; n < 10; ++n) {
                denseDoubleMatrix1D2 = new DenseDoubleMatrix1D(sizesPrimes[n2]);
                AccuracyCheckDoubleFFT.fillMatrix_1D(sizesPrimes[n2], denseDoubleMatrix1D2.elements());
                denseDComplexMatrix1D = denseDoubleMatrix1D2.getFft();
                denseDComplexMatrix1D.ifft(true);
                denseDoubleMatrix1D = (DenseDoubleMatrix1D)denseDComplexMatrix1D.getRealPart();
                dArray[n][n2] = AccuracyCheckDoubleFFT.computeRMSE(denseDoubleMatrix1D2.elements(), denseDoubleMatrix1D.elements());
            }
        }
        IOUtils.writeToFileReal_2D("%g", dArray, "pc_rmse_primes_double.txt");
        System.out.println("Checking accuracy of 1D real forward full FFT (power2 sizes)...");
        dArray = new double[10][sizesPower2.length];
        for (n2 = 0; n2 < sizesPower2.length; ++n2) {
            r = new Random(0L);
            for (n = 0; n < 10; ++n) {
                denseDoubleMatrix1D2 = new DenseDoubleMatrix1D(sizesPower2[n2]);
                AccuracyCheckDoubleFFT.fillMatrix_1D(sizesPower2[n2], denseDoubleMatrix1D2.elements());
                denseDComplexMatrix1D = denseDoubleMatrix1D2.getFft();
                denseDComplexMatrix1D.ifft(true);
                denseDoubleMatrix1D = (DenseDoubleMatrix1D)denseDComplexMatrix1D.getRealPart();
                dArray[n][n2] = AccuracyCheckDoubleFFT.computeRMSE(denseDoubleMatrix1D2.elements(), denseDoubleMatrix1D.elements());
            }
        }
        IOUtils.writeToFileReal_2D("%g", dArray, "pc_rmse_power2_double.txt");
    }

    private static double computeRMSE(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d / (double)dArray.length);
    }

    public static void main(String[] stringArray) {
        AccuracyCheckDoubleFFT.checkAccuracyRealFFT_1D();
        System.exit(0);
    }

    private static void fillMatrix_1D(int n, double[] dArray) {
        for (int i = 0; i < n; ++i) {
            dArray[i] = r.nextDouble();
        }
    }
}

