/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.algo.solver.DefaultFloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.FloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;

public class CGLSFloatIterationMonitor
extends DefaultFloatIterationMonitor {
    protected boolean convergedI(float f) throws IterativeSolverFloatNotConvergedException {
        if (this.isFirst()) {
            this.initR = f;
        }
        if (f <= this.rtol) {
            return true;
        }
        if (f > this.dtol * this.initR) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Divergence, this);
        }
        if (this.iter >= this.maxIter) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Iterations, this);
        }
        if (Float.isNaN(f)) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Divergence, this);
        }
        return false;
    }

    protected boolean convergedI(float f, FloatMatrix1D floatMatrix1D) throws IterativeSolverFloatNotConvergedException {
        return this.convergedI(f);
    }
}

