/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tshort;

import cern.colt.PersistentObject;
import cern.colt.buffer.tshort.ShortBuffer2DConsumer;
import cern.colt.list.tshort.ShortArrayList;

public class ShortBuffer2D
extends PersistentObject
implements ShortBuffer2DConsumer {
    private static final long serialVersionUID = 1L;
    protected ShortBuffer2DConsumer target;
    protected short[] xElements;
    protected short[] yElements;
    protected ShortArrayList xList;
    protected ShortArrayList yList;
    protected int capacity;
    protected int size;

    public ShortBuffer2D(ShortBuffer2DConsumer shortBuffer2DConsumer, int n) {
        this.target = shortBuffer2DConsumer;
        this.capacity = n;
        this.xElements = new short[n];
        this.yElements = new short[n];
        this.xList = new ShortArrayList(this.xElements);
        this.yList = new ShortArrayList(this.yElements);
        this.size = 0;
    }

    public void add(short s, short s2) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = s;
        this.yElements[this.size++] = s2;
    }

    public void addAllOf(ShortArrayList shortArrayList, ShortArrayList shortArrayList2) {
        int n = shortArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(shortArrayList, shortArrayList2);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

