% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNIPALS.R
\name{MNIPALS}
\alias{MNIPALS}
\title{Caculate the estimator on the MNIPALS method}
\usage{
MNIPALS(data = 0, data0, real = TRUE, example = FALSE)
}
\arguments{
\item{data}{is the orignal data set}

\item{data0}{is the missing data set}

\item{real}{is to judge whether the data set is a real missing data set}

\item{example}{is to judge whether the data set is a simulation example.}
}
\value{
XMNIPALS, MSEMNIPALS, MAEMNIPALS, REMNIPALS, GCVMNIPALS,timeMNIPALS
}
\description{
Caculate the estimator on the MNIPALS method
}
\examples{
 library(MASS)   
 etatol=0.9
 n=100;p=10;per=0.1
 mu=as.matrix(runif(p,0,10))
 sigma=as.matrix(runif(p,0,1))
 ro=as.matrix(c(runif(p,-1,1)))
 RO=ro\%*\%t(ro);diag(RO)=1
 Sigma=sigma\%*\%t(sigma)*RO
 X0=data=mvrnorm(n,mu,Sigma)
 m=round(per*n*p,digits=0)
 mr=sample(1:(n*p),m,replace=FALSE)
 X0[mr]=NA;data0=X0
 MNIPALS(data=data,data0=data0,real=FALSE,example=FALSE)
}
