% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/itemfit.R
\name{plotenvelope}
\alias{plotenvelope}
\title{Envelopes to evaluate the goodness of fit of the model}
\usage{
plotenvelope(item, numboot, alpha, model, datos)
}
\arguments{
\item{item}{a number indicating the item that you want evaluate}

\item{numboot}{number of iterations bootstrap, used to plot the envelopes}

\item{alpha}{level of significance to plot the envelopes}

\item{model}{object irtpp() type}

\item{datos}{the data}
}
\value{
plot with the envelopes and teh caracteristic curve of the item
}
\description{
Graphic bands of confidence of an item
}
\examples{
#Simulates a test and returns a list:
test=simulateTest()

#the simulated data:
data=test$test

#model:
mod=irtpp(dataset = data,model = "3PL")

#Envelopes:
item=7
numboot=100
alpha=0.05

#call the function:
plotenvelope(item=item,numboot=numboot,alpha=alpha,model=mod,datos=data)
}
\author{
SICS Research, National University of Colombia \email{ammontenegrod@unal.edu.co}
}
\references{
David Thissen, Howard Wainer  D. (1990). Confidence Envelopes for Item Response Theory. \emph{Journal of Educational Statistics, Vol 15, No 2}, 113-128.
}
\seealso{
\code{\link{orlando_itemf}}, \code{\link{z3_itemf}}
}

