% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_inla.R
\name{autoplot.inla}
\alias{autoplot.inla}
\title{Autoplot method for INLA objects}
\usage{
\method{autoplot}{inla}(object, which = c(1:3, 5), priors = FALSE,
  CI = FALSE, ...)
}
\arguments{
\item{object}{An inla object.}

\item{which}{Vector of integers selecting which plots (1 -- 4) are wanted.}

\item{priors}{Logical, plot priors as well.}

\item{CI}{Plot credible intervals. TRUE for 95\% CI or a numeric in [0, 1]}

\item{...}{other arguments passed to methods}
}
\description{
Replicate the plots produced by \code{\link{plot}} using ggplot.
}
\details{
The plot types are
\enumerate{
  \item Marginal plot for fixed effects
  \item Marginal plot for hyper parameters
  \item Marginal line plot for random effects
  \item Marginal boxplot plot for random effects (more informative then 3, but gets big with lots of levels
  \item
}
}
\examples{
\dontrun{
 library(INLA)
 data(Epil)
 ##Define the model
 formula = y ~ Trt + Age + V4 +
          f(Ind, model="iid") + f(rand,model="iid")
 result = inla(formula, family="poisson", data = Epil, control.predictor = list(compute = TRUE))
 plot(result)

 p <- autoplot(result)

 # Change the theme
 p <- p + theme_bw()

 # Add a title to a subplot
 p[2] <- p[2] + ggtitle('Hyper parameters')

 # Switch plot of fixed effects posteriors to not rescale x axis
 #   If variables are on the same scale, this may provide a useful comparison
 p[1] <- p[1] + facet_wrap('var', scale = 'free_y')

# Change colours etc.
p[[1]]$layers[[1]] <- geom_line(colour = 'red', linetype = 2)
}
}
