% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_projection_shapefile.R
\name{ggplot_projection_shapefile}
\alias{ggplot_projection_shapefile}
\title{Plot a raster (either a raster layer or a inla projection matrix) with a shape file}
\usage{
ggplot_projection_shapefile(raster = NULL, projector = NULL,
  spatialpolygons = NULL, mesh = NULL, shapecol = "white")
}
\arguments{
\item{raster}{Either a RasterLayer or a matrix 
(e.g. from \code{\link[INLA]{inla.mesh.project}})}

\item{projector}{If raster is a matrix, a projector object 
(from \code{\link[INLA]{inla.mesh.projector}}) is also needed.}

\item{spatialpolygons}{A \code{\link[sp]{SpatialPolygonsDataFrame}} object.}

\item{mesh}{An inla.mesh object to be plotted. Still rough.}

\item{shapecol}{Colour for the shape file outlines.}
}
\description{
Plot a raster (either a raster layer or a inla projection matrix) with a shape file
}
\examples{
set.seed(2)
library(INLA)

# Create inla projector
n <- 20
loc <- matrix(runif(n*2), n, 2)
mesh <- inla.mesh.create(loc, refine=list(max.edge=0.05))
projector <- inla.mesh.projector(mesh)

field <- cos(mesh$loc[,1]*2*pi*3)*sin(mesh$loc[,2]*2*pi*7)
projection <- inla.mesh.project(projector, field)

# And the shape file
crds <- loc[chull(loc), ]
SPls <- SpatialPolygons(list(Polygons(list(Polygon(crds)), ID = 'a')))

ggplot_projection_shapefile(projection, projector, SPls) + theme_minimal()


# Alternatively plot a raster
library(raster)
raster <- raster(projection)
extent(raster) <- c(range(projector$x), range(projector$y))
ggplot_projection_shapefile(raster, spatialpolygons = SPls)

}
