% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_component.R
\name{plot_component}
\alias{plot_component}
\title{Plot the AIC or BIC Values for Model Selection}
\usage{
plot_component(res_select, type = c("AIC", "BIC"))
}
\arguments{
\item{res_select}{Result output from function model_selection_component()}

\item{type}{Which information criteria to use for plot}
}
\value{
Plot for the model selection of components
}
\description{
Plot the result output of model selection for components based on AIC and BIC values in IMIX
}
\examples{
\donttest{
# First load the data
data("data_p")

# Perform model selections on the data
select_comp1 <- model_selection_component(data_p, data_type = "p", seed = 20)

# Make a plot for BIC values
plot_component(select_comp1, type = "BIC")
}
}
\references{
Ziqiao Wang and Peng Wei. 2020. “IMIX: a multivariate mixture model approach to association analysis through multi-omics data integration.” Bioinformatics. \url{https://doi.org/10.1093/bioinformatics/btaa1001}.
}
