% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/role.R
\name{Midlayer_role}
\alias{Midlayer_role}
\title{Analyzising role of interconnecting node in motifs}
\usage{
Midlayer_role(network.or.subnet_mat1, subnet_mat2 = NULL)
}
\arguments{
\item{network.or.subnet_mat1}{Either a multilayer(tripartite) network of 'igraph' class which contains interlayer links and without intralayer links, or a numeric matrix(or data.frame) representing interactions between two groups of species.
Each row and column of matrix represents single species in the second and first groups of the tripartite network respectively.
Elements of matrix are non-zero numbers if the two groups of species are connected, and 0 otherwise.}

\item{subnet_mat2}{A numeric matrix(or data.frame) representing interactions between two groups of species.
Each row and column of matrix represents single species in the second and third groups of the tripartite network respectively.
Elements of matrix are non-zero numbers if the two groups of species are connected, and 0 otherwise. If \code{network.or.subnet_mat1} is "igraph", \code{subnet_mat2} defaults to NULL.}
}
\value{
Returns a matrix of 65 columns representing the roles of interconnecting species in the motifs. Columns names are Role1, Role2, Role3 ... Role65.

Each row of matrix corresponds to a interconnecting species in the second layer of network. If a interconnecting species is linked to both the second and third level species, the elements in this row are not all zero, otherwise the elements are all zero.
}
\description{
Counting the number of 65 roles about interconnecting species in multilayer network motifs.
}
\details{
\strong{network.or.subnet_mat1} and \strong{subnet_mat2}

There are two types of \code{network.or.subnet_mat1} that can be processed:
\itemize{
\item{(1). Input in a network of type "igraph" alone.}
\item{(2). Must be entered as data frame or matrix with \code{subnet_mat2}.}
}

If the type of inputting is data frame or matrix, please make sure the row of \code{network.or.subnet_mat1} and \code{subnet_mat2} correspond with the second group of species that both belong to two subnetworks and interact with other groups of species.
\itemize{
\item{Try to make the rows of both matrices have the same attributes. Or we default:}

\item{When the two matrices can have different numbers of rows:}
\itemize{
\item{(1). If both matrices have row names, then the function counts all row names to produce two new matrices with the same row names.}
\item{(2). If at most one matrix has row names, the function assigns new row names to both matrices on a row-to-row basis (any extra row names are assigned a new value) and then counts all row names to produce two new matrices with the same row names.}
}

\item{When the two matrices can have the same numbers of rows:}
\itemize{
\item{No matter how the row names of the two matrices are arranged, as long as the row names are exactly the same; But we don't handle matrices with empty row names (the function will give an error).}
}

\item{The two matrices can have different numbers of rows, but read our default handling carefully to make sure the calculation is accurate when using this function!!!}
}
About a network of type "igraph", It can be obtained from the connection matrices of subnetworks by the function \code{igraph_from_matrices}.
}
\examples{

set.seed(12)
d <- build_net(11,22,21,0.2)
Midlayer_role(d)

set.seed(12)
MAT <- build_net(11,22,21,0.2,asmatrices=TRUE)

Midlayer_role(MAT[[3]],MAT[[4]])

md1<-matrix(sample(c(0,1),88,replace=TRUE),8,11)
md2<-matrix(sample(c(0,1),120,replace=TRUE),10,12)
Midlayer_role(md1,md2)

R<-rownames(MAT[[4]])[12]
MR<-MAT[[4]][12,]
MAT[[4]]<-MAT[[4]][-12,]
MAT[[4]]<-rbind(MAT[[4]],MR)
rownames(MAT[[4]])[22]<-R

Midlayer_role(MAT[[3]],MAT[[4]])


}
\references{
Simmons, B. I., Sweering, M. J., Schillinger, M., Dicks, L. V., Sutherland, W. J., & Di Clemente, R. (2019). bmotif: A package for motif analyses of bipartite networks. Methods in Ecology and Evolution, 10(5), 695-701.
}
