% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectDisplay.R
\name{objectDisplay}
\alias{objectDisplay}
\title{Object Display}
\usage{
objectDisplay(
  image,
  input_range = c(0, 4095),
  full_range = FALSE,
  force_range = FALSE,
  gamma = 1,
  color = "Green",
  dpi = 300
)
}
\arguments{
\item{image}{An object extracted by \code{\link{objectExtract}} of class `IFC_img` or `IFC_msk`.\cr
Note that a matrix with finite values can also be used.}

\item{input_range}{a finite numeric vector of 2 values, sets the range of the input intensity values.\cr
Values exceeding this range are clipped. Default is 'c(0, 4095)'.}

\item{full_range}{if 'full_range' is TRUE, then 'input_range' will be set to 'c(0, 4095)' and 'gamma' forced to 1. Default is FALSE.}

\item{force_range}{if 'force_range' is TRUE, then 'input_range' will be adjusted to object range in [-4095, +inf] and 'gamma' forced to 1. Default is FALSE.\cr
Note that this parameter takes the precedence over 'input_range' and 'full_range'.}

\item{gamma}{gamma correction. Default is 1, for no correction.}

\item{color}{a color. Default is "Green".}

\item{dpi}{display resolution. Default is 300.}
}
\value{
it invisibly returns NULL
}
\description{
This function is intended to display object extracted by \code{\link{objectExtract}}.
}
\details{
If input 'image' is of class `IFC_img` or `IFC_msk`, then if 'input_range', 'full_range', 'force_range', 'gamma' and / or 'color' parameters is/are missing,
it/they will be extracted from 'image' attributes.\cr
If input 'image' is not of one of class `IFC_img` or `IFC_msk`, then force_range will be forced to TRUE.\cr
An error will be thrown if input image contains non finite values.
}
