% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcs.R
\name{ExportToFCS}
\alias{ExportToFCS}
\title{FCS File Writer}
\usage{
ExportToFCS(
  obj,
  write_to,
  overwrite = FALSE,
  delimiter = "/",
  cytometer = "Image Stream",
  ...
)
}
\arguments{
\item{obj}{an `IFC_data` object extracted with features extracted.}

\item{write_to}{pattern used to export file.
Placeholders, like "\%d/\%s_fromR.\%e", will be substituted:\cr
-\%d: with full path directory of 'obj$fileName'\cr
-\%p: with first parent directory of 'obj$fileName'\cr
-\%e: with extension of 'obj$fileName' (without leading .)\cr
-\%s: with shortname from 'obj$fileName' (i.e. basename without extension).\cr
Exported file extension will be deduced from this pattern. Note that it has to be a .fcs.}

\item{overwrite}{whether to overwrite file or not. Default is FALSE.
Note that if TRUE, it will overwrite exported file if path of 'fileName' and deduced from 'write_to' arguments are different.
Otherwise, you will get an error saying that overwriting source file is not allowed.\cr
Note also that an original file will never be overwritten.}

\item{delimiter}{an ASCII character to separate the FCS keyword-value pairs. Default is : "/".}

\item{cytometer}{string, if provided it to use to fill $CYT keyword.\cr
However, when missing it will be filled with obj$description$FCS$instrument if found, otherwise "Image Stream" will be used.}

\item{...}{other arguments to be passed.}
}
\value{
invisibly returns full path of exported file.
}
\description{
Writes an `IFC_data` object to a Flow Cytometry Standard (FCS) file.
}
