% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transdistfuncs.r
\name{est.transdist.bootstrap.ci}
\alias{est.transdist.bootstrap.ci}
\title{Bootstrap mean transmission distance values}
\usage{
est.transdist.bootstrap.ci(epi.data, gen.t.mean, gen.t.sd, t1, max.sep,
  max.dist, n.transtree.reps = 100, mean.equals.sd = FALSE,
  theta.weights = NULL, boot.iter, ci.low = 0.025, ci.high = 0.975,
  parallel = FALSE, n.cores = NULL)
}
\arguments{
\item{epi.data}{a three-column matrix giving the coordinates (\code{x} and \code{y}) and time of infection (\code{t} for all cases in an epidemic (columns must be in \code{x}, \code{y}, \code{t} order)}

\item{gen.t.mean}{mean generation time of the infecting pathogen}

\item{gen.t.sd}{standard deviation of generation time of the infecting pathogen}

\item{t1}{time step to begin estimation of transmission distance}

\item{max.sep}{maximum number of time steps allowed between two cases (passed to the \code{get.transdist.theta} function)}

\item{max.dist}{maximum spatial distance between two cases considered in calculation}

\item{n.transtree.reps}{number of time to simulate transmission trees when estimating the weights of theta (passed to the \code{est.transdist.theta.weights} function, default = 10). Warning: higher values of this parameter cause significant increases in computation time.}

\item{mean.equals.sd}{logical term indicating if the mean and standard deviation of the transmission kernel are expected to be equal (default = FALSE)}

\item{theta.weights}{use external matrix of theta weights. If NULL (default) the matrix of theta weights is automatically estimated by calling the \code{est.transdist.theta.weights} function}

\item{boot.iter}{the number of bootstrapped iterations to perform}

\item{ci.low}{low end of the confidence interval (default = 0.025)}

\item{ci.high}{high end of the confidence interval (default = 0.975)}

\item{parallel}{run bootstraps in parallel (default = FALSE)}

\item{n.cores}{number of cores to use when \code{parallel} = TRUE (default = NULL, which uses half the available cores)}
}
\value{
a list object containing the point estimate for mean transmission distance and low and high bootstrapped confidence intervals
}
\description{
Runs \code{est.trandsdist} on multiple bootstraps of the data and calculates confidence intervals for the mean transmission distance.
}
\examples{
\donttest{

set.seed(1)

# Exponentially distributed transmission kernel with mean and standard deviation = 100
dist.func <- alist(n=1, a=1/100, rexp(n, a)) 

# Simulate epidemic
a <- sim.epidemic(R=2.5,
                  gen.t.mean=7,
                  gen.t.sd=2,
                  min.cases=20,
                  tot.generations=5,
                  trans.kern.func=dist.func)

# Estimate mean transmission kernel and its bootstrapped confidence intervals
b <- est.transdist.bootstrap.ci(epi.data=a,
                                gen.t.mean=7,
                                gen.t.sd=2,
                                t1=0,
                                max.sep=1e10,
                                max.dist=1e10,
                                n.transtree.reps=10,
                                mean.equals.sd=TRUE,
                                boot.iter=10,
                                ci.low=0.025,
                                ci.high=0.975,
                                parallel=FALSE)
b

}
}
\references{
Salje H, Cummings DAT and Lessler J (2016). “Estimating infectious disease transmission distances using the overall distribution of cases.” Epidemics, 17, pp. 10–18. ISSN 1755-4365, doi: \href{https://www.sciencedirect.com/science/article/pii/S1755436516300317}{10.1016/j.epidem.2016.10.001}.
}
\seealso{
Other transdist: \code{\link{est.transdist.temporal.bootstrap.ci}},
  \code{\link{est.transdist.temporal}},
  \code{\link{est.transdist.theta.weights}},
  \code{\link{est.transdist}},
  \code{\link{get.transdist.theta}}
}
\author{
John Giles, Justin Lessler, and Henrik Salje
}
\concept{transdist}
